/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.MatchPlanEnum;
import kd.tmc.cdm.common.helper.BatchQueryHelper;
import kd.tmc.cdm.common.model.match.SmartMatch;
import kd.tmc.fbp.common.compare.CompareEngine;
import kd.tmc.fbp.common.compare.concurrent.MultiThreadOperationExecutor;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;
import kd.tmc.fbp.common.compare.strategy.StandardCompareStrategy;
import kd.tmc.fbp.common.dao.MatchData;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RecBillAutoMatchCalHelper {
    private static final Log logger = LogFactory.getLog(RecBillAutoMatchCalHelper.class);
    private static final String[] STATIC_MATCH_FIELD = new String[]{"id", "matchentity.id", "matchentity.seq", "matchentity.e_rulesname", "matchentity.e_matchplan_real_TAG"};
    private static final String BIZ_ENTITY_NAME = "cas_recbill";

    public static List<Pair<Object, List<CompareResult>>> autoMatchCal(Set<Object> companyIds, Map<Object, List<Object>> tdIdMap) {
        return new MultiThreadOperationExecutor().doBatchOperation(new ArrayList<Object>(companyIds), 4, dataList -> {
            ArrayList<Pair<Object, List<CompareResult>>> results = new ArrayList<Pair<Object, List<CompareResult>>>(16);
            for (Object companyPK : dataList) {
                DynamicObjectCollection smartMatchDCs = RecBillAutoMatchCalHelper.getSmartMatchDOC(companyPK);
                logger.info("RecBillAutoMatchCalHelper.autoMatchCal smartMatchDCs.size ={}", (Object)(smartMatchDCs == null ? 0 : smartMatchDCs.size()));
                if (smartMatchDCs == null || smartMatchDCs.size() <= 0) {
                    return null;
                }
                for (DynamicObject smartMatchDC : smartMatchDCs) {
                    Pair<Object, List<CompareResult>> result = RecBillAutoMatchCalHelper.calForThread(companyPK, (List)tdIdMap.get(companyPK), smartMatchDC);
                    if (result == null) continue;
                    results.add(result);
                }
            }
            logger.info("RecBillAutoMatchCalHelper.autoMatchCal results.size ={}", (Object)results.size());
            return results;
        });
    }

    private static Pair<Object, List<CompareResult>> calForThread(Object companyIds, List<Object> tdIdList, DynamicObject matchPlanDy) {
        logger.info("------\u5f02\u6b65\u8c03\u7528\u8ba1\u7b97\u5f00\u59cb,: " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId() + "------");
        MatchData matchData = RecBillAutoMatchCalHelper.transMatchDate(companyIds, tdIdList, matchPlanDy);
        if (matchData == null) {
            return null;
        }
        CompareEngine engine = new CompareEngine(matchData.getSrcDataList(), matchData.getTarDataList());
        StandardCompareStrategy strategy = new StandardCompareStrategy((List)matchData.getRules().get(0));
        List resultList = engine.compare((ICompareStrategy)strategy);
        logger.info("RecBillAutoMatchCalHelper.calForThread resultList.size ={}", (Object)resultList.size());
        logger.info("------\u5f02\u6b65\u8c03\u7528\u8ba1\u7b97\u5b8c\u6210,: " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId() + "------");
        return Pair.of((Object)matchData.getRuleId(), (Object)resultList);
    }

    private static MatchData transMatchDate(Object companyPK, List<Object> tdIdList, DynamicObject matchPlanDy) {
        List bizBillDCs;
        logger.info("RecBillAutoMatchCalHelper.transMatchDate matchPlanDy ={}", (Object)(matchPlanDy == null ? 0L : matchPlanDy.getLong("matchentity.id")));
        if (matchPlanDy == null) {
            return null;
        }
        ArrayList ruleList = new ArrayList(4);
        Set<String> detailDateFields = RecBillAutoMatchCalHelper.getDateFields("cdm_receivablebill");
        Set<String> bizDateFields = RecBillAutoMatchCalHelper.getDateFields(BIZ_ENTITY_NAME);
        HashSet recBillFields = Sets.newHashSetWithExpectedSize((int)10);
        HashSet bizFields = Sets.newHashSetWithExpectedSize((int)10);
        String matchPlan = matchPlanDy.getString("matchentity.e_matchplan_real_TAG");
        if (!StringUtils.isEmpty((CharSequence)matchPlan)) {
            JSONArray matchPlanArr = (JSONArray)JSONObject.parse((String)matchPlan);
            List smartMatches = matchPlanArr.toJavaList(SmartMatch.class);
            ArrayList<CompareRule> rules = new ArrayList<CompareRule>(smartMatches.size());
            for (Object sm : smartMatches) {
                recBillFields.add(sm.getRecbillfields());
                bizFields.add(sm.getBizfields());
                rules.add(RecBillAutoMatchCalHelper.transRule((SmartMatch)sm));
            }
            ruleList.add(rules);
        }
        bizFields.add("id");
        recBillFields.add("id");
        recBillFields.add("bizdate");
        QFilter recFilter = new QFilter("rectype", "=", (Object)" ");
        recFilter.and(new QFilter("rulename", "=", (Object)" "));
        recFilter.and(new QFilter("claimnoticebillno", "=", (Object)" "));
        recFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        List receivableBills = BatchQueryHelper.batchQuery(tdIdList, (String)"cdm_receivablebill", (String)"id", (String)String.join((CharSequence)",", recBillFields), (QFilter)recFilter);
        logger.info("RecBillAutoMatchCalHelper.transMatchDate receivableBills.size ={}", (Object)receivableBills.size());
        ArrayList srcDataList = new ArrayList(receivableBills.size());
        Date startDate = null;
        for (DynamicObject orgTransDetail : receivableBills) {
            Date bizDate = orgTransDetail.getDate("bizdate");
            if (startDate == null || bizDate.compareTo(startDate) < 0) {
                startDate = bizDate;
            }
            HashMap<String, Object> srcDataMap = new HashMap<String, Object>();
            for (String detailField : recBillFields) {
                if (detailDateFields.contains(detailField)) {
                    String dateStr = DateUtils.formatString((Date)orgTransDetail.getDate(detailField), (String)"yyyy-MM-dd");
                    srcDataMap.put(detailField, dateStr);
                    continue;
                }
                srcDataMap.put(detailField, orgTransDetail.get(detailField));
            }
            srcDataList.add(srcDataMap);
        }
        if (startDate == null) {
            return null;
        }
        Date endDate = DateUtils.getNextDay((Date)DateUtils.getDataFormat((Date)new Date(), (boolean)true), (int)1);
        ArrayList<Date> queryDates = new ArrayList<Date>();
        while (startDate.compareTo(endDate) < 0) {
            queryDates.add(startDate);
            startDate = DateUtils.getNextDay((Date)startDate, (int)1);
        }
        if (EmptyUtil.isEmpty(queryDates)) {
            logger.info("queryDates is null");
            queryDates.add(DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        }
        logger.info("RecBillAutoMatchCalHelper.transMatchDate bizBillDCs.size ={}", (Object)((bizBillDCs = new MultiThreadOperationExecutor().doBatchOperation(queryDates, 5, dataList -> {
            QFilter recBillFilter = new QFilter("org", "=", companyPK);
            recBillFilter.and(new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C"}));
            recBillFilter.and(new QFilter("sourcebilltype", "!=", (Object)"cas_claimcenterbill"));
            recBillFilter.and(new QFilter("settletype.settlementtype", "in", (Object)new String[]{"1", "2", "5", "6"}));
            recBillFilter.and(QFilter.isNull((String)"cas_draftinfo.draftbillinfo"));
            bizFields.add("bankcheckflag_tag");
            DynamicObjectCollection queryCol = QueryServiceHelper.query((String)BIZ_ENTITY_NAME, (String)String.join((CharSequence)",", bizFields), (QFilter[])new QFilter[]{recBillFilter});
            for (int i = 0; i < queryCol.size(); ++i) {
                if (StringUtils.isEmpty((CharSequence)((DynamicObject)queryCol.get(i)).getString("bankcheckflag_tag"))) continue;
                queryCol.remove(i);
            }
            return queryCol;
        })) == null ? 0 : bizBillDCs.size()));
        if (bizBillDCs == null || bizBillDCs.size() <= 0) {
            return null;
        }
        ArrayList<HashMap> tarDataList = new ArrayList<HashMap>(bizBillDCs.size());
        for (DynamicObject bizBillDy : bizBillDCs) {
            HashMap recBillMap = Maps.newHashMapWithExpectedSize((int)bizFields.size());
            for (String bizField : bizFields) {
                if (bizDateFields.contains(bizField)) {
                    String dateStr = "";
                    if (!ObjectUtils.isEmpty((Object)bizBillDy.get(bizField))) {
                        dateStr = DateUtils.formatString((Date)bizBillDy.getDate(bizField), (String)"yyyy-MM-dd");
                    }
                    recBillMap.put(bizField, dateStr);
                    continue;
                }
                recBillMap.put(bizField, bizBillDy.get(bizField));
            }
            tarDataList.add(recBillMap);
        }
        MatchData md = new MatchData();
        md.setRuleId((Object)matchPlanDy.getLong("matchentity.id"));
        md.setRules(ruleList);
        md.setSrcDataList(srcDataList);
        md.setTarDataList(tarDataList);
        md.setMultiCompareList(Collections.singletonList(Boolean.TRUE));
        return md;
    }

    private static DynamicObjectCollection getSmartMatchDOC(Object companyId) {
        QFilter rulCommonFilter = RecBillAutoMatchCalHelper.getRulCommonFilter(companyId, false);
        DynamicObjectCollection recBillMatchRule = QueryServiceHelper.query((String)"cdm_recbill_matchrule", (String)String.join((CharSequence)",", STATIC_MATCH_FIELD), (QFilter[])new QFilter[]{rulCommonFilter}, (String)"matchentity.seq asc");
        if (recBillMatchRule == null || recBillMatchRule.size() <= 0) {
            rulCommonFilter = RecBillAutoMatchCalHelper.getRulCommonFilter(companyId, true);
            recBillMatchRule = QueryServiceHelper.query((String)"cdm_recbill_matchrule", (String)String.join((CharSequence)",", STATIC_MATCH_FIELD), (QFilter[])new QFilter[]{rulCommonFilter}, (String)"matchentity.seq asc");
        }
        return recBillMatchRule;
    }

    private static QFilter getRulCommonFilter(Object companyId, Boolean isFaceAllOrg) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", companyId));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        return filter;
    }

    private static Set<String> getDateFields(String entryName) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            IDataEntityProperty fieldProp = transField.getFieldProp();
            if (!(fieldProp instanceof DateProp) && !(fieldProp instanceof TimeProp) && !(fieldProp instanceof DateTimeProp) && !(fieldProp instanceof ModifyDateProp) && !(fieldProp instanceof CreateDateProp)) continue;
            dateFields.add(transField.getFullFieldName());
        }
        return dateFields;
    }

    private static CompareRule transRule(SmartMatch smartMatch) {
        CompareRule r = new CompareRule();
        r.setSymbol(RecBillAutoMatchCalHelper.transSymbol(smartMatch.getRelation()));
        if (!StringUtils.isEmpty((CharSequence)smartMatch.getNum())) {
            try {
                r.setExtraVal((Object)Integer.valueOf(smartMatch.getNum()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        r.setPropNameSrc(smartMatch.getRecbillfields());
        r.setPropNameTgt(smartMatch.getBizfields());
        if (StringUtils.isNotBlank((CharSequence)smartMatch.getIsnullmatch())) {
            r.setNullMatch((smartMatch.getIsnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)smartMatch.getIsallnullmatch())) {
            r.setAllNullMatch((smartMatch.getIsallnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        } else if (smartMatch.getIsnullmatch().equals("true")) {
            r.setAllNullMatch(true);
        }
        return r;
    }

    private static CompareRule.Symbol transSymbol(String relation) {
        if (MatchPlanEnum.DIFF.getValue().equals(relation)) {
            return CompareRule.Symbol.DATE_DIFF;
        }
        if (MatchPlanEnum.LIKE.getValue().equals(relation)) {
            return CompareRule.Symbol.STR_MATCH;
        }
        return CompareRule.Symbol.EQUALS;
    }
}

