/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.helper.RecBillAutoMatchCalHelper;
import kd.tmc.cdm.common.enums.RecTypeEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RecBillAutoMatchHelper {
    private static final Log logger = LogFactory.getLog(RecBillAutoMatchHelper.class);
    private static final String BIZ_ENTITY_NAME = "cas_recbill";

    public static Map<Long, String> autoMatch(List<Long> selectIds) {
        DynamicObject[] selectRows;
        if (selectIds == null || selectIds.size() <= 0) {
            return null;
        }
        if (selectIds.size() > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u5339\u914d\u7684\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e07\u6761\u3002", (String)"AutoMatchHelper_01", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        logger.info("RecBillAutoMatchHelper.autoMatch selectIds ={}", (Object)selectIds.toString());
        HashSet<Object> companyPKs = new HashSet<Object>(selectIds.size());
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>(4);
        for (DynamicObject row : selectRows = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"))) {
            long companyId = row.getDynamicObject("company").getLong("id");
            String draftBillStatus = row.getString("draftbillstatus");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            String noticeClaimAllowStatus = (String)TmcParameterHelper.getAppParameter((String)appId, (Long)companyId, (String)"noticeclaimallowstatus");
            if (!noticeClaimAllowStatus.contains(draftBillStatus)) continue;
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row.getPkValue());
            tdIdMap.put(companyId, tdIdList);
        }
        if (companyPKs.size() == 0) {
            return null;
        }
        List<Pair<Object, List<CompareResult>>> results = RecBillAutoMatchCalHelper.autoMatchCal(companyPKs, tdIdMap);
        logger.info("RecBillAutoMatchHelper.autoMatch results.size ={}", (Object)results.size());
        return RecBillAutoMatchHelper.dealMatchResult(results);
    }

    private static Map<Long, String> dealMatchResult(List<Pair<Object, List<CompareResult>>> results) {
        HashMap<Long, String> successCdmRecBillMap = new HashMap<Long, String>(results.size());
        if (results.size() > 0) {
            for (Pair<Object, List<CompareResult>> result : results) {
                List rs = (List)result.getRight();
                if (rs == null || rs.size() <= 0) continue;
                Object matchEntityId = result.getLeft();
                QFilter matchRuleFilter = new QFilter("matchentity.id", "=", matchEntityId);
                DynamicObjectCollection recBillMatchRule = QueryServiceHelper.query((String)"cdm_recbill_matchrule", (String)"id", (QFilter[])new QFilter[]{matchRuleFilter}, (String)"matchentity.seq asc");
                if (recBillMatchRule.size() == 0) {
                    logger.info("RecBillAutoMatchHelper.dealMatchResult recBillMatchRule matchentity.id {},not exist", matchEntityId);
                    continue;
                }
                DynamicObject[] matchRule = BusinessDataServiceHelper.load((Object[])new Object[]{((DynamicObject)recBillMatchRule.get(0)).getLong("id")}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_recbill_matchrule"));
                Date startDate = matchRule[0].getDate("startdate");
                boolean autoReceivingRec = matchRule[0].getBoolean("autoreceivingrec");
                List recBillMatchRuleDB = matchRule[0].getDynamicObjectCollection("matchentity").stream().filter(o -> Long.parseLong(matchEntityId.toString()) == o.getLong("id")).collect(Collectors.toList());
                for (DynamicObject matchEntity : recBillMatchRuleDB) {
                    Map<Long, String> manyByOneMatchMap;
                    Map<Long, String> oneByOneMatchMap;
                    String detailConditionReal = matchEntity.getString("detailcondition_real_TAG");
                    String bizConditionReal = matchEntity.getString("bizcondition_real_TAG");
                    boolean multipleMatch = matchEntity.getBoolean("e_multiplematch");
                    String matchRel = matchEntity.getString("e_matchrel");
                    if ("one-one".equals(matchRel)) {
                        oneByOneMatchMap = RecBillAutoMatchHelper.oneByOneMatch(rs, startDate, matchRel, multipleMatch, bizConditionReal, detailConditionReal, matchRule, matchEntity, autoReceivingRec);
                        successCdmRecBillMap.putAll(oneByOneMatchMap);
                        continue;
                    }
                    if ("many-one".equals(matchRel)) {
                        oneByOneMatchMap = RecBillAutoMatchHelper.oneByOneMatch(rs, startDate, matchRel, multipleMatch, bizConditionReal, detailConditionReal, matchRule, matchEntity, autoReceivingRec);
                        successCdmRecBillMap.putAll(oneByOneMatchMap);
                        manyByOneMatchMap = RecBillAutoMatchHelper.manyByOneMatch(rs, startDate, matchRel, multipleMatch, bizConditionReal, detailConditionReal, matchRule, matchEntity, autoReceivingRec);
                        successCdmRecBillMap.putAll(manyByOneMatchMap);
                        continue;
                    }
                    if (!"one-many".equals(matchRel)) continue;
                    oneByOneMatchMap = RecBillAutoMatchHelper.oneByOneMatch(rs, startDate, matchRel, multipleMatch, bizConditionReal, detailConditionReal, matchRule, matchEntity, autoReceivingRec);
                    successCdmRecBillMap.putAll(oneByOneMatchMap);
                    manyByOneMatchMap = RecBillAutoMatchHelper.oneByManyMatch(rs, startDate, matchRel, multipleMatch, bizConditionReal, detailConditionReal, matchRule, matchEntity, autoReceivingRec);
                    successCdmRecBillMap.putAll(manyByOneMatchMap);
                }
            }
        }
        return successCdmRecBillMap;
    }

    private static Map<Long, String> oneByOneMatch(List<CompareResult> rs, Date startDate, String matchRel, boolean multipleMatch, String bizConditionReal, String detailConditionReal, DynamicObject[] matchRule, DynamicObject matchEntity, boolean autoReceivingRec) {
        HashMap<Long, String> successCdmRecBillMap = new HashMap<Long, String>(rs.size());
        if ("one-one".equals(matchRel) || "many-one".equals(matchRel)) {
            for (CompareResult cs : rs) {
                Map<Set, List<CompareResult>> rsGroup = rs.stream().filter(o -> cs.getSrcIdSet().equals(o.getSrcIdSet())).collect(Collectors.groupingBy(CompareResult::getSrcIdSet));
                logger.info("RecBillAutoMatchHelper.oneByOneMatch rs.size ={},rsGroup.size ={}", (Object)rs.size(), (Object)rsGroup.size());
                Set casBillIds = new HashSet(rsGroup.get(cs.getSrcIdSet()).size());
                if (!multipleMatch && rsGroup.get(cs.getSrcIdSet()).size() > 1) {
                    List<CompareResult> casRecList = rsGroup.get(cs.getSrcIdSet());
                    for (CompareResult compareResult : casRecList) {
                        casBillIds.addAll(compareResult.getTarIdSet());
                    }
                    logger.info("RecBillAutoMatchHelper.oneByOneMatch one-one rsGroup = {},multipleMatch = {},cs.getSrcIdSet = {},casBillIds = {}", new Object[]{rsGroup.size(), multipleMatch, cs.getSrcIdSet(), casBillIds});
                } else {
                    casBillIds = cs.getTarIdSet();
                }
                DynamicObject[] filterCdmRecBills = BusinessDataServiceHelper.load((Object[])cs.getSrcIdSet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
                List cdmRecBills = Arrays.stream(filterCdmRecBills).filter(o -> StringUtils.isEmpty((CharSequence)o.getString("rulename")) && StringUtils.isEmpty((CharSequence)o.getString("rectype"))).collect(Collectors.toList());
                DynamicObject[] casRecBills = BusinessDataServiceHelper.load((Object[])casBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BIZ_ENTITY_NAME));
                logger.info("RecBillAutoMatchHelper.oneByOneMatch cdmRecBills.size ={}", (Object)cdmRecBills.size());
                for (DynamicObject cdmRecBill : cdmRecBills) {
                    HashMap<String, DynamicProperty> cdmProperties = new HashMap<String, DynamicProperty>(8);
                    DynamicObjectCollection cdmRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], cdmProperties, cdmRecBill);
                    boolean isCdmMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)cdmRecBillDys.get(0), cdmProperties, detailConditionReal);
                    logger.info("RecBillAutoMatchHelper.oneByOneMatch isCdmMatch ={}", (Object)isCdmMatch);
                    if (!isCdmMatch) continue;
                    long draftBillId = cdmRecBill.getLong("id");
                    long currencyId = cdmRecBill.getDynamicObject("currency").getLong("id");
                    BigDecimal amount = cdmRecBill.getBigDecimal("amount");
                    BigDecimal availableAmount = cdmRecBill.getBigDecimal("availableamount");
                    Date bizDate = cdmRecBill.getDate("bizdate");
                    if (amount.compareTo(availableAmount) != 0 || startDate.compareTo(bizDate) > 0) continue;
                    long casRecBillCount = Arrays.stream(casRecBills).filter(o -> amount.compareTo(o.getBigDecimal("actrecamt")) == 0 && currencyId == o.getLong("currency.id") && startDate.compareTo(o.getDate("bizdate")) <= 0 && o.getDynamicObjectCollection("cas_draftinfo").size() <= 0).count();
                    if (!multipleMatch && casRecBillCount > 1L) {
                        logger.info("RecBillAutoMatchHelper.oneByOneMatch one-one casRecBillCount = {},multipleMatch = {},draftBillNo = {}", new Object[]{casRecBillCount, multipleMatch, cdmRecBill.getString("draftbillno")});
                        continue;
                    }
                    DynamicObject casRecBill = Arrays.stream(casRecBills).filter(o -> amount.compareTo(o.getBigDecimal("actrecamt")) == 0 && currencyId == o.getLong("currency.id") && startDate.compareTo(o.getDate("bizdate")) <= 0 && o.getDynamicObjectCollection("cas_draftinfo").size() <= 0).findFirst().orElse(null);
                    logger.info("RecBillAutoMatchHelper.oneByOneMatch amount = {},currencyId = {},startDate = {}", new Object[]{amount, currencyId, startDate});
                    logger.info("RecBillAutoMatchHelper.oneByOneMatch casRecBill is {}", (Object)(casRecBill == null ? "false" : "true"));
                    if (casRecBill != null) {
                        HashMap<String, DynamicProperty> casProperties = new HashMap<String, DynamicProperty>(8);
                        DynamicObjectCollection casRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], casProperties, casRecBill);
                        boolean isCasMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)casRecBillDys.get(0), casProperties, bizConditionReal);
                        logger.info("RecBillAutoMatchHelper.oneByOneMatch isCasMatch ={}", (Object)isCasMatch);
                        if (!isCasMatch) continue;
                        cdmRecBill.set("rectype", (Object)RecTypeEnum.RULE_MATCH.getValue());
                        cdmRecBill.set("rulename", (Object)(matchRule[0].getString("name") + "_" + matchEntity.getString("e_rulesname")));
                        DynamicObjectCollection draftBills = casRecBill.getDynamicObjectCollection("draftbill");
                        boolean isExist = draftBills.stream().anyMatch(o -> draftBillId == o.getLong("fbasedataid_id"));
                        if (!isExist) {
                            casRecBill.set("settletnumber", (Object)cdmRecBill.getString("draftbillno"));
                            DynamicObject payEntry = draftBills.addNew();
                            payEntry.set("fbasedataid", (Object)cdmRecBill);
                            payEntry.set("fbasedataid_id", cdmRecBill.getPkValue());
                            DynamicObjectCollection draftInfoEntries = casRecBill.getDynamicObjectCollection("cas_draftinfo");
                            CasHelper.addCasRecDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject[])new DynamicObject[]{cdmRecBill});
                        }
                        TmcOperateServiceHelper.executeOperate((String)"save", (String)BIZ_ENTITY_NAME, (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
                        logger.info("RecBillAutoMatchHelper.oneByOneMatch autoReceivingRec is {}", (Object)autoReceivingRec);
                        if (autoReceivingRec) {
                            OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"receivingrec", (String)BIZ_ENTITY_NAME, (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
                            logger.info("RecBillAutoMatchHelper.oneByOneMatch operationResult.isSuccess is {},operationResult = {}", (Object)operationResult.isSuccess(), (Object)RecBillAutoMatchHelper.decodeMultiErrorMessage(operationResult));
                        }
                        successCdmRecBillMap.put(cdmRecBill.getLong("id"), cdmRecBill.getString("draftbillno"));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cdmRecBill});
                }
            }
        }
        return successCdmRecBillMap;
    }

    private static Map<Long, String> manyByOneMatch(List<CompareResult> rs, Date startDate, String matchRel, boolean multipleMatch, String bizConditionReal, String detailConditionReal, DynamicObject[] matchRule, DynamicObject matchEntity, boolean autoReceivingRec) {
        HashMap<Long, String> successCdmRecBillMap = new HashMap<Long, String>(rs.size());
        if ("many-one".equals(matchRel)) {
            for (CompareResult cs : rs) {
                DynamicObject[] filterCdmRecBills = BusinessDataServiceHelper.load((Object[])cs.getSrcIdSet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
                List cdmRecBills = Arrays.stream(filterCdmRecBills).filter(o -> StringUtils.isEmpty((CharSequence)o.getString("rulename")) && StringUtils.isEmpty((CharSequence)o.getString("rectype"))).collect(Collectors.toList());
                DynamicObject[] casRecBills = BusinessDataServiceHelper.load((Object[])cs.getTarIdSet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BIZ_ENTITY_NAME));
                logger.info("RecBillAutoMatchHelper.manyByOneMatch cdmRecBills.size ={}", (Object)cdmRecBills.size());
                ArrayList<DynamicObject> cdmRecBillList = new ArrayList<DynamicObject>(cdmRecBills.size());
                for (DynamicObject cdmRecBill : cdmRecBills) {
                    HashMap<String, DynamicProperty> cdmProperties = new HashMap<String, DynamicProperty>(8);
                    DynamicObjectCollection cdmRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], cdmProperties, cdmRecBill);
                    boolean isMultiCdmMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)cdmRecBillDys.get(0), cdmProperties, detailConditionReal);
                    logger.info("RecBillAutoMatchHelper.manyByOneMatch isMultiCdmMatch ={},draftBillNo = {}", (Object)isMultiCdmMatch, (Object)cdmRecBill.getString("draftbillno"));
                    if (!isMultiCdmMatch) continue;
                    cdmRecBillList.add(cdmRecBill);
                }
                Map<String, List<DynamicObject>> companyMaps = cdmRecBillList.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getLong("id") + "_" + o.getDynamicObject("currency").getLong("id")));
                for (Map.Entry<String, List<DynamicObject>> longListEntry : companyMaps.entrySet()) {
                    DynamicObject casRecBill;
                    List<DynamicObject> recBillGroup = longListEntry.getValue();
                    long currencyId = recBillGroup.get(0).getDynamicObject("currency").getLong("id");
                    BigDecimal recBillGroupAmount = new BigDecimal("0.00");
                    for (DynamicObject recBill : recBillGroup) {
                        BigDecimal amount = recBill.getBigDecimal("amount");
                        recBillGroupAmount = recBillGroupAmount.add(amount);
                    }
                    BigDecimal finalRecBillGroupAmount = recBillGroupAmount;
                    if (!multipleMatch) {
                        HashSet casRecBillIds = new HashSet(rs.size());
                        for (CompareResult cr : rs) {
                            casRecBillIds.addAll(cr.getTarIdSet());
                        }
                        QFilter casRecBillValidateFilter = new QFilter("id", "in", casRecBillIds);
                        casRecBillValidateFilter.and(new QFilter("actrecamt", "=", (Object)finalRecBillGroupAmount));
                        casRecBillValidateFilter.and(new QFilter("cas_draftinfo", "is null", null));
                        DynamicObject[] casRecBillValidate = BusinessDataServiceHelper.load((String)BIZ_ENTITY_NAME, (String)"id,billno", (QFilter[])new QFilter[]{casRecBillValidateFilter});
                        if (casRecBillValidate.length > 1) {
                            logger.info("RecBillAutoMatchHelper.manyByOneMatch many-one casRecBillValidateFilter = {},casRecBillValidate.length = {}", (Object)casRecBillValidateFilter.toString(), (Object)casRecBillValidate.length);
                            continue;
                        }
                    }
                    if ((casRecBill = (DynamicObject)Arrays.stream(casRecBills).filter(o -> finalRecBillGroupAmount.compareTo(o.getBigDecimal("actrecamt")) == 0 && currencyId == o.getLong("currency.id") && startDate.compareTo(o.getDate("bizdate")) <= 0 && o.getDynamicObjectCollection("cas_draftinfo").size() <= 0).findFirst().orElse(null)) != null) {
                        HashMap<String, DynamicProperty> casProperties = new HashMap<String, DynamicProperty>(8);
                        DynamicObjectCollection casRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], casProperties, casRecBill);
                        boolean isCasMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)casRecBillDys.get(0), casProperties, bizConditionReal);
                        logger.info("RecBillAutoMatchHelper.manyByOneMatch isCasMatch ={}", (Object)isCasMatch);
                        if (!isCasMatch) continue;
                        for (DynamicObject cdmRecBill : recBillGroup) {
                            long draftBillId = cdmRecBill.getLong("id");
                            cdmRecBill.set("rectype", (Object)RecTypeEnum.RULE_MATCH.getValue());
                            cdmRecBill.set("rulename", (Object)(matchRule[0].getString("name") + "_" + matchEntity.getString("e_rulesname")));
                            DynamicObjectCollection draftBills = casRecBill.getDynamicObjectCollection("draftbill");
                            boolean isExist = draftBills.stream().anyMatch(o -> draftBillId == o.getLong("fbasedataid_id"));
                            if (!isExist) {
                                DynamicObject payEntry = draftBills.addNew();
                                payEntry.set("fbasedataid", (Object)cdmRecBill);
                                payEntry.set("fbasedataid_id", cdmRecBill.getPkValue());
                                DynamicObjectCollection draftInfoEntries = casRecBill.getDynamicObjectCollection("cas_draftinfo");
                                CasHelper.addCasRecDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject[])new DynamicObject[]{cdmRecBill});
                            }
                            successCdmRecBillMap.put(cdmRecBill.getLong("id"), cdmRecBill.getString("draftbillno"));
                        }
                        DynamicObjectCollection draftBillColl = casRecBill.getDynamicObjectCollection("draftbill");
                        if (!CollectionUtils.isEmpty((Collection)draftBillColl)) {
                            Set draftBills = draftBillColl.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                            String settleNumber = draftBills.stream().map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
                            casRecBill.set("settletnumber", (Object)CasHelper.subString((String)settleNumber, (int)2000));
                        }
                        TmcOperateServiceHelper.executeOperate((String)"save", (String)BIZ_ENTITY_NAME, (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
                        logger.info("RecBillAutoMatchHelper.manyByOneMatch autoReceivingRec is {}", (Object)autoReceivingRec);
                        if (autoReceivingRec) {
                            OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"receivingrec", (String)BIZ_ENTITY_NAME, (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
                            logger.info("RecBillAutoMatchHelper.manyByOneMatch operationResult.isSuccess is {},operationResult = {}", (Object)operationResult.isSuccess(), (Object)RecBillAutoMatchHelper.decodeMultiErrorMessage(operationResult));
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])recBillGroup.toArray(new DynamicObject[0]));
                }
            }
        }
        return successCdmRecBillMap;
    }

    private static Map<Long, String> oneByManyMatch(List<CompareResult> rs, Date startDate, String matchRel, boolean multipleMatch, String bizConditionReal, String detailConditionReal, DynamicObject[] matchRule, DynamicObject matchEntity, boolean autoReceivingRec) {
        HashMap<Long, String> successCdmRecBillMap = new HashMap<Long, String>(rs.size());
        if ("one-many".equals(matchRel)) {
            Map<Set, List<CompareResult>> rsGroup = rs.stream().collect(Collectors.groupingBy(CompareResult::getSrcIdSet));
            logger.info("RecBillAutoMatchHelper.oneByManyMatch rs.size ={},rsGroup.size ={}", (Object)rs.size(), (Object)rsGroup.size());
            for (Map.Entry<Set, List<CompareResult>> setListEntry : rsGroup.entrySet()) {
                Set srcSet = setListEntry.getKey();
                List<CompareResult> tarList = setListEntry.getValue();
                HashSet tarSet = new HashSet(tarList.size());
                setListEntry.getValue().forEach(o -> tarSet.addAll(o.getTarIdSet()));
                logger.info("RecBillAutoMatchHelper.oneByManyMatch srcSet.size ={},tarSet.size ={}", (Object)srcSet.size(), (Object)tarSet.size());
                DynamicObject[] filterCdmRecBills = BusinessDataServiceHelper.load((Object[])srcSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
                List cdmRecBills = Arrays.stream(filterCdmRecBills).filter(o -> StringUtils.isEmpty((CharSequence)o.getString("rulename")) && StringUtils.isEmpty((CharSequence)o.getString("rectype"))).collect(Collectors.toList());
                Set cdmSettlementTypes = cdmRecBills.stream().map(o -> o.getDynamicObject("draftbilltype").getString("settlementtype")).collect(Collectors.toSet());
                Set cdmDeliverNames = cdmRecBills.stream().map(o -> o.getString("delivername")).collect(Collectors.toSet());
                DynamicObject[] filterCasRecBills = BusinessDataServiceHelper.load((Object[])tarSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BIZ_ENTITY_NAME));
                List casRecBills = Arrays.stream(filterCasRecBills).filter(o -> cdmSettlementTypes.contains(o.getDynamicObject("settletype").getString("settlementtype")) && cdmDeliverNames.contains(o.getString("payername"))).filter(o -> startDate.compareTo(o.getDate("bizdate")) <= 0 && ObjectUtils.isEmpty((Object)o.getDynamicObjectCollection("cas_draftinfo")) && "C".equals(o.getString("billstatus"))).collect(Collectors.toList());
                logger.info("RecBillAutoMatchHelper.oneByManyMatch cdmRecBills.size ={},casRecBills.size ={}", (Object)cdmRecBills.size(), (Object)casRecBills.size());
                ArrayList<DynamicObject> casRecBillList = new ArrayList<DynamicObject>(casRecBills.size());
                for (DynamicObject casRecBill : casRecBills) {
                    HashMap<String, DynamicProperty> casProperties = new HashMap<String, DynamicProperty>(8);
                    DynamicObjectCollection casRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], casProperties, casRecBill);
                    boolean isMultiCasMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)casRecBillDys.get(0), casProperties, bizConditionReal);
                    logger.info("RecBillAutoMatchHelper.oneByManyMatch isMultiCasMatch ={},billNo = {}", (Object)isMultiCasMatch, (Object)casRecBill.getString("billno"));
                    if (!isMultiCasMatch) continue;
                    casRecBillList.add(casRecBill);
                }
                Map<String, List<DynamicObject>> companyMaps = casRecBillList.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("org").getLong("id") + "_" + o.getDynamicObject("currency").getLong("id")));
                for (Map.Entry<String, List<DynamicObject>> longListEntry : companyMaps.entrySet()) {
                    DynamicObject cdmRecBill;
                    List<DynamicObject> recBillGroup = longListEntry.getValue();
                    long currencyId = recBillGroup.get(0).getDynamicObject("currency").getLong("id");
                    BigDecimal recBillGroupAmount = new BigDecimal("0.00");
                    for (DynamicObject recBill : recBillGroup) {
                        BigDecimal actRecAmt = recBill.getBigDecimal("actrecamt");
                        recBillGroupAmount = recBillGroupAmount.add(actRecAmt);
                    }
                    BigDecimal finalRecBillGroupAmount = recBillGroupAmount;
                    if (!multipleMatch) {
                        HashSet cdmRecBillIds = new HashSet(rs.size());
                        for (CompareResult cr : rs) {
                            cdmRecBillIds.addAll(cr.getSrcIdSet());
                        }
                        QFilter cdmRecBillValidateFilter = new QFilter("id", "in", cdmRecBillIds);
                        cdmRecBillValidateFilter.and(new QFilter("amount", "=", (Object)finalRecBillGroupAmount));
                        cdmRecBillValidateFilter.and(new QFilter("rectype", "is null", null));
                        cdmRecBillValidateFilter.and(new QFilter("rulename", "is null", null));
                        DynamicObject[] cdmRecBillValidate = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billno", (QFilter[])new QFilter[]{cdmRecBillValidateFilter});
                        if (cdmRecBillValidate.length > 1) {
                            logger.info("RecBillAutoMatchHelper.oneByManyMatch many-one cdmRecBillValidateFilter = {},cdmRecBillValidate.length = {}", (Object)cdmRecBillValidateFilter.toString(), (Object)cdmRecBillValidate.length);
                            continue;
                        }
                    }
                    if ((cdmRecBill = (DynamicObject)cdmRecBills.stream().filter(o -> finalRecBillGroupAmount.compareTo(o.getBigDecimal("amount")) == 0 && currencyId == o.getLong("currency.id") && startDate.compareTo(o.getDate("bizdate")) <= 0 && StringUtils.isEmpty((CharSequence)o.getString("rectype")) && StringUtils.isEmpty((CharSequence)o.getString("rulename"))).findFirst().orElse(null)) == null) continue;
                    HashMap<String, DynamicProperty> cdmProperties = new HashMap<String, DynamicProperty>(8);
                    DynamicObjectCollection cdmRecBillDys = RecBillAutoMatchHelper.getBizBillDy(matchRule[0], cdmProperties, cdmRecBill);
                    boolean isCdmMatch = RecBillAutoMatchHelper.isMatchRule((DynamicObject)cdmRecBillDys.get(0), cdmProperties, detailConditionReal);
                    logger.info("RecBillAutoMatchHelper.oneByManyMatch isCdmMatch ={}", (Object)isCdmMatch);
                    if (!isCdmMatch) continue;
                    long draftBillId = cdmRecBill.getLong("id");
                    cdmRecBill.set("rectype", (Object)RecTypeEnum.RULE_MATCH.getValue());
                    cdmRecBill.set("rulename", (Object)(matchRule[0].getString("name") + "_" + matchEntity.getString("e_rulesname")));
                    for (DynamicObject casRecBill : recBillGroup) {
                        DynamicObjectCollection draftBillColl = casRecBill.getDynamicObjectCollection("draftbill");
                        boolean isExist = draftBillColl.stream().anyMatch(o -> draftBillId == o.getLong("fbasedataid_id"));
                        if (!isExist) {
                            DynamicObject payEntry = draftBillColl.addNew();
                            payEntry.set("fbasedataid", (Object)cdmRecBill);
                            payEntry.set("fbasedataid_id", cdmRecBill.getPkValue());
                            DynamicObjectCollection draftInfoEntries = casRecBill.getDynamicObjectCollection("cas_draftinfo");
                            CasHelper.addCasRecDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject[])new DynamicObject[]{cdmRecBill});
                            if (draftInfoEntries.size() > 0) {
                                for (DynamicObject draftInfoEntry : draftInfoEntries) {
                                    draftInfoEntry.set("transamount", (Object)casRecBill.getBigDecimal("actrecamt"));
                                }
                            }
                        }
                        if (CollectionUtils.isEmpty((Collection)draftBillColl)) continue;
                        Set oneByManyMatch = draftBillColl.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                        String settleNumber = oneByManyMatch.stream().map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
                        casRecBill.set("settletnumber", (Object)CasHelper.subString((String)settleNumber, (int)2000));
                    }
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("draftids", JSON.toJSONString(Collections.singletonList(draftBillId)));
                    option.setVariableValue("selectdraft", "true");
                    Set recBillSet = recBillGroup.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    if (recBillSet.size() > 1) {
                        option.setVariableValue("batchselect", JSONArray.toJSONString(recBillSet));
                    }
                    OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"receivingrec", (String)BIZ_ENTITY_NAME, (DynamicObject[])recBillGroup.toArray(new DynamicObject[0]), (OperateOption)option);
                    boolean isReceivingRec = operationResult.isSuccess();
                    logger.info("RecBillAutoMatchHelper.oneByManyMatch operationResult.isSuccess is {},operationResult = {}", (Object)isReceivingRec, (Object)RecBillAutoMatchHelper.decodeMultiErrorMessage(operationResult));
                    if (!isReceivingRec) continue;
                    successCdmRecBillMap.put(cdmRecBill.getLong("id"), cdmRecBill.getString("draftbillno"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cdmRecBill});
                }
            }
        }
        return successCdmRecBillMap;
    }

    private static DynamicObjectCollection getBizBillDy(DynamicObject matchRule, Map<String, DynamicProperty> fldProperties, DynamicObject bizBill) {
        DynamicObjectCollection entryentity = matchRule.getDynamicObjectCollection("matchentity");
        HashSet<String> ruleFieldSet = new HashSet<String>(8);
        ruleFieldSet.add("company.id");
        ruleFieldSet.add("id");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entryentity)) {
            for (DynamicObject entryrule : entryentity) {
                Iterator filterObj;
                FilterCondition filterCondition;
                String filterStr = entryrule.getString("detailcondition_real_TAG");
                if (bizBill.getDynamicObjectType().getName().contains("cas_")) {
                    filterStr = entryrule.getString("bizcondition_real_TAG");
                }
                if (CasHelper.isEmpty((Object)filterStr) || !EmptyUtil.isNoEmpty((Object)(filterCondition = (filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class)).getFilterCondition()))) continue;
                List filterRows = filterCondition.getFilterRow();
                for (SimpleFilterRow filterRow : filterRows) {
                    ruleFieldSet.add(filterRow.getFieldName());
                }
            }
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)bizBill.getDynamicObjectType().getName());
        ArrayList<Object> selProps = new ArrayList<Object>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            Object propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || ((String)(propName = property.getName())).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = basedataProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = (String)propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        selProps.retainAll(ruleFieldSet);
        DynamicObjectCollection rows = new DynamicObjectCollection();
        rows.add((Object)bizBill);
        DynamicObjectType dType = bizBill.getDynamicObjectType();
        for (String string : selProps) {
            fldProperties.put(string, dType.getProperty(string));
        }
        int rowSize = rows.size();
        logger.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u5f85\u7b7e\u6536\u7968\u636e\u6570\u91cf\u4e3a: " + rowSize + "");
        return rows;
    }

    private static boolean isMatchRule(DynamicObject bizBill, Map<String, DynamicProperty> fldProperties, String filterStr) {
        boolean isMatchRule = false;
        if (!ObjectUtils.isEmpty((Object)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)bizBill.getDynamicObjectType().getName());
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, bizBill, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    logger.error((Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private static String decodeMultiErrorMessage(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo iOperateInfo : errorInfos) {
            String message = iOperateInfo.getMessage();
            Long pkValue = (Long)iOperateInfo.getPkValue();
            stringBuilder.append(pkValue).append(":");
            stringBuilder.append(message).append(";");
        }
        return stringBuilder.toString();
    }
}

