/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeBillHelper {
    public static void handleSupperDraftBill(DynamicObject[] dataEntities) {
        HashMap refundGenTradeBillMap = Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrejectrefundgen")).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)refundGenTradeBillMap) && refundGenTradeBillMap.size() > 0) {
            Set sourceBillIdSet = Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrejectrefundgen")).map(x -> x.getLong("sourcebillid")).collect(Collectors.toSet());
            DynamicObject[] sourceTradeBills = TmcDataServiceHelper.load((Object[])sourceBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
            HashMap sourceTradeBillsMap = Arrays.stream(sourceTradeBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
            for (Map.Entry entry : refundGenTradeBillMap.entrySet()) {
                DynamicObject refundGenTradeBill = (DynamicObject)entry.getValue();
                Long sourceBillId = refundGenTradeBill.getLong("sourcebillid");
                DynamicObjectCollection entrys = refundGenTradeBill.getDynamicObjectCollection("entrys");
                Set draftIdSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])draftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                DynamicObject sourceTradeBill = (DynamicObject)sourceTradeBillsMap.get(sourceBillId);
                if (!EmptyUtil.isNoEmpty((Long)sourceBillId) || sourceBillId <= 0L || !EmptyUtil.isNoEmpty((DynamicObject)sourceTradeBill)) continue;
                Set supperDraftIdSet = sourceTradeBill.getDynamicObjectCollection("entrys").stream().map(x -> x.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                Set supperLogIdSet = sourceTradeBill.getDynamicObjectCollection("entrys").stream().map(o -> o.getLong("billlogid")).collect(Collectors.toSet());
                Map<Long, Long> draftIdAndBillLogIdMap = sourceTradeBill.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid")));
                QFilter idQf = new QFilter("id", "in", supperLogIdSet);
                QFilter newChildLogIdQf = new QFilter("newchildlogid", "!=", (Object)0);
                DynamicObject[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,draftid,splitedsubbillid,newchildlogid", (QFilter[])new QFilter[]{idQf, newChildLogIdQf});
                HashMap draftLogsMap = Arrays.stream(draftLogArr).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
                for (DynamicObject draft : drafts) {
                    DynamicObject draftLog;
                    Long equalTradeBillId = draft.getLong("equaltradebillid");
                    Long supperBillId = draft.getLong("supperbillid");
                    Long billLogId = draftIdAndBillLogIdMap.get(supperBillId);
                    if (!EmptyUtil.isNoEmpty((Long)billLogId) || billLogId <= 0L || EmptyUtil.isEmpty((DynamicObject)(draftLog = (DynamicObject)draftLogsMap.get(billLogId))) || sourceBillId.compareTo(equalTradeBillId) != 0 || !supperDraftIdSet.contains(supperBillId) || !StringUtils.equals((CharSequence)draftLog.getString("bizstatus"), (CharSequence)LogBizStatusEnum.SUCCESS.getValue())) continue;
                    List<DraftLockInfo> releaseInfoList = TradeBillHelper.getReleaseInfo(sourceTradeBill, supperBillId);
                    DraftLockServiceFactory.getService().lock(releaseInfoList, true);
                }
            }
            List<DraftLockInfo> releaseInfoList = LockDraftHelper.getReleaseInfo(new ArrayList<DynamicObject>(refundGenTradeBillMap.values()));
            if (EmptyUtil.isNoEmpty(releaseInfoList)) {
                List<LockResult> releaseResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
                LockDraftHelper.checkHasFail(releaseResultList);
            }
        }
    }

    public static List<DraftLockInfo> getReleaseInfo(DynamicObject tradeBill, Long draftBillId) {
        String tradeBillType = tradeBill.getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        long tradeBillId = tradeBill.getLong("id");
        String billno = tradeBill.getString("billno");
        draftLockInfo.setSourceBillType(tradeBillType);
        draftLockInfo.setSourceBillId(tradeBillId);
        draftLockInfo.setBizBillNo(billno);
        draftLockInfo.setOperateType(OperateTypeEnum.CANCELCOMPLETE.getValue());
        DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
        List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
        HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
        HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
        ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        for (Long lockDraftId : lockDraftIds) {
            if (draftBillId.compareTo(lockDraftId) != 0) continue;
            DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
            draftAmountreleaseSubInfo.setBillId(lockDraftId);
            Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
            draftAmountreleaseSubInfo.setBillLogId(draftLogId);
            BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
            draftAmountreleaseSubInfo.setDealAmount(dealAmount);
            draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.CANCELCOMPLETE.getValue());
            releaseSubInfoList.add(draftAmountreleaseSubInfo);
        }
        draftLockInfo.setLockSubInfoList(releaseSubInfoList);
        releaseInfoList.add(draftLockInfo);
        return releaseInfoList;
    }
}

