/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.lock.DraftLockCompatQuery;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftLockServiceImpl
implements IDraftLockService {
    private static Log logger = LogFactory.getLog(DraftLockServiceImpl.class);

    @Override
    public List<LockResult> lock(List<DraftLockInfo> draftLockInfos, boolean strickMode) {
        List<LockResult> resultList;
        logger.info("DraftLockServiceImpl is start" + JSON.toJSONString(draftLockInfos));
        ArrayList<LockResult> lockResults = new ArrayList<LockResult>(10);
        ArrayList<DraftLockInfo> lockDraftInfoList = new ArrayList<DraftLockInfo>(8);
        ArrayList<DraftLockInfo> releaseDraftInfoList = new ArrayList<DraftLockInfo>(8);
        DraftLockCompatQuery.getLockAndReleaseList(draftLockInfos, lockDraftInfoList, releaseDraftInfoList);
        if (EmptyUtil.isNoEmpty(lockDraftInfoList)) {
            resultList = LockDraftHelper.lockBills(lockDraftInfoList, strickMode);
            lockResults.addAll(resultList);
        }
        if (EmptyUtil.isNoEmpty(releaseDraftInfoList)) {
            resultList = LockDraftHelper.updateBills(releaseDraftInfoList, strickMode);
            if (EmptyUtil.isNoEmpty(lockResults)) {
                Map<Long, LockResult> sourceIdAndDyMap = lockResults.stream().collect(Collectors.toMap(LockResult::getSourceBillId, e -> e));
                for (LockResult result : resultList) {
                    if (!EmptyUtil.isNoEmpty((Object)result)) continue;
                    long sourceBillId = result.getSourceBillId();
                    LockResult preLockResult = sourceIdAndDyMap.get(sourceBillId);
                    if (EmptyUtil.isNoEmpty((Object)preLockResult)) {
                        Map<Long, Long> preBillIdLogIdMap = preLockResult.getBillIdLogIdMap();
                        Map<Long, Long> billIdLogIdMap = result.getBillIdLogIdMap();
                        preBillIdLogIdMap.putAll(billIdLogIdMap);
                        continue;
                    }
                    lockResults.add(result);
                }
            } else {
                lockResults.addAll(resultList);
            }
        }
        logger.info("lockBills is end,lockResults," + JSON.toJSONString(lockResults));
        return lockResults;
    }

    @Override
    public List<LockResult> transfer(List<DraftLockInfo> lockInfoList, boolean stickMode) {
        return new ArrayList<LockResult>();
    }
}

