/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.lock.DraftLockCompatQuery;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.lock.OnWayDraftInfo;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.business.service.ResultInfoOfQueryOnway;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftLockServiceProxy
implements IDraftLockService {
    private static Log logger = LogFactory.getLog(DraftLockServiceProxy.class);
    private IDraftLockService oldService = DraftLockServiceFactory.getCompatService();
    private IDraftLockService newService = DraftLockServiceFactory.getServiceImpl();

    @Override
    public List<LockResult> lock(List<DraftLockInfo> lockInfoList, boolean stickMode) {
        logger.info("lock is start");
        ArrayList<LockResult> resultList = new ArrayList<LockResult>(10);
        ArrayList<DraftLockInfo> historyList = new ArrayList<DraftLockInfo>(10);
        ArrayList<DraftLockInfo> newList = new ArrayList<DraftLockInfo>(10);
        if (EmptyUtil.isEmpty(lockInfoList) || lockInfoList.size() == 0) {
            return resultList;
        }
        Set<Long> noBillLogDraftIdSet = this.getNoBillLogDraftData(lockInfoList);
        Set<OnWayDraftInfo> lockAndHasLogIdDraftSet = DraftLockCompatQuery.queryOnWayDraftIdSet(noBillLogDraftIdSet);
        this.getOnwayAndNewData(lockInfoList, historyList, newList, lockAndHasLogIdDraftSet, false);
        if (EmptyUtil.isNoEmpty(newList)) {
            List<LockResult> lockResultList = this.newService.lock(newList, stickMode);
            resultList.addAll(lockResultList);
        }
        if (EmptyUtil.isNoEmpty(historyList)) {
            List<LockResult> oldLockResultList = this.oldService.lock(historyList, stickMode);
            if (EmptyUtil.isNoEmpty(resultList)) {
                Map<Long, LockResult> sourceIdAndDyMap = resultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, e -> e));
                for (LockResult result : oldLockResultList) {
                    long sourceBillId = result.getSourceBillId();
                    LockResult preLockResult = sourceIdAndDyMap.get(sourceBillId);
                    if (EmptyUtil.isNoEmpty((Object)preLockResult)) {
                        Map<Long, Long> preBillIdLogIdMap = preLockResult.getBillIdLogIdMap();
                        Map<Long, Long> billIdLogIdMap = result.getBillIdLogIdMap();
                        preBillIdLogIdMap.putAll(billIdLogIdMap);
                        continue;
                    }
                    resultList.add(result);
                }
            } else {
                resultList.addAll(oldLockResultList);
            }
        }
        return resultList;
    }

    private void getOnwayAndNewData(List<DraftLockInfo> lockInfoList, List<DraftLockInfo> historyList, List<DraftLockInfo> newList, Set<OnWayDraftInfo> lockedDraftSet, boolean istransfer) {
        Map<Long, List<OnWayDraftInfo>> draftIdAndOnWayInfoMap = lockedDraftSet.stream().collect(Collectors.groupingBy(OnWayDraftInfo::getDraftId));
        ResultInfoOfQueryOnway lockOfQueryOnway = new ResultInfoOfQueryOnway();
        ResultInfoOfQueryOnway releaseOfQueryOnway = new ResultInfoOfQueryOnway();
        for (DraftLockInfo lockInfo : lockInfoList) {
            DraftLockInfo lockInOnway;
            DraftLockInfo lockInfoNew;
            Map<Long, DraftAmountLockSubInfo> draftIdAndSubDyMap = lockInfo.getLockSubInfoList().stream().collect(Collectors.toMap(e -> e.getBillId(), e -> e));
            Long sourceBillId = lockInfo.getSourceBillId();
            List<Long> lockBillIdList = lockInfo.getLockBillIdList();
            if (EmptyUtil.isEmpty(lockBillIdList)) {
                List lockBillIdListNew = lockInfo.getLockSubInfoList().stream().filter(e -> LogBizStatusEnum.PROCESS.getValue().equals(e.getBillTradeStatus())).map(DraftAmountLockSubInfo::getBillId).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(lockBillIdListNew)) {
                    lockInfoNew = new DraftLockInfo();
                    this.setDraftLockInfo(lockInfo, lockInfoNew);
                    lockInOnway = new DraftLockInfo();
                    this.setDraftLockInfo(lockInfo, lockInOnway);
                    ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoOnwayList = new ArrayList<DraftAmountLockSubInfo>(8);
                    ArrayList draftAmountLockSubInfoNewList = new ArrayList(8);
                    for (Long lockBillId : lockBillIdListNew) {
                        DraftAmountLockSubInfo draftAmountLockSubInfo = draftIdAndSubDyMap.get(lockBillId);
                        List<OnWayDraftInfo> onWayDraftInfos = draftIdAndOnWayInfoMap.get(lockBillId);
                        if (EmptyUtil.isNoEmpty(onWayDraftInfos)) {
                            BigDecimal amount;
                            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                            if ((EmptyUtil.isEmpty((BigDecimal)dealAmount) || BigDecimal.ZERO.compareTo(dealAmount) == 0) && EmptyUtil.isNoEmpty((BigDecimal)(amount = onWayDraftInfos.get(0).getAmount()))) {
                                draftAmountLockSubInfo.setDealAmount(amount);
                            }
                            draftAmountLockSubInfoOnwayList.add(draftAmountLockSubInfo);
                            continue;
                        }
                        draftAmountLockSubInfoNewList.add(draftAmountLockSubInfo);
                    }
                    if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoOnwayList)) {
                        lockInOnway.setLockSubInfoList(draftAmountLockSubInfoOnwayList);
                        lockOfQueryOnway.getHistoryList().add(lockInOnway);
                    }
                    if (EmptyUtil.isNoEmpty((Object)draftAmountLockSubInfoNewList)) {
                        lockInfoNew.setLockSubInfoList(draftAmountLockSubInfoNewList);
                        lockOfQueryOnway.getNewList().add(lockInfoNew);
                    }
                }
            } else {
                DraftLockInfo lockInfoNew2 = new DraftLockInfo();
                this.setDraftLockInfo(lockInfo, lockInfoNew2);
                DraftLockInfo lockInOnway2 = new DraftLockInfo();
                this.setDraftLockInfo(lockInfo, lockInOnway2);
                ArrayList<Long> draftIdOnwayList = new ArrayList<Long>(8);
                ArrayList<Long> draftIdNewList = new ArrayList<Long>(8);
                for (Long lockBillId : lockBillIdList) {
                    List<OnWayDraftInfo> onWayDraftInfos = draftIdAndOnWayInfoMap.get(lockBillId);
                    if (EmptyUtil.isNoEmpty(onWayDraftInfos)) {
                        draftIdOnwayList.add(lockBillId);
                        continue;
                    }
                    draftIdNewList.add(lockBillId);
                }
                if (EmptyUtil.isNoEmpty(draftIdOnwayList)) {
                    lockInOnway2.setLockBillIdList(draftIdOnwayList);
                    lockOfQueryOnway.getHistoryList().add(lockInOnway2);
                }
                if (EmptyUtil.isNoEmpty(draftIdNewList)) {
                    lockInfoNew2.setLockBillIdList(draftIdNewList);
                    lockOfQueryOnway.getNewList().add(lockInfoNew2);
                }
            }
            if (istransfer) continue;
            List<Long> releaseBillIdList = lockInfo.getReleaseBillIdList();
            if (EmptyUtil.isEmpty(releaseBillIdList)) {
                List releaseBillIdListNew = lockInfo.getLockSubInfoList().stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType())).map(DraftAmountLockSubInfo::getBillId).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(releaseBillIdListNew)) continue;
                DraftLockInfo lockInfoNew3 = new DraftLockInfo();
                this.setDraftLockInfo(lockInfo, lockInfoNew3);
                DraftLockInfo lockInOnway3 = new DraftLockInfo();
                this.setDraftLockInfo(lockInfo, lockInOnway3);
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoOnwayList = new ArrayList<DraftAmountLockSubInfo>(8);
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoNewList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long lockBillId : releaseBillIdListNew) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo = draftIdAndSubDyMap.get(lockBillId);
                    List<OnWayDraftInfo> onWayDraftInfos = draftIdAndOnWayInfoMap.get(lockBillId);
                    if (EmptyUtil.isNoEmpty(onWayDraftInfos)) {
                        BigDecimal amount;
                        BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                        if ((EmptyUtil.isEmpty((BigDecimal)dealAmount) || BigDecimal.ZERO.compareTo(dealAmount) == 0) && EmptyUtil.isNoEmpty((BigDecimal)(amount = onWayDraftInfos.get(0).getAmount()))) {
                            draftAmountLockSubInfo.setDealAmount(amount);
                        }
                        draftAmountLockSubInfoOnwayList.add(draftAmountLockSubInfo);
                        continue;
                    }
                    draftAmountLockSubInfoNewList.add(draftAmountLockSubInfo);
                }
                if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoOnwayList)) {
                    lockInOnway3.setLockSubInfoList(draftAmountLockSubInfoOnwayList);
                    releaseOfQueryOnway.getHistoryList().add(lockInOnway3);
                }
                if (!EmptyUtil.isNoEmpty(draftAmountLockSubInfoNewList)) continue;
                lockInfoNew3.setLockSubInfoList(draftAmountLockSubInfoNewList);
                releaseOfQueryOnway.getNewList().add(lockInfoNew3);
                continue;
            }
            lockInfoNew = new DraftLockInfo();
            this.setDraftLockInfo(lockInfo, lockInfoNew);
            lockInOnway = new DraftLockInfo();
            this.setDraftLockInfo(lockInfo, lockInOnway);
            ArrayList<Long> draftIdOnwayList = new ArrayList<Long>(8);
            ArrayList<Long> draftIdNewList = new ArrayList<Long>(8);
            for (Long lockBillId : lockBillIdList) {
                List<OnWayDraftInfo> onWayDraftInfos = draftIdAndOnWayInfoMap.get(lockBillId);
                if (EmptyUtil.isNoEmpty(onWayDraftInfos)) {
                    draftIdOnwayList.add(lockBillId);
                    continue;
                }
                draftIdNewList.add(lockBillId);
            }
            if (EmptyUtil.isNoEmpty(draftIdOnwayList)) {
                lockInOnway.setLockBillIdList(draftIdOnwayList);
                releaseOfQueryOnway.getHistoryList().add(lockInOnway);
            }
            if (!EmptyUtil.isNoEmpty(draftIdNewList)) continue;
            lockInfoNew.setLockBillIdList(draftIdNewList);
            releaseOfQueryOnway.getNewList().add(lockInfoNew);
        }
        List<DraftLockInfo> lockNewList = lockOfQueryOnway.getNewList();
        List<DraftLockInfo> releaseNewList = releaseOfQueryOnway.getNewList();
        if (EmptyUtil.isNoEmpty(lockNewList)) {
            newList.addAll(lockNewList);
        }
        if (EmptyUtil.isNoEmpty(releaseNewList)) {
            newList.addAll(releaseNewList);
        }
        List<DraftLockInfo> lockHistoryList = lockOfQueryOnway.getHistoryList();
        List<DraftLockInfo> releaseHistoryList = releaseOfQueryOnway.getHistoryList();
        if (EmptyUtil.isNoEmpty(lockHistoryList)) {
            historyList.addAll(lockHistoryList);
        }
        if (EmptyUtil.isNoEmpty(releaseHistoryList)) {
            historyList.addAll(releaseHistoryList);
        }
    }

    private void setDraftLockInfo(DraftLockInfo lockInfo, DraftLockInfo lockInfoNew) {
        lockInfoNew.setBillTradeStatus(lockInfo.getBillTradeStatus());
        lockInfoNew.setBizBillNo(lockInfo.getBizBillNo());
        lockInfoNew.setSourceBillId(lockInfo.getSourceBillId());
        lockInfoNew.setSourceBillType(lockInfo.getSourceBillType());
        lockInfoNew.setOperateType(lockInfo.getOperateType());
        lockInfoNew.setTargetBillType(lockInfo.getTargetBillType());
        lockInfoNew.setTargetBillId(lockInfo.getTargetBillId());
    }

    private Set<Long> getNoBillLogDraftData(List<DraftLockInfo> lockInfoList) {
        HashSet<Long> noBillLogDraftIdSet = new HashSet<Long>(8);
        for (DraftLockInfo lockInfo : lockInfoList) {
            List<DraftAmountLockSubInfo> lockSubInfoDataList = lockInfo.getLockSubInfoList();
            if (EmptyUtil.isEmpty(lockSubInfoDataList)) {
                List<Long> lockBillIdList = lockInfo.getLockBillIdList();
                List<Long> releaseBillIdList = lockInfo.getReleaseBillIdList();
                if (EmptyUtil.isNoEmpty(lockBillIdList)) {
                    noBillLogDraftIdSet.addAll(lockBillIdList);
                }
                if (!EmptyUtil.isNoEmpty(releaseBillIdList)) continue;
                noBillLogDraftIdSet.addAll(releaseBillIdList);
                continue;
            }
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoDataList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                noBillLogDraftIdSet.add(billId);
            }
        }
        return noBillLogDraftIdSet;
    }

    @Override
    public List<LockResult> transfer(List<DraftLockInfo> transferInfo, boolean stickMode) {
        ArrayList<LockResult> resultList = new ArrayList<LockResult>(8);
        ArrayList<DraftLockInfo> historyList = new ArrayList<DraftLockInfo>(10);
        ArrayList<DraftLockInfo> newList = new ArrayList<DraftLockInfo>(10);
        Set<Long> noBillLogDraftIdSet = this.getNoBillLogDraftData(transferInfo);
        Set<OnWayDraftInfo> lockAndHasLogIdDraftSet = DraftLockCompatQuery.queryOnWayDraftIdSet(noBillLogDraftIdSet);
        this.getOnwayAndNewData(transferInfo, historyList, newList, lockAndHasLogIdDraftSet, true);
        if (EmptyUtil.isNoEmpty(newList)) {
            List<LockResult> list = this.newService.transfer(newList, stickMode);
        }
        if (EmptyUtil.isNoEmpty(historyList)) {
            List<LockResult> oldLockResultList = this.oldService.transfer(historyList, stickMode);
            resultList.addAll(oldLockResultList);
        }
        return resultList;
    }
}

