/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateResultInfo;
import kd.tmc.cdm.business.lock.DraftOperateSubInfo;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.lock.IDraftOperateService;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class DraftOperateService
implements IDraftOperateService {
    private static Log LOGGER = LogFactory.getLog(DraftOperateService.class);
    private IDraftLockService newLockService = DraftLockServiceFactory.getServiceImpl();
    private static final List<String> ALLOWSPLITTYPES = Arrays.asList(DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.PLEDGE.getValue(), DraftTradeTypeEnum.BILLSPLIT.getValue());

    @Override
    public List<DraftOperateResultInfo> confirm(DraftOperateInfo info) {
        LOGGER.info("DraftOperateService confirm is start that:" + SerializationUtils.toJsonString((Object)info));
        long tradeBillId = info.getTradeBillId();
        long draftBillId = info.getDraftBillIdFromEle();
        boolean formEleUpdate = info.isFormEleUpdate();
        boolean isRejectRefundGen = info.isRejectRefundGen();
        String tradeType = info.getTradetype();
        ArrayList<DraftOperateResultInfo> draftOperateResultInfoList = new ArrayList<DraftOperateResultInfo>(8);
        ArrayList<DraftOperateResultInfo> draftOperateSubInfoListDealRepeat = new ArrayList<DraftOperateResultInfo>(8);
        try (TXHandle tx = TX.required();){
            try {
                long sourceId = info.getTradeBillId();
                String sourceName = info.getDyTypename();
                List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
                ArrayList<DraftAmountLockSubInfo> draftAmountLockInfos = new ArrayList<DraftAmountLockSubInfo>(8);
                HashSet<Long> billLogIdSet = new HashSet<Long>(8);
                HashSet<Long> needCallBillIdSet = new HashSet<Long>(8);
                HashSet<Long> draftIdSplitedSet = new HashSet<Long>(8);
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                draftLockInfo.setSourceBillId(sourceId);
                draftLockInfo.setSourceBillType(sourceName);
                draftLockInfo.setOperateType(OperateTypeEnum.FINISH.getValue());
                draftLockInfo.setBizBillNo(info.getNumber());
                draftLockInfo.setBillTradeStatus(info.getTradetype());
                draftLockInfo.setBillTrade(info.getTradetype());
                draftLockInfo.setDrawfail(info.isDrawfail());
                boolean isFromEle = EmptyUtil.isNoEmpty((Long)draftBillId) && formEleUpdate;
                for (DraftOperateSubInfo entry : entrys) {
                    long billlogid = entry.getBilllog();
                    billLogIdSet.add(billlogid);
                }
                DynamicObject[] draftbillLogs = BusinessDataServiceHelper.load((Object[])billLogIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
                Map<Long, DynamicObject> logIdAndDyMap = Arrays.stream(draftbillLogs).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                HashMap<Long, DynamicObject> supperIdAndLogIdMap = new HashMap<Long, DynamicObject>(8);
                for (DraftOperateSubInfo entry : entrys) {
                    long billlogid = entry.getBilllog();
                    long draftbillId = entry.getDraftbillId();
                    if (!EmptyUtil.isNoEmpty((Long)billlogid)) continue;
                    DynamicObject draftBillLog = logIdAndDyMap.get(billlogid);
                    String bizstatus = draftBillLog.getString("bizstatus");
                    boolean issplit = draftBillLog.getBoolean("issplit");
                    long splitedsubbillid = draftBillLog.getLong("splitedsubbillid");
                    if (!LogBizStatusEnum.PROCESS.getValue().equals(bizstatus) && !isRejectRefundGen && issplit) {
                        draftIdSplitedSet.add(splitedsubbillid);
                        supperIdAndLogIdMap.put(draftbillId, draftBillLog);
                        LOGGER.info("DraftOperateService will continue:" + bizstatus + ",isRejectRefundGen:" + isRejectRefundGen);
                        continue;
                    }
                    long draftBillid = entry.getDraftbillId();
                    if (isFromEle && draftBillid != draftBillId) {
                        LOGGER.info("DraftOperateService will continue isFromEle:" + isFromEle);
                        continue;
                    }
                    DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                    draftAmountLockInfo.setBillId(draftBillid);
                    draftAmountLockInfo.setDealAmount(entry.getBillamt());
                    draftAmountLockInfo.setOperateType(OperateTypeEnum.FINISH.getValue());
                    draftAmountLockInfo.setBillLogId(billlogid);
                    draftAmountLockInfo.setBillTrade(info.getTradetype());
                    String draftStatus = entry.getDraftbilltranstatus();
                    boolean isFailed = DraftTranStatusEnum.FAILING.getValue().equals(draftStatus);
                    if (isFromEle && isFailed) {
                        draftAmountLockInfo.setReGenerate(true);
                    }
                    draftAmountLockInfos.add(draftAmountLockInfo);
                    needCallBillIdSet.add(draftBillid);
                }
                if (EmptyUtil.isNoEmpty(draftAmountLockInfos)) {
                    draftLockInfo.getLockSubInfoList().addAll(draftAmountLockInfos);
                    ArrayList<DraftLockInfo> draftLockInfoList = new ArrayList<DraftLockInfo>();
                    draftLockInfoList.add(draftLockInfo);
                    List<LockResult> lockResultList = LockDraftHelper.updateBills(draftLockInfoList, true);
                    boolean isequalsplit = info.getIsequalsplit();
                    boolean isSplitType = tradeType.equalsIgnoreCase(DraftTradeTypeEnum.BILLSPLIT.getValue());
                    if (isSplitType && isequalsplit || ALLOWSPLITTYPES.contains(tradeType)) {
                        info.setNeedDealDraftIdSet(needCallBillIdSet);
                        LOGGER.info("DraftOperateService will split");
                        List<DraftOperateResultInfo> billLogIdAndSubBillMap = this.split(info);
                        draftOperateResultInfoList.addAll(billLogIdAndSubBillMap);
                    }
                }
                if (EmptyUtil.isNoEmpty(draftIdSplitedSet)) {
                    LOGGER.info("draftIdSplitedSet is\uff1a" + SerializationUtils.toJsonString(draftIdSplitedSet));
                    Object[] subBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSplitedSet), new QFilter("equaltradebillid", "=", (Object)tradeBillId)});
                    if (EmptyUtil.isNoEmpty((Object[])subBills)) {
                        DynamicObject[] subBillArr;
                        Set<Object> draftBillIdSet = Arrays.stream(subBills).map(e -> e.getLong("id")).collect(Collectors.toSet());
                        for (DynamicObject subBill : subBillArr = BusinessDataServiceHelper.load((Object[])draftBillIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                            long supperBillId = subBill.getLong("supperbillid");
                            DraftOperateResultInfo draftOperateResultInfo = new DraftOperateResultInfo();
                            draftOperateResultInfo.setDraftId(supperBillId);
                            draftOperateResultInfo.setSubBillDy(subBill);
                            DynamicObject billLogDy = (DynamicObject)supperIdAndLogIdMap.get(supperBillId);
                            if (EmptyUtil.isNoEmpty((DynamicObject)billLogDy)) {
                                draftOperateResultInfo.setDealAmount(billLogDy.getBigDecimal("dealamount"));
                                draftOperateResultInfo.setLogid(billLogDy.getLong("id"));
                            }
                            draftOperateResultInfoList.add(draftOperateResultInfo);
                        }
                    }
                }
                if (EmptyUtil.isNoEmpty(draftOperateResultInfoList)) {
                    Set suBillIdSet = draftOperateResultInfoList.stream().map(e -> e.getSubBillDy().getLong("id")).collect(Collectors.toSet());
                    DynamicObject[] subBillF7DyArr = TmcDataServiceHelper.load((Object[])suBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                    Map<Long, DynamicObject> idAndDyMap = Arrays.stream(subBillF7DyArr).collect(Collectors.toMap(e -> e.getLong("supperbillid"), e -> e));
                    for (DraftOperateResultInfo draftOperateResultInfo : draftOperateResultInfoList) {
                        long draftId = draftOperateResultInfo.getDraftId();
                        DynamicObject recbillDy = idAndDyMap.get(draftId);
                        if (!EmptyUtil.isNoEmpty((DynamicObject)recbillDy)) continue;
                        draftOperateResultInfo.setSubBillDy(recbillDy);
                    }
                }
                List<DraftOperateSubInfo> draftOperateSubInfoList = info.getDraftOperateSubInfoList();
                if (EmptyUtil.isNoEmpty(draftOperateResultInfoList)) {
                    LOGGER.info("draftOperateResultInfoList is not null");
                    Set hasBillLogIdDradtIdSet = draftOperateResultInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLogid()) && EmptyUtil.isNoEmpty((Long)e.getDraftId())).map(DraftOperateResultInfo::getDraftId).collect(Collectors.toSet());
                    List onwayData = draftOperateSubInfoList.stream().filter(e -> !hasBillLogIdDradtIdSet.contains(e.getDraftbillId())).collect(Collectors.toList());
                    for (DraftOperateSubInfo draftOperateSubInfo : onwayData) {
                        DraftOperateResultInfo draftOperateResultInfo = new DraftOperateResultInfo();
                        draftOperateResultInfo.setDraftId(draftOperateSubInfo.getDraftbillId());
                        draftOperateResultInfo.setLogid(draftOperateSubInfo.getBilllog());
                        draftOperateResultInfoList.add(draftOperateResultInfo);
                    }
                } else {
                    LOGGER.info("draftOperateResultInfoList is null");
                    for (DraftOperateSubInfo draftOperateSubInfo : draftOperateSubInfoList) {
                        DraftOperateResultInfo draftOperateResultInfo = new DraftOperateResultInfo();
                        draftOperateResultInfo.setDraftId(draftOperateSubInfo.getDraftbillId());
                        draftOperateResultInfo.setLogid(draftOperateSubInfo.getBilllog());
                        draftOperateResultInfoList.add(draftOperateResultInfo);
                    }
                }
                HashSet<Long> draftIdSet = new HashSet<Long>(8);
                for (DraftOperateResultInfo draftOperateResultInfo : draftOperateResultInfoList) {
                    long draftId = draftOperateResultInfo.getDraftId();
                    if (draftIdSet.contains(draftId)) continue;
                    draftIdSet.add(draftId);
                    draftOperateSubInfoListDealRepeat.add(draftOperateResultInfo);
                }
            }
            catch (Exception e2) {
                LOGGER.error("DraftOperateService has error:", (Throwable)e2);
                tx.markRollback();
                throw e2;
            }
            ArrayList<DraftOperateResultInfo> arrayList = draftOperateSubInfoListDealRepeat;
            return arrayList;
        }
    }

    @Override
    public List<DraftOperateResultInfo> cancel(DraftOperateInfo info) {
        LOGGER.info("DraftOperateService cancel is start" + SerializationUtils.toJsonString((Object)info));
        ArrayList<DraftOperateResultInfo> draftOperateResultInfoList = new ArrayList<DraftOperateResultInfo>(8);
        long tradeBillId = info.getTradeBillId();
        boolean isequalsplit = info.getIsequalsplit();
        String tradetype = info.getTradetype();
        HashSet<Long> tradeBillIdSet = new HashSet<Long>(8);
        HashSet<Long> draftBillIdSet = new HashSet<Long>(8);
        HashSet<Long> eleBillIdSet = new HashSet<Long>(8);
        List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
        for (DraftOperateSubInfo entry : entrys) {
            long draftBillId = entry.getDraftbillId();
            long sourcebillid = entry.getSourcebillid();
            draftBillIdSet.add(draftBillId);
            eleBillIdSet.add(sourcebillid);
            tradeBillIdSet.add(tradeBillId);
        }
        Map splittradebillidMap = new HashMap();
        Map<Object, Object> sourcebillIdAndEleMap = new HashMap();
        DynamicObject[] eleBillArr = null;
        if (eleBillIdSet.size() > 0) {
            splittradebillidMap = TradeBillHelper.getTradeBillIdAndSubBillMap(draftBillIdSet, tradeBillIdSet);
            eleBillArr = BusinessDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,sourceid,amount,subrange,startno", (QFilter[])new QFilter[]{new QFilter("id", "in", eleBillIdSet)});
            sourcebillIdAndEleMap = Arrays.stream(eleBillArr).collect(Collectors.toMap(x -> x.getLong("sourceid"), x -> x));
        }
        String dyType = info.getDyTypename();
        HashSet<DynamicObject> saveEleBillIdSet = new HashSet<DynamicObject>();
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillId(tradeBillId);
        draftLockInfo.setSourceBillType(dyType);
        draftLockInfo.setOperateType(OperateTypeEnum.CANCEL.getValue());
        draftLockInfo.setBizBillNo(info.getNumber());
        draftLockInfo.setBillTrade(info.getTradetype());
        draftLockInfo.setDrawfail(info.isDrawfail());
        ArrayList<DraftAmountLockSubInfo> draftAmountLockInfos = new ArrayList<DraftAmountLockSubInfo>(8);
        for (DraftOperateSubInfo entry : entrys) {
            long billlogid = entry.getBilllog();
            DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
            draftAmountLockInfo.setBillTrade(info.getTradetype());
            draftAmountLockInfo.setBillId(entry.getDraftbillId());
            draftAmountLockInfo.setDealAmount(entry.getBillamt());
            draftAmountLockInfo.setOperateType(OperateTypeEnum.CANCEL.getValue());
            draftAmountLockInfo.setBillLogId(billlogid);
            draftAmountLockInfos.add(draftAmountLockInfo);
        }
        draftLockInfo.setLockSubInfoList(draftAmountLockInfos);
        ArrayList<DraftLockInfo> draftLockInfoList = new ArrayList<DraftLockInfo>();
        draftLockInfoList.add(draftLockInfo);
        LockDraftHelper.updateBills(draftLockInfoList, false);
        List<DraftOperateSubInfo> draftOperateSubInfoList = info.getDraftOperateSubInfoList();
        for (DraftOperateSubInfo draftOperateSubInfo : draftOperateSubInfoList) {
            DraftOperateResultInfo draftOperateResultInfo = new DraftOperateResultInfo();
            long draftbillId = draftOperateSubInfo.getDraftbillId();
            long billlog = draftOperateSubInfo.getBilllog();
            draftOperateResultInfo.setDraftId(draftbillId);
            draftOperateResultInfo.setLogid(billlog);
            draftOperateResultInfoList.add(draftOperateResultInfo);
        }
        for (DraftOperateSubInfo entry : entrys) {
            BigDecimal dealTradeAmount = entry.getBillamt();
            long draftBillId = entry.getDraftbillId();
            String keyStr = tradeBillId + "_" + draftBillId;
            DynamicObject subRec = (DynamicObject)splittradebillidMap.get(keyStr);
            if (!EmptyUtil.isNoEmpty((DynamicObject)subRec)) continue;
            long sourceid = subRec.getLong("sourcebillid");
            if ("billsplit".equals(tradetype) && !isequalsplit) {
                TmcOperateServiceHelper.execOperate((String)"deletesplitbill", (String)"cdm_receivablebill", (Object[])new Object[]{subRec.getLong("id")}, (OperateOption)OperateOption.create());
            } else {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"), (Object[])new Object[]{subRec.getLong("id")});
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"), (Object[])new Object[]{sourceid});
            DynamicObject eleBill = (DynamicObject)sourcebillIdAndEleMap.get(draftBillId);
            if (null == eleBill) continue;
            String subBillRange = eleBill.getString("subrange");
            long subbillEndflag = entry.getSubbillendflag();
            long changeNum = dealTradeAmount.multiply(new BigDecimal("100")).longValue();
            String[] splitArr = subBillRange.split("-", -1);
            String newEleSubRange = Long.parseLong(splitArr[0]) - changeNum + "-" + subbillEndflag;
            BigDecimal newEleAmount = eleBill.getBigDecimal("amount").add(dealTradeAmount);
            eleBill.set("subrange", (Object)newEleSubRange);
            eleBill.set("amount", (Object)newEleAmount);
            saveEleBillIdSet.add(eleBill);
        }
        TmcDataServiceHelper.save((DynamicObject[])saveEleBillIdSet.toArray(new DynamicObject[0]));
        return draftOperateResultInfoList;
    }

    @Override
    public List<DraftOperateResultInfo> split(DraftOperateInfo info) {
        LOGGER.info("dealSplitTrade is start");
        ArrayList<DraftOperateResultInfo> draftOperateResultInfos = new ArrayList<DraftOperateResultInfo>(8);
        long draftId = info.getDraftBillIdFromEle();
        long tradeBillId = info.getTradeBillId();
        boolean isDrawfail = info.isDrawfail();
        boolean isFromEle = info.isFormEleUpdate();
        Set<Long> needCallBillIdSet = info.getNeedDealDraftIdSet();
        boolean isCallByEleByOneBill = draftId != 0L;
        HashMap<Long, Long> billLogIdAndBillIdMap = new HashMap<Long, Long>(8);
        String tradeBillno = info.getNumber();
        LOGGER.info("dealSplitTrade tradeBillno is start:" + tradeBillno);
        List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
        if (EmptyUtil.isEmpty(entrys)) {
            LOGGER.info("entrys is null");
            return draftOperateResultInfos;
        }
        for (DraftOperateSubInfo entry : entrys) {
            Long billlogid = entry.getBilllog();
            long draftBillId = entry.getDraftbillId();
            if (!needCallBillIdSet.contains(draftBillId)) {
                LOGGER.info("needCallBillIdSet contains not  draftBillId:" + draftBillId);
                continue;
            }
            billLogIdAndBillIdMap.put(billlogid, draftBillId);
        }
        Set billLogIdSet = billLogIdAndBillIdMap.keySet();
        Object[] draftbillLogs = BusinessDataServiceHelper.load((Object[])billLogIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
        Map<Object, Object> supperLogIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])draftbillLogs)) {
            supperLogIdAndDyMap = this.getSubLogIdData((DynamicObject[])draftbillLogs);
            Object[] objects = billLogIdAndBillIdMap.values().toArray();
            Map<Long, DynamicObject> billLogIdAndLogDyMap = Arrays.stream(draftbillLogs).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            Object[] recBills = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
            if (EmptyUtil.isNoEmpty((Object[])recBills)) {
                Map<Long, Long> recBillIdAndEleIdMap = Arrays.stream(recBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("sourcebillid")));
                Map<Long, DynamicObject> recBillIdMap = Arrays.stream(recBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                HashSet<Long> sourceIdSet = new HashSet<Long>(recBillIdAndEleIdMap.values());
                DynamicObject[] eleRecDeals = BusinessDataServiceHelper.load((Object[])sourceIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"));
                Map<Long, DynamicObject> recbillIdAndEleMap = Arrays.stream(eleRecDeals).collect(Collectors.toMap(e -> e.getLong("sourceid"), e -> e));
                ArrayList<DynamicObject> newSubRecBills = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> newRecBills = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> newSubEleBills = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> supperEleBills = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> billLogSets = new ArrayList<DynamicObject>();
                for (DraftOperateSubInfo entry : entrys) {
                    DraftOperateResultInfo draftOperateResultInfo = new DraftOperateResultInfo();
                    long billLogId = entry.getBilllog();
                    long supperRecBillId = entry.getDraftbillId();
                    if (!needCallBillIdSet.contains(supperRecBillId)) continue;
                    LOGGER.info("billLogId:" + billLogId + ",supperRecBillId is:" + supperRecBillId + ",draftId is:" + draftId + ",isCallByEleByOneBill:" + isCallByEleByOneBill);
                    if (isCallByEleByOneBill && draftId != supperRecBillId) continue;
                    String transtatus = entry.getTranstatus();
                    boolean isSuccessStatus = true;
                    if (isFromEle || EmptyUtil.isNoEmpty((String)transtatus)) {
                        isSuccessStatus = DraftTranStatusEnum.SUCCESS.getValue().equals(transtatus);
                    }
                    DynamicObject draftbillLog = billLogIdAndLogDyMap.get(billLogId);
                    DynamicObject subLogDy = (DynamicObject)supperLogIdAndDyMap.get(billLogId);
                    String ebStatus = info.getEbStatusStr();
                    boolean isProcessSplit = false;
                    if (isCallByEleByOneBill) {
                        boolean bl = isProcessSplit = EbStatus.BANK_PROCESSING.getName().equals(ebStatus) || "BANK_UNKNOWN".equals(ebStatus);
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)subLogDy) && !isSuccessStatus && !isProcessSplit) {
                        LOGGER.info("billLogId has sub logId:" + billLogId);
                        draftbillLog = subLogDy;
                        DynamicObject supperBillLog = billLogIdAndLogDyMap.get(billLogId);
                        supperBillLog.set("issplit", (Object)false);
                        draftbillLog.set("issplit", (Object)false);
                        supperBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
                        billLogSets.add(supperBillLog);
                    }
                    boolean issplit = draftbillLog.getBoolean("issplit");
                    boolean isneedsplit = entry.isIsneedsplit();
                    DynamicObject supperRecBill = recBillIdMap.get(supperRecBillId);
                    String draftbillTranstatus = supperRecBill.getString("draftbilltranstatus");
                    LOGGER.info("issplit is:" + issplit + ",isneedsplit is :" + isneedsplit + ",isSuccessStatus is:" + isSuccessStatus + ",supperRecStatus:" + draftbillTranstatus);
                    if (!issplit && isneedsplit) {
                        DynamicObject subRecBill = this.fillSubBillInfo(info, isSuccessStatus, draftbillLog, supperRecBill);
                        LOGGER.info("subRecBill is:" + subRecBill.getLong("id"));
                        DynamicObject eleRecDeal = recbillIdAndEleMap.get(supperRecBillId);
                        if (EmptyUtil.isNoEmpty((DynamicObject)eleRecDeal)) {
                            boolean isFailSplit;
                            boolean drawfail = info.isDrawfail();
                            DynamicObject newEleBill = this.fillSubEleBillInfo(isSuccessStatus, subRecBill, eleRecDeal, drawfail);
                            String ebStatusStr = info.getEbStatusStr();
                            boolean splitChangeBillNew = info.isIsneedchangebill();
                            if (!isFromEle) {
                                long eleBillNewStartFlag = subRecBill.getLong("subbillendflag") + 1L;
                                long enFlag = supperRecBill.getLong("subbillendflag");
                                String eleBillNewRange = eleBillNewStartFlag + "-" + enFlag;
                                long quanlity = enFlag - eleBillNewStartFlag + 1L;
                                BigDecimal eleRecDealAmount = new BigDecimal(quanlity).multiply(new BigDecimal("0.01"));
                                eleRecDeal.set("subrange", (Object)eleBillNewRange);
                                eleRecDeal.set("amount", (Object)eleRecDealAmount);
                            } else if (isCallByEleByOneBill) {
                                LOGGER.info("orgId splitChangeBill that" + splitChangeBillNew + ",draftId:" + draftId + ",ebStatusStr :" + ebStatusStr);
                                if (splitChangeBillNew) {
                                    this.fillInfoWhenChangeBill(eleRecDeal, newEleBill, subRecBill, supperRecBill, isSuccessStatus, ebStatusStr);
                                    newRecBills.add(supperRecBill);
                                } else {
                                    newEleBill.set("batchseqid", null);
                                    newEleBill.set("prebatchseqid", null);
                                    newEleBill.set("tradetype", null);
                                    newEleBill.set("opstatus", null);
                                    newEleBill.set("ebstatus", null);
                                    newEleBill.set("bankmsg", null);
                                }
                            }
                            String tradeTypeEle = eleRecDeal.getString("tradetype");
                            LOGGER.info("tradeTypeEle is:" + tradeTypeEle);
                            if (ElcDraftBillOpEnum.NOTECANCLE.getValue().equalsIgnoreCase(tradeTypeEle)) {
                                newEleBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                                eleRecDeal.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                                subRecBill.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
                            }
                            if ((isFailSplit = EbStatus.BANK_FAIL.getName().equals(ebStatusStr)) || splitChangeBillNew) {
                                newEleBill.set("tradeoppname", null);
                            } else {
                                eleRecDeal.set("tradeoppname", null);
                            }
                            newSubEleBills.add(newEleBill);
                            supperEleBills.add(eleRecDeal);
                        }
                        BigDecimal supperRecAvaiAmount = supperRecBill.getBigDecimal("availableamount");
                        BigDecimal supperRecLockAmount = supperRecBill.getBigDecimal("lockedamount");
                        BigDecimal supperRecUsedAmount = supperRecBill.getBigDecimal("usedamount");
                        LOGGER.info("supperRecBill is:" + supperRecBill.getLong("id") + ",supperRecAvaiAmount is:" + supperRecAvaiAmount + ",supperRecLockAmount :" + supperRecLockAmount + ",supperRecUsedAmount:" + supperRecUsedAmount);
                        newSubRecBills.add(subRecBill);
                        if (!(!isSuccessStatus && isFromEle || isDrawfail)) {
                            draftbillLog.set("bizstatus", (Object)LogBizStatusEnum.SUCCESS.getValue());
                        } else {
                            draftbillLog.set("bizstatus", (Object)LogBizStatusEnum.FAIL.getValue());
                        }
                        draftbillLog.set("issplit", (Object)true);
                        draftbillLog.set("splitedsubbillid", (Object)subRecBill.getLong("id"));
                        draftOperateResultInfo.setSubBillDy(subRecBill);
                        draftOperateResultInfo.setDraftId(supperRecBill.getLong("id"));
                        draftOperateResultInfo.setLogid(draftbillLog.getLong("id"));
                        draftOperateResultInfo.setDealAmount(draftbillLog.getBigDecimal("dealamount"));
                        draftOperateResultInfos.add(draftOperateResultInfo);
                    } else {
                        LOGGER.info("will not gen sub bill");
                    }
                    draftbillLog.set("updatebizbillid", (Object)tradeBillId);
                    if (isSuccessStatus && !isDrawfail) {
                        draftbillLog.set("bizstatus", (Object)LogBizStatusEnum.SUCCESS.getValue());
                    } else {
                        draftbillLog.set("bizstatus", (Object)LogBizStatusEnum.FAIL.getValue());
                    }
                    billLogSets.add(draftbillLog);
                }
                if (EmptyUtil.isNoEmpty(billLogSets)) {
                    SaveServiceHelper.update((DynamicObject[])billLogSets.toArray(new DynamicObject[0]));
                } else {
                    LOGGER.info("billLogSets is null");
                }
                if (EmptyUtil.isNoEmpty(newRecBills)) {
                    SaveServiceHelper.update((DynamicObject[])newRecBills.toArray(new DynamicObject[0]));
                } else {
                    LOGGER.info("newRecBills is null");
                }
                if (EmptyUtil.isNoEmpty(supperEleBills)) {
                    SaveServiceHelper.update((DynamicObject[])supperEleBills.toArray(new DynamicObject[0]));
                } else {
                    LOGGER.info("supperEleBills is null");
                }
                if (EmptyUtil.isNoEmpty(newSubRecBills)) {
                    SaveServiceHelper.save((DynamicObject[])newSubRecBills.toArray(new DynamicObject[0]));
                } else {
                    LOGGER.info("newSubRecBills is null");
                }
                if (EmptyUtil.isNoEmpty(newSubEleBills)) {
                    SaveServiceHelper.save((DynamicObject[])newSubEleBills.toArray(new DynamicObject[0]));
                } else {
                    LOGGER.info("newSubEleBills is null");
                }
            }
        }
        LOGGER.info("dealSplitTrade is end");
        return draftOperateResultInfos;
    }

    private void fillInfoWhenChangeBill(DynamicObject eleRecDeal, DynamicObject subEleRecDeal, DynamicObject subRecDeal, DynamicObject supperRecDeal, boolean isSuccessStatus, String ebStatusStr) {
        boolean isProcessSplit;
        String supperEleSubRange = eleRecDeal.getString("subrange");
        BigDecimal supperEleAmount = eleRecDeal.getBigDecimal("amount");
        BigDecimal supperEleInitamount = eleRecDeal.getBigDecimal("initamount");
        BigDecimal supperEleLocalAmount = eleRecDeal.getBigDecimal("locamt");
        Long supperEleSourceId = eleRecDeal.getLong("sourceid");
        String supperEleSourcenumber = eleRecDeal.getString("sourcenumber");
        String supperEleUniquecode = eleRecDeal.getString("uniquecode");
        String supperEleInitsubrange = eleRecDeal.getString("initsubrange");
        String subEleSubRange = subEleRecDeal.getString("subrange");
        BigDecimal subEleAmount = subEleRecDeal.getBigDecimal("amount");
        BigDecimal subEleInitamount = subEleRecDeal.getBigDecimal("initamount");
        BigDecimal subEleLocalAmount = subEleRecDeal.getBigDecimal("locamt");
        Long subEleSourceId = subEleRecDeal.getLong("sourceid");
        String subEleSourcenumber = subEleRecDeal.getString("sourcenumber");
        String subEleUniquecode = subEleRecDeal.getString("uniquecode");
        String subEleInitsubrange = subEleRecDeal.getString("initsubrange");
        subEleRecDeal.set("subrange", (Object)supperEleSubRange);
        subEleRecDeal.set("amount", (Object)supperEleAmount);
        subEleRecDeal.set("initamount", (Object)supperEleInitamount);
        subEleRecDeal.set("locamt", (Object)supperEleLocalAmount);
        subEleRecDeal.set("sourceid", (Object)supperEleSourceId);
        subEleRecDeal.set("sourcenumber", (Object)supperEleSourcenumber);
        subEleRecDeal.set("uniquecode", (Object)supperEleUniquecode);
        subEleRecDeal.set("initsubrange", (Object)supperEleInitsubrange);
        subEleRecDeal.set("ebstatus", (Object)"BANK_SUCCESS");
        subEleRecDeal.set("tradetype", null);
        subEleRecDeal.set("pretradetype", null);
        subEleRecDeal.set("prebatchseqid", null);
        subEleRecDeal.set("batchseqid", null);
        subEleRecDeal.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
        subEleRecDeal.set("tradeoppname", null);
        eleRecDeal.set("subrange", (Object)subEleSubRange);
        eleRecDeal.set("amount", (Object)subEleAmount);
        eleRecDeal.set("initamount", (Object)subEleInitamount);
        eleRecDeal.set("locamt", (Object)subEleLocalAmount);
        eleRecDeal.set("sourceid", (Object)subEleSourceId);
        eleRecDeal.set("sourcenumber", (Object)subEleSourcenumber);
        eleRecDeal.set("uniquecode", (Object)subEleUniquecode);
        eleRecDeal.set("initsubrange", (Object)subEleInitsubrange);
        eleRecDeal.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
        subRecDeal.set("sourcebillid", (Object)eleRecDeal.getLong("id"));
        boolean bl = isProcessSplit = EbStatus.BANK_PROCESSING.getName().equals(ebStatusStr) || "BANK_UNKNOWN".equals(ebStatusStr);
        if (isProcessSplit) {
            subRecDeal.set("draftbilltranstatus", (Object)"handleing");
        } else {
            subRecDeal.set("draftbilltranstatus", (Object)"success");
        }
        supperRecDeal.set("sourcebillid", (Object)subEleRecDeal.getLong("id"));
        subEleRecDeal.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
        supperRecDeal.set("elccirculatestatus", (Object)"TF0301");
        supperRecDeal.set("electag", (Object)"0");
        supperRecDeal.set("tradetype", null);
        supperRecDeal.set("ebstatus", null);
        LOGGER.info("fillInfoWhenChangeBill that eleRecDeal id" + eleRecDeal.getLong("id") + ",supperEleSourceId:" + supperEleSourceId + "subEleRecDeal\uff1a" + subEleRecDeal.getLong("id") + ",subEleSourceId is:" + subEleSourceId);
    }

    public DynamicObject fillSubBillInfo(DraftOperateInfo tradebill, boolean isSuccessStatus, DynamicObject draftbillLog, DynamicObject supperRecBill) {
        DynamicObject subRecBill = (DynamicObject)OrmUtils.clone((Object)supperRecBill, (IDataEntityType)supperRecBill.getDataEntityType(), (boolean)true, (boolean)true);
        String generateNumber = CodeRuleHelper.generateNumber((String)"cdm_receivablebill", (DynamicObject)subRecBill, (String)null, (String)null);
        subRecBill.set("billno", (Object)generateNumber);
        long subBillId = DB.genGlobalLongId();
        subRecBill.set("id", (Object)subBillId);
        long tadeBillId = tradebill.getTradeBillId();
        String dataTypeName = tradebill.getDyTypename();
        String tradeTypeStr = tradebill.getTradetype();
        BigDecimal dealAmount = draftbillLog.getBigDecimal("dealamount");
        long quanlity = dealAmount.multiply(new BigDecimal("100")).longValue();
        subRecBill.set("amount", (Object)dealAmount);
        subRecBill.set("subbillquantity", (Object)quanlity);
        subRecBill.set("isequalbill", (Object)true);
        subRecBill.set("originalsubbillamount", (Object)dealAmount);
        long endFlag = supperRecBill.getLong("subbillstartflag");
        long subEndFlag = endFlag - 1L;
        long subRecBillStartFlag = endFlag - quanlity;
        subRecBill.set("subbillstartflag", (Object)subRecBillStartFlag);
        subRecBill.set("subbillendflag", (Object)subEndFlag);
        String subBillRange = subRecBillStartFlag + "-" + subEndFlag;
        subRecBill.set("originalsubbillrang", (Object)subBillRange);
        subRecBill.set("subbillrange", (Object)subBillRange);
        subRecBill.set("supperbillid", (Object)supperRecBill.getLong("id"));
        subRecBill.set("equaltradebillid", (Object)tadeBillId);
        subRecBill.set("equaltradebilltype", (Object)dataTypeName);
        String draftBillno = supperRecBill.getString("draftbillno");
        String billidentitycode = draftBillno + "-" + subBillRange;
        subRecBill.set("billidentitycode", (Object)billidentitycode);
        subRecBill.set("sourcebillid", (Object)0L);
        subRecBill.set("source", (Object)"cdm");
        subRecBill.set("isfromequalspilt", (Object)true);
        subRecBill.set("equaltradebilltype", (Object)tradeTypeStr);
        subRecBill.set("createtime", (Object)new Date());
        boolean drawfail = tradebill.isDrawfail();
        if (isSuccessStatus && !drawfail) {
            String billDealStatus = DraftHelper.tradeTypeStatus((String)tradeTypeStr);
            subRecBill.set("draftbillstatus", (Object)billDealStatus);
        }
        subRecBill.set("draftbilltranstatus", (Object)"success");
        subRecBill.set("lockedamount", (Object)BigDecimal.ZERO);
        subRecBill.set("usedamount", (Object)BigDecimal.ZERO);
        subRecBill.set("availableamount", (Object)dealAmount);
        subRecBill.set("isfromalloc", (Object)false);
        return subRecBill;
    }

    public DynamicObject fillSubEleBillInfo(boolean isSuccessStatus, DynamicObject subRecBill, DynamicObject eleRecDeal, boolean drawfail) {
        DynamicObject newEleBill = (DynamicObject)OrmUtils.clone((Object)eleRecDeal, (IDataEntityType)eleRecDeal.getDataEntityType(), (boolean)true, (boolean)true);
        String subBillCode = subRecBill.getString("billidentitycode");
        String subRange = subRecBill.getString("subbillrange");
        String subAmount = subRecBill.getString("amount");
        long eleBillId = DB.genGlobalLongId();
        newEleBill.set("id", (Object)eleBillId);
        newEleBill.set("amount", (Object)subAmount);
        newEleBill.set("usedamount", (Object)BigDecimal.ZERO);
        newEleBill.set("locamt", (Object)subAmount);
        newEleBill.set("sourceid", (Object)subRecBill.getLong("id"));
        subRecBill.set("sourcebillid", (Object)eleBillId);
        newEleBill.set("sourcenumber", (Object)subRecBill.getString("billno"));
        newEleBill.set("subrange", (Object)subRange);
        newEleBill.set("uniquecode", (Object)subBillCode);
        newEleBill.set("initsubrange", (Object)subRange);
        newEleBill.set("initamount", (Object)subAmount);
        newEleBill.set("ebstatus", (Object)EbStatus.BANK_SUCCESS.getName());
        newEleBill.set("createtime", (Object)new Date());
        if (!drawfail) {
            if (isSuccessStatus) {
                newEleBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
            } else {
                newEleBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
            }
        }
        return newEleBill;
    }

    private Map<Long, DynamicObject> getSubLogIdData(DynamicObject[] draftbillLogs) {
        Map<Long, DynamicObject> supperLogIdAndDyMap = new HashMap<Long, DynamicObject>();
        Map<Long, Long> logIdAndSubLogIdMap = Arrays.stream(draftbillLogs).filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("newchildlogid"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("newchildlogid")));
        if (EmptyUtil.isNoEmpty(logIdAndSubLogIdMap)) {
            HashSet<Long> subLogIdSet = new HashSet<Long>(logIdAndSubLogIdMap.values());
            DynamicObject[] subLogs = BusinessDataServiceHelper.load((Object[])subLogIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
            supperLogIdAndDyMap = Arrays.stream(subLogs).collect(Collectors.toMap(e -> e.getLong("oldlogid"), e -> e));
        }
        return supperLogIdAndDyMap;
    }
}

