/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.enums.TransStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class DraftAllocationFailCancelService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity");
        selector.add("draftbilllogid");
        selector.add("e_draftbill");
        selector.add("e_subbillamt");
        selector.add("biztype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Map variables = this.getOperationVariable();
        Set selectRowIds = (Set)SerializationUtils.fromJsonString((String)((String)variables.get("selectRowIds")), Set.class);
        if (CollectionUtils.isEmpty((Collection)selectRowIds)) {
            return;
        }
        DynamicObject draftAllocation = dynamicObjects[0];
        List<DraftLockInfo> releaseInfoList = this.getReleaseInfo(new DynamicObject[]{draftAllocation});
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
        LockDraftHelper.checkHasFail(lockResultList);
        DynamicObjectCollection entryEntity = draftAllocation.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryEntity) {
            for (Long selectRowId : selectRowIds) {
                if (!Objects.equals(row.getPkValue(), selectRowId)) continue;
                row.set("e_transstatus", (Object)TransStatusEnum.CANCELLED.getValue());
            }
        }
    }

    private List<DraftLockInfo> getReleaseInfo(DynamicObject[] dataEntities) {
        String tradeBillType = dataEntities[0].getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject tradebill : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = tradebill.getLong("id");
            String bizType = tradebill.getString("biztype");
            String billno = tradebill.getString("billno");
            draftLockInfo.setBillTrade(bizType);
            draftLockInfo.setSourceBillType(tradeBillType);
            draftLockInfo.setSourceBillId(tradeBillId);
            draftLockInfo.setBizBillNo(billno);
            draftLockInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
            DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entryentity");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_subbillamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                draftAmountreleaseSubInfo.setBillId(lockDraftId);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                draftAmountreleaseSubInfo.setBillTrade(bizType);
                releaseSubInfoList.add(draftAmountreleaseSubInfo);
            }
            draftLockInfo.setLockSubInfoList(releaseSubInfoList);
            releaseInfoList.add(draftLockInfo);
        }
        return releaseInfoList;
    }

    private void releaseDrafts(Long pkValue, String entityName, Set<Long> releaseBillIdSet) {
    }
}

