/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAllocationSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity");
        selector.add("e_draftbill");
        selector.add("draftbilllogid");
        selector.add("e_subbillamt");
        selector.add("biztype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
        boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
        ArrayList<LockResult> lockResultList = new ArrayList(8);
        if (!autoAllocation) {
            List<DraftLockInfo> releaseInfoList = LockDraftHelper.getAllocateLockAndReleaseInfo(dynamicObjects);
            lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
            LockDraftHelper.checkHasFail(lockResultList);
        }
        Map<Long, LockResult> tradeIdAndDyMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
        for (DynamicObject data : dynamicObjects) {
            long payBillId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long draftBillId = entry.getDynamicObject("e_draftbill").getLong("id");
                LockResult lockResult = tradeIdAndDyMap.get(payBillId);
                if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                boolean success = lockResult.isSuccess();
                Long billLogId = billIdLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                entry.set("draftbilllogid", (Object)billLogId);
            }
        }
    }
}

