/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.cdm.business.pool.ITransferExecutor;
import kd.tmc.cdm.business.pool.TransferExecutorFactory;
import kd.tmc.cdm.common.enums.TransBillTransStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class DraftAllocationSubmitEndorseService
extends AbstractTmcBizOppService {
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("issubmitendorse");
        selector.add("entryentity");
        selector.add("e_transstatus");
        selector.add("biztype");
        selector.add("billpool");
        selector.add("e_transstatusdesc");
        selector.add("incompany");
        selector.add("outcompany");
        selector.add("createpoolaccount");
        selector.add("inaccount");
        selector.add("e_draftbill");
        selector.add("sucamount");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        Object[] idArr = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        for (DynamicObject dataEntity : dataEntities = TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftallocation"))) {
            dataEntity.set("issubmitendorse", (Object)"1");
            dataEntity.set("transstatus", (Object)TransBillTransStatusEnum.PROCESSING.getValue());
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
            List<Long> entryIdList = entry.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            ITransferExecutor executor = TransferExecutorFactory.createTransferExecutor();
            boolean isSuccess = executor.execute(dataEntity, entryIdList);
            if (isSuccess) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, dataEntity.getPkValue(), (Object)dataEntity.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(dataEntity.get("billno") + ":" + String.join((CharSequence)",", executor.getErrMsgList()));
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

