/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAllocationSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("e_draftbill");
        selector.add("inaccount");
        selector.add("createpoolaccount");
        selector.add("sourcebillid");
        selector.add("entryentity");
        selector.add("e_subbillamt");
        selector.add("draftbilllogid");
        selector.add("billno");
        selector.add("biztype");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
        boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
        ArrayList<LockResult> lockResultList = new ArrayList(8);
        if (!autoAllocation) {
            List<DraftLockInfo> releaseInfoList = LockDraftHelper.getAllocateLockAndReleaseInfo(dynamicObjects);
            lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
            LockDraftHelper.checkHasFail(lockResultList);
        }
        Map<Long, LockResult> tradeIdAndDyMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
        for (DynamicObject draftAllocation : dynamicObjects) {
            long payBillId = draftAllocation.getLong("id");
            DynamicObjectCollection rows = draftAllocation.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)rows)) continue;
            this.fillDraftBillsType(rows);
            for (DynamicObject entry : rows) {
                Long draftBillId = entry.getDynamicObject("e_draftbill").getLong("id");
                LockResult lockResult = tradeIdAndDyMap.get(payBillId);
                if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                boolean success = lockResult.isSuccess();
                Long billLogId = billIdLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                entry.set("draftbilllogid", (Object)billLogId);
            }
        }
    }

    private void backFillAccountIfElectric(DynamicObject draftAllocation, DynamicObjectCollection rows) {
        for (DynamicObject row : rows) {
            String billMedium;
            DynamicObject draftBill = row.getDynamicObject("e_draftbill");
            DynamicObject draftBillType = draftBill.getDynamicObject("draftbilltype");
            if (!Objects.nonNull(draftBillType) || !Objects.equals(billMedium = draftBillType.getString("billmedium"), BillMediumEnum.ELECTRIC.getValue())) continue;
            this.backFillAccount(draftAllocation, draftBill);
            break;
        }
    }

    private void backFillAccount(DynamicObject draftAllocation, DynamicObject draftBill) {
        DynamicObject inAccount;
        DynamicObject casPayBillDy;
        Long sourceBillId = draftAllocation.getLong("sourcebillid");
        boolean isFromCas = false;
        if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((DynamicObject)(casPayBillDy = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)})))) {
            isFromCas = true;
        }
        if (Objects.isNull(inAccount = this.getElectricDirectAccount(draftBill, draftAllocation.getDynamicObject("incompany")))) {
            if (!isFromCas) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u7535\u5b50\u7968\u636e\uff0c\u5fc5\u987b\u5728\u7535\u7968\u76f4\u8fde\u8bbe\u7f6e\u5185\u7ef4\u62a4\u8c03\u5165\u8d44\u91d1\u7ec4\u7ec7\u8d26\u6237\u3002", (String)"DraftAllocationSubmitService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        } else {
            draftAllocation.set("inaccount", (Object)inAccount);
        }
        String dispatchRule = draftAllocation.getDynamicObject("billpool").getString("dispatchrule");
        if (Objects.equals(DispatchRuleEnum.INDIRECT.getValue(), dispatchRule)) {
            DynamicObject createPoolCompany = draftAllocation.getDynamicObject("billpool").getDynamicObject("company");
            DynamicObject createPoolAccount = this.getElectricDirectAccount(draftBill, createPoolCompany);
            if (Objects.isNull(createPoolAccount)) {
                if (!isFromCas) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u7535\u5b50\u7968\u636e\uff0c\u5fc5\u987b\u5728\u7535\u7968\u76f4\u8fde\u8bbe\u7f6e\u5185\u7ef4\u62a4\u7968\u636e\u6c60\u5efa\u6c60\u8d44\u91d1\u7ec4\u7ec7\u8d26\u6237\u3002", (String)"DraftAllocationSubmitService_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            } else {
                draftAllocation.set("createpoolaccount", (Object)createPoolAccount);
            }
        }
    }

    private DynamicObject getElectricDirectAccount(DynamicObject draftBill, DynamicObject company) {
        QFilter orgFilter = new QFilter("company", "=", company.getPkValue());
        DynamicObject bankAccount = draftBill.getDynamicObject("bankaccount");
        if (Objects.nonNull(bankAccount)) {
            DynamicObject[] electricDirects;
            DynamicObject bankAccountFromDB = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankAccount.getLong("id"))});
            DynamicObject bankAccountOpenBank = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankAccountFromDB.getLong("bank"))});
            long bankCate = bankAccountOpenBank.getLong("bank_cate");
            for (DynamicObject electricDirect : electricDirects = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"defaultaccount", (QFilter[])orgFilter.toArray())) {
                long electricDirectBankCateId;
                DynamicObject electricDirectOpenBank;
                long bankAccountCateId = 0L;
                if (bankCate != 0L) {
                    bankAccountCateId = bankCate;
                }
                if (!Objects.nonNull(electricDirectOpenBank = electricDirect.getDynamicObject("defaultaccount.bank"))) continue;
                DynamicObject electricDirectOpenBankFromDB = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)electricDirectOpenBank.getLong("id"))});
                long l = electricDirectBankCateId = electricDirectOpenBankFromDB == null ? 0L : electricDirectOpenBankFromDB.getLong("bank_cate");
                if (bankAccountCateId == 0L || electricDirectBankCateId == 0L || electricDirectBankCateId != bankAccountCateId) continue;
                return electricDirect.getDynamicObject("defaultaccount");
            }
            return electricDirects.length > 0 ? electricDirects[0].getDynamicObject("defaultaccount") : null;
        }
        return null;
    }

    private void fillDraftBillsType(DynamicObjectCollection rows) {
        DynamicObject[] draftBillTypes;
        Object[] draftBillTypeIds = rows.stream().map(d -> d.getDynamicObject("e_draftbill")).filter(t -> t.getDynamicObject("draftbilltype") != null).map(t -> t.getDynamicObject("draftbilltype").getPkValue()).toArray();
        for (DynamicObject draftBillType : draftBillTypes = BusinessDataServiceHelper.load((String)"cdm_billtype", (String)"billmedium", (QFilter[])new QFilter("id", "in", (Object)draftBillTypeIds).toArray())) {
            for (DynamicObject row : rows) {
                DynamicObject draftBill = row.getDynamicObject("e_draftbill");
                if (!Objects.equals(draftBillType.getPkValue(), draftBill.getDynamicObject("draftbilltype").getPkValue())) continue;
                draftBill.set("draftbilltype", (Object)draftBillType);
            }
        }
    }
}

