/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class LockOrReleaseDraftAllocationService {
    public static void lockOrReleaseDraftBills(DynamicObject[] draftAllocationArr) {
        Object[] pkValues = Arrays.stream(draftAllocationArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] draftAllocationArrFromDB = TmcDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)draftAllocationArr[0].getDynamicObjectType());
        Map<Long, DynamicObject> tradeBillFromDBMap = Arrays.stream(draftAllocationArrFromDB).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        ArrayList<DraftLockInfo> draftLockInfoList = new ArrayList<DraftLockInfo>(draftAllocationArr.length);
        for (DynamicObject draftAllocation : draftAllocationArr) {
            DynamicObjectCollection draftBills = draftAllocation.getDynamicObjectCollection("entryentity");
            List draftBillIds = draftBills.stream().map(d -> (Long)d.getDynamicObject("e_draftbill").getPkValue()).collect(Collectors.toList());
            Long billPoolBizId = draftAllocation.getLong("id");
            ArrayList<Long> lockDraftBillIds = new ArrayList<Long>(draftBillIds);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            DynamicObject draftAllocationFromDB = tradeBillFromDBMap.get(billPoolBizId);
            if (draftAllocationFromDB != null) {
                DynamicObjectCollection draftBillsFromDB = draftAllocationFromDB.getDynamicObjectCollection("entryentity");
                List draftBillIdsFromDB = draftBillsFromDB.stream().map(d -> (Long)d.getDynamicObject("e_draftbill").getPkValue()).collect(Collectors.toList());
                lockDraftBillIds.removeAll(draftBillIdsFromDB);
                ArrayList<Long> releaseDraftBillIds = new ArrayList<Long>(draftBillIdsFromDB);
                releaseDraftBillIds.removeAll(draftBillIds);
                draftLockInfo.setReleaseBillIdList(releaseDraftBillIds);
            }
            draftLockInfo.setLockBillIdList(lockDraftBillIds);
            draftLockInfo.setSourceBillId(billPoolBizId);
            draftLockInfo.setSourceBillType(draftAllocation.getDataEntityType().getName());
            draftLockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(draftLockInfoList)) {
            // empty if block
        }
    }

    private LockOrReleaseDraftAllocationService() {
    }
}

