/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation.scheduling;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.opservice.allocation.scheduling.AbstractEndorseTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingContext;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingResult;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Draft2EndorseBizBillTask
extends AbstractEndorseTask {
    private static Log logger = LogFactory.getLog(Draft2EndorseBizBillTask.class);

    public Draft2EndorseBizBillTask(String name) {
        super(name);
    }

    @Override
    public SchedulingResult excute(SchedulingContext ctx) {
        this.context = ctx;
        this.createEndorseIndirect();
        return this.getResult();
    }

    private void createEndorseIndirect() {
        DynamicObject allocBill = this.getContext().getAllocBill();
        Long recDraftId = this.getContext().getCurrentBillId();
        DynamicObject recDraft = TmcDataServiceHelper.loadSingle((Object)recDraftId, (String)"cdm_receivablebill");
        DynamicObject endorseBizBillFromDraft = null;
        try {
            endorseBizBillFromDraft = this.createEndorseBizBillByDraft(allocBill, recDraft);
        }
        catch (Exception ex) {
            this.result.setFailedOp(this.getName());
            this.result.setErrorMessage(ex.getMessage());
            logger.error("createRecDraftIndirect() exception:", (Throwable)ex);
            return;
        }
        endorseBizBillFromDraft.set("billstatus", (Object)"C");
        OperationResult saveEndorseBizBillResult = this.saveBill("save", endorseBizBillFromDraft);
        if (saveEndorseBizBillResult.isSuccess()) {
            List ids = saveEndorseBizBillResult.getSuccessPkIds();
            this.getResult().setResultBillId((Long)ids.get(0));
            this.getResult().setSuccess(true);
        } else {
            this.result.setFailedOp(this.getName());
            this.result.setSuccess(false);
            this.result.setErrorMessage(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)saveEndorseBizBillResult));
        }
    }

    private DynamicObject createEndorseBizBillByDraft(DynamicObject allocBill, DynamicObject receivableDraft) {
        DynamicObject newDraftTradeBill = BusinessDataServiceHelper.newDynamicObject((String)"cdm_drafttradebill");
        DynamicObject billCompany = receivableDraft.getDynamicObject("company");
        newDraftTradeBill.set("company", (Object)billCompany);
        DynamicObject billType = BaseDataHelper.getBillType((String)"cdm_drafttradebill", (String)"cdm_tradebill_endorse_BT_S");
        newDraftTradeBill.set("billtype", (Object)billType);
        newDraftTradeBill.set("tradetype", (Object)DraftTradeTypeEnum.ENDORSE.getValue());
        DynamicObject beendorsor = allocBill.getDynamicObject("incompany");
        newDraftTradeBill.set("payeetype", (Object)"bos_org");
        newDraftTradeBill.set("payeetypetext", (Object)"bos_org");
        newDraftTradeBill.set("beendorsor", (Object)beendorsor);
        newDraftTradeBill.set("beendorsortext", (Object)beendorsor.getString("name"));
        newDraftTradeBill.set("drafttype", (Object)receivableDraft.getDynamicObject("draftbilltype"));
        DynamicObject bankacct = allocBill.getDynamicObject("inaccount");
        if (bankacct != null) {
            newDraftTradeBill.set("bankacct", (Object)bankacct.getString("bankaccountnumber"));
            DynamicObject bank = bankacct.getDynamicObject("bank");
            DynamicObject finorg = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id,bebank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bank.getLong("id"))});
            Long bebank = finorg.getLong("bebank");
            if (EmptyUtil.isNoEmpty((Long)bebank)) {
                DynamicObject bebankObj = BusinessDataServiceHelper.loadSingle((Object)bebank, (String)"bd_bebank");
                newDraftTradeBill.set("bank", (Object)bebankObj);
                newDraftTradeBill.set("bankcode", (Object)bebankObj.getString("union_number"));
            }
        }
        newDraftTradeBill.set("bizdate", (Object)this.getContext().getAllocBill().getDate("bizdate"));
        newDraftTradeBill.set("draftcount", (Object)1);
        newDraftTradeBill.set("currency", (Object)receivableDraft.getDynamicObject("currency"));
        newDraftTradeBill.set("amount", (Object)receivableDraft.getBigDecimal("amount"));
        newDraftTradeBill.set("billstatus", (Object)"C");
        newDraftTradeBill.set("allocbillentryid", (Object)this.getContext().getEntryId());
        newDraftTradeBill.set("sourcebillid", receivableDraft.getPkValue());
        newDraftTradeBill.set("sourcebilltype", (Object)"cdm_receivablebill");
        newDraftTradeBill.set("source", (Object)"cdm-draftallocate");
        DynamicObjectCollection entrys = newDraftTradeBill.getDynamicObjectCollection("entrys");
        DynamicObject entry = entrys.addNew();
        DynamicObject draftBillObjF7 = TmcDataServiceHelper.loadSingle((Object)receivableDraft.getPkValue(), (String)"cdm_draftbillf7");
        entry.set("draftbill", (Object)draftBillObjF7);
        return newDraftTradeBill;
    }
}

