/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation.scheduling;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.opservice.allocation.scheduling.AbstractEndorseTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.Alloc2EndorseBizBillTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingContext;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingResult;
import kd.tmc.cdm.common.enums.DraftSchedulingTaskEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class EndorseBizBill2DraftTask
extends AbstractEndorseTask {
    private static Log logger = LogFactory.getLog(Alloc2EndorseBizBillTask.class);

    public EndorseBizBill2DraftTask(String name) {
        super(name);
    }

    @Override
    public SchedulingResult excute(SchedulingContext ctx) {
        this.context = ctx;
        this.createRecDraft();
        return this.getResult();
    }

    private void createRecDraft() {
        DynamicObject recDraft = null;
        DynamicObject allocBill = this.context.getAllocBill();
        Long entryId = this.context.getEntryId();
        Long endorseBillId = this.context.getCurrentBillId();
        try {
            DynamicObject endorseBizBill = TmcDataServiceHelper.loadSingle((Object)endorseBillId, (String)"cdm_drafttradebill");
            DynamicObject[] recBills = BotpHelper.push((DynamicObject)endorseBizBill, (String)"cdm_receivablebill");
            recDraft = recBills[0];
            recDraft.set("allocbillentryid", (Object)entryId);
            Long sourceDraftId = recDraft.getLong("sourcedraft");
            DynamicObject origDraftBill = TmcDataServiceHelper.loadSingle((Object)sourceDraftId, (String)"cdm_receivablebill");
            DynamicObject billPool = origDraftBill.getDynamicObject("billpool");
            recDraft.set("source", (Object)"cdm-draftallocate");
            recDraft.set("billpool", (Object)billPool);
            recDraft.set("intopooltime", (Object)origDraftBill.getDate("intopooltime"));
            recDraft.set("poollockstatus", (Object)origDraftBill.getString("poollockstatus"));
            recDraft.set("poollockorg", (Object)origDraftBill.getDynamicObject("poollockorg"));
            recDraft.set("poollocktime", (Object)origDraftBill.getDate("poollocktime"));
            if (this.getContext().isIndrectTransfer() && this.getName().equals(DraftSchedulingTaskEnum.ALLOCATEUP_REGISTER.getValue())) {
                recDraft.set("isendorsepay", (Object)"1");
                recDraft.set("locksourcebillid", this.getContext().getAllocBill().getPkValue());
                recDraft.set("locksourcebilltype", (Object)"cdm_draftallocation");
            }
            recDraft.set("billstatus", (Object)"C");
        }
        catch (Exception ex) {
            this.result.setFailedOp(this.getName());
            this.result.setErrorMessage(ex.getMessage());
            logger.error("createRecDraftIndirect() exception:", (Throwable)ex);
            return;
        }
        OperationResult saveRecDraftResult = this.saveBill(recDraft);
        if (saveRecDraftResult.isSuccess()) {
            List ids = saveRecDraftResult.getSuccessPkIds();
            this.getResult().setResultBillId((Long)ids.get(0));
            this.getResult().setSuccess(true);
        } else {
            this.result.setFailedOp(this.getName());
            this.result.setSuccess(false);
            this.result.setErrorMessage(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)saveRecDraftResult));
        }
    }
}

