/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation.scheduling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.business.opservice.allocation.scheduling.Alloc2EndorseBizBillTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.Draft2EndorseBizBillTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.EndorseBizBill2DraftTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.EndorseTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingContext;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingResult;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.cdm.common.enums.TransStatusDescEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class EndorseScheduler {
    private static Log logger = LogFactory.getLog(EndorseScheduler.class);
    private final String TASK_ALLOCATEUP_ENDORSE = "allocateup_endorse";
    private final String TASK_ALLOCATEUP_REGISTER = "allocateup_register";
    private final String TASK_ALLOCATEDOWN_ENDORSE = "allocatedown_endorse";
    private final String TASK_ALLOCATEDOWN_REGISTER = "allocatedown_register";
    private final String TASK_ALLOCATE_ENDORSE = "allocate_endorse";
    private final String TASK_ALLOCATE_REGISTER = "allocate_register";

    public TransStatusDescEnum convertFailedStatusDesc(String name) {
        switch (name) {
            case "allocateup_endorse": {
                return TransStatusDescEnum.ALLOC_UP_ENDORSE_FAILED;
            }
            case "allocatedown_endorse": {
                return TransStatusDescEnum.ALLOC_DOWN_ENDORSE_FAILED;
            }
            case "allocate_endorse": {
                return TransStatusDescEnum.ALLOC_ENDORSE_FAILED;
            }
            case "allocateup_register": {
                return TransStatusDescEnum.ALLOC_UP_REGISTER_FAILED;
            }
            case "allocatedown_register": {
                return TransStatusDescEnum.ALLOC_DOWN_REGISTER_FAILED;
            }
            case "allocate_register": {
                return TransStatusDescEnum.ALLOC_REGISTER_FAILED;
            }
        }
        return TransStatusDescEnum.ALLOC_OTHER_FAILED;
    }

    private List<EndorseTask> createSchedulingTasks(SchedulingContext ctx) {
        ArrayList<EndorseTask> tasks = new ArrayList<EndorseTask>(5);
        String bizType = ctx.getBiztype();
        String endorseTaskName = "";
        String registerTaskName = "";
        if (DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue().equals(bizType)) {
            endorseTaskName = "allocatedown_endorse";
            registerTaskName = "allocatedown_register";
        }
        if (DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue().equals(bizType)) {
            endorseTaskName = "allocateup_endorse";
            registerTaskName = "allocateup_register";
        }
        if (DraftAllocateBizTypeEnum.ALLOCATE.getValue().equals(bizType)) {
            if (!ctx.isIndrectTransfer()) {
                endorseTaskName = "allocate_endorse";
                registerTaskName = "allocate_register";
            } else {
                endorseTaskName = "allocateup_endorse";
                registerTaskName = "allocateup_register";
            }
        }
        tasks.add(new Alloc2EndorseBizBillTask(endorseTaskName));
        tasks.add(new EndorseBizBill2DraftTask(registerTaskName));
        if (ctx.isIndrectTransfer()) {
            tasks.add(new Draft2EndorseBizBillTask("allocatedown_endorse"));
            tasks.add(new EndorseBizBill2DraftTask("allocatedown_register"));
        }
        return tasks;
    }

    public SchedulingResult schedule(DynamicObject allocBill, Long entryId) {
        try {
            SchedulingContext ctx = new SchedulingContext(allocBill, entryId);
            List<EndorseTask> tasks = this.createSchedulingTasks(ctx);
            SchedulingResult result = this.doExecute(ctx, tasks);
            return result;
        }
        catch (Exception e) {
            logger.error("schedule", (Throwable)e);
            SchedulingResult result = new SchedulingResult();
            result.setEntryId(entryId);
            result.setSuccess(false);
            result.setFailedOp("unknown");
            return result;
        }
    }

    private SchedulingResult doExecute(SchedulingContext ctx, List<EndorseTask> tasks) {
        EndorseTask task;
        SchedulingResult result = null;
        Iterator<EndorseTask> iterator = tasks.iterator();
        while (iterator.hasNext() && (result = (task = iterator.next()).excute(ctx)).isSuccess()) {
            ctx.enterBill(result.getResultBillId(), result.getResultBillType());
        }
        return result;
    }

    public SchedulingResult reschedule(DynamicObject allocBill, Long entryId) {
        try {
            SchedulingContext ctx = new SchedulingContext(allocBill, entryId);
            List<EndorseTask> allTasks = this.createSchedulingTasks(ctx);
            List<EndorseTask> tasks = this.resolveTasks(ctx, allTasks);
            SchedulingResult result = this.doExecute(ctx, tasks);
            return result;
        }
        catch (Exception e) {
            logger.error("reschedule", (Throwable)e);
            SchedulingResult result = new SchedulingResult();
            result.setEntryId(entryId);
            result.setSuccess(false);
            result.setFailedOp("unknown");
            return result;
        }
    }

    private List<EndorseTask> resolveTasks(SchedulingContext ctx, List<EndorseTask> allTasks) {
        List<EndorseTask> subTasks;
        DynamicObject allocBill = ctx.getAllocBill();
        Long entryId = ctx.getEntryId();
        QFilter qFilter = new QFilter("allocbillentryid", "=", (Object)entryId);
        qFilter.and("source", "=", (Object)"cdm-draftallocate");
        DynamicObject[] endorseBizBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id, billstatus, sourcebillid", (QFilter[])qFilter.toArray());
        if (endorseBizBills == null || endorseBizBills.length == 0) {
            return allTasks;
        }
        if (endorseBizBills.length > 2) {
            throw new KDBizException("more then two drafttradebill found");
        }
        DynamicObject firstEndorseBill = null;
        DynamicObject secEndorseBill = null;
        if (endorseBizBills.length == 1) {
            if (Objects.equals(allocBill.getPkValue(), endorseBizBills[0].getLong("sourcebillid"))) {
                firstEndorseBill = endorseBizBills[0];
            }
        } else {
            for (DynamicObject endorseBill : endorseBizBills) {
                if (Objects.equals(allocBill.getPkValue(), endorseBill.getLong("sourcebillid"))) {
                    firstEndorseBill = endorseBill;
                    continue;
                }
                secEndorseBill = endorseBill;
            }
        }
        if (secEndorseBill != null) {
            Long secEndorseBillId = (Long)secEndorseBill.getPkValue();
            QFilter recBillQFilter = new QFilter("sourcebillid", "=", (Object)secEndorseBillId);
            recBillQFilter.and("sourcebilltype", "=", (Object)"cdm_drafttradebill");
            DynamicObject[] recBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])qFilter.toArray());
            if (recBills == null || recBills.length == 0) {
                ctx.setCurrentBillId(secEndorseBillId);
                ctx.setCurrentBillType("cdm_drafttradebill");
                subTasks = allTasks.subList(allTasks.size() - 1, allTasks.size());
                return subTasks;
            }
            ctx.enterBill((Long)recBills[0].getPkValue(), "cdm_receivablebill");
            return new ArrayList<EndorseTask>(0);
        }
        if (firstEndorseBill != null) {
            QFilter recBillQFilter = new QFilter("sourcebillid", "=", firstEndorseBill.getPkValue());
            recBillQFilter.and("sourcebilltype", "=", (Object)"cdm_drafttradebill");
            DynamicObject[] recBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])qFilter.toArray());
            if (recBills == null || recBills.length == 0) {
                Long endorseBillId = (Long)firstEndorseBill.getPkValue();
                ctx.enterBill(endorseBillId, "cdm_drafttradebill");
                subTasks = allTasks.subList(1, allTasks.size());
                return subTasks;
            }
            Long recDraftId = (Long)recBills[0].getPkValue();
            ctx.enterBill(recDraftId, "cdm_receivablebill");
            subTasks = allTasks.subList(2, allTasks.size());
            return subTasks;
        }
        throw new KDBizException("failed to found downstream bills");
    }
}

