/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation.scheduling;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SchedulingContext {
    private DynamicObject allocBill;
    private Long entryId;
    private DynamicObject originDraft;
    private String biztype;
    private Long currentBillId;
    private String currentBillType;
    private boolean indrectTransfer = false;

    public SchedulingContext(DynamicObject allocBill, Long entryId) {
        this.allocBill = allocBill;
        this.entryId = entryId;
        this.biztype = allocBill.getString("biztype");
        if (DraftAllocateBizTypeEnum.ALLOCATE.getValue().equals(this.biztype)) {
            DynamicObject billPool = allocBill.getDynamicObject("billpool");
            this.indrectTransfer = DispatchRuleEnum.INDIRECT.getValue().equals(billPool.getString("dispatchrule"));
        }
        DynamicObjectCollection entrys = allocBill.getDynamicObjectCollection("entryentity");
        List draftIds = entrys.stream().filter(e -> entryId.equals(e.getPkValue()) && e.getDynamicObject("e_draftbill") != null).map(o -> (Long)o.getDynamicObject("e_draftbill").getPkValue()).collect(Collectors.toList());
        Long draftId = (Long)draftIds.get(0);
        this.originDraft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"cdm_receivablebill");
    }

    public void enterBill(Long billId, String billType) {
        this.currentBillId = billId;
        this.currentBillType = billType;
    }

    public boolean isIndrectTransfer() {
        return this.indrectTransfer;
    }

    public Long getCurrentBillId() {
        return this.currentBillId;
    }

    public void setCurrentBillId(Long currentBillId) {
        this.currentBillId = currentBillId;
    }

    public String getCurrentBillType() {
        return this.currentBillType;
    }

    public void setCurrentBillType(String currentBillType) {
        this.currentBillType = currentBillType;
    }

    public DynamicObject getOriginDraft() {
        return this.originDraft;
    }

    public void setOriginDraft(DynamicObject originDraft) {
        this.originDraft = originDraft;
    }

    public String getBiztype() {
        return this.biztype;
    }

    public DynamicObject getAllocBill() {
        return this.allocBill;
    }

    public void setAllocBill(DynamicObject allocBill) {
        this.allocBill = allocBill;
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }
}

