/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.cdm.common.property.DraftDynamicQueryParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AddBussinessInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AddBussinessInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("org");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("datdate");
        selector.add("inventorydate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        long pkId = DB.genGlobalLongId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_businessnventory");
        MainEntityType bankDraftF7 = EntityMetadataCache.getDataEntityType((String)"cdm_bankdraftdatasf7");
        MainEntityType draftbillF7 = EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7");
        for (DynamicObject data : dataEntities) {
            DynamicObject orgDy = data.getDynamicObject("org");
            DynamicObject bankaccountDy = data.getDynamicObject("bankaccount");
            Date dataDate = data.getDate("datdate");
            Date inventoryDate = data.getDate("inventorydate");
            DynamicObject currenDy = data.getDynamicObject("currency");
            boolean isbyBankAccount = data.getBoolean("isbybankaccount");
            boolean ischeckPaybill = data.getBoolean("ischeckpaybill");
            logger.info("dataDate is:" + dataDate);
            long orgId = orgDy.getLong("id");
            long curreyId = currenDy.getLong("id");
            QFilter orgIdQFilterF7 = new QFilter("e_org", "=", (Object)orgId);
            QFilter dateIdQFilterF7 = new QFilter("e_datadate", "=", (Object)dataDate);
            QFilter curreyIdQFilterF7 = new QFilter("e_billcurrency", "=", (Object)curreyId);
            QFilter paramQFliterF7 = orgIdQFilterF7.and(dateIdQFilterF7).and(curreyIdQFilterF7);
            if (isbyBankAccount) {
                long bankAccountid = bankaccountDy.getLong("id");
                QFilter accountIdQFilterF7 = new QFilter("e_bankaccount", "=", (Object)bankAccountid);
                paramQFliterF7.and(accountIdQFilterF7);
            }
            Object[] bankDraftIdArr = BusinessDataServiceHelper.load((String)"cdm_bankdraftdatasf7", (String)"id", (QFilter[])new QFilter[]{paramQFliterF7});
            DynamicObject[] bankDraftArr = new DynamicObject[]{};
            if (EmptyUtil.isNoEmpty((Object[])bankDraftIdArr)) {
                Set<Object> bankDraftIdSet = Arrays.stream(bankDraftIdArr).map(e -> e.getLong("id")).collect(Collectors.toSet());
                bankDraftArr = BusinessDataServiceHelper.load((Object[])bankDraftIdSet.toArray(new Object[0]), (DynamicObjectType)bankDraftF7);
            }
            DynamicObject bussinessInventoryDy = new DynamicObject((DynamicObjectType)dataEntityType);
            bussinessInventoryDy.set("id", (Object)pkId);
            String generateNumber = CodeRuleHelper.generateNumber((String)"cdm_businessnventory", (DynamicObject)bussinessInventoryDy, (String)null, (String)null);
            bussinessInventoryDy.set("billno", (Object)generateNumber);
            bussinessInventoryDy.set("company", (Object)orgDy);
            bussinessInventoryDy.set("bankaccount", (Object)bankaccountDy);
            bussinessInventoryDy.set("currency", (Object)currenDy);
            bussinessInventoryDy.set("inventorydate", (Object)inventoryDate);
            bussinessInventoryDy.set("bizdate", (Object)dataDate);
            bussinessInventoryDy.set("isbybankaccount", (Object)isbyBankAccount);
            bussinessInventoryDy.set("ischeckpaybill", (Object)ischeckPaybill);
            bussinessInventoryDy.set("billstatus", (Object)"A");
            bussinessInventoryDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection bank_ncd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_ncd_entryentity");
            DynamicObjectCollection rec_ncd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("rec_ncd_entryentity");
            DynamicObjectCollection bank_ncd_payentryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_ncd_payentryentity");
            DynamicObjectCollection pay_ncd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("pay_ncd_entryentity");
            BigDecimal ncd_bankRecAmountTotal = BigDecimal.ZERO;
            BigDecimal ncd_recAmountTotal = BigDecimal.ZERO;
            BigDecimal ncd_bankPayAmountTotal = BigDecimal.ZERO;
            BigDecimal ncd_payAmountTotal = BigDecimal.ZERO;
            HashSet<DynamicObject> needUpdateBankDraftSet = new HashSet<DynamicObject>(16);
            for (DynamicObject dynamicObject : bankDraftArr) {
                String draftType = dynamicObject.getString("e_biztype");
                if ("pay".equalsIgnoreCase(draftType)) {
                    if (!ischeckPaybill) continue;
                    DynamicObject bank_ncd_payentry = bank_ncd_payentryentity.addNew();
                    bank_ncd_payentry.set("e_ncd_paybankdraft", (Object)dynamicObject);
                    dynamicObject.set("e_inventorystatus", (Object)"B");
                    needUpdateBankDraftSet.add(dynamicObject);
                    ncd_bankPayAmountTotal = ncd_bankPayAmountTotal.add(dynamicObject.getBigDecimal("e_draftamount"));
                    continue;
                }
                DynamicObject bank_ncd_entry = bank_ncd_entryentity.addNew();
                bank_ncd_entry.set("e_ncd_bankdraft", (Object)dynamicObject);
                dynamicObject.set("e_inventorystatus", (Object)"B");
                needUpdateBankDraftSet.add(dynamicObject);
                ncd_bankRecAmountTotal = ncd_bankRecAmountTotal.add(dynamicObject.getBigDecimal("e_draftamount"));
            }
            DraftDynamicQueryParam draftDynamicQueryParam = new DraftDynamicQueryParam();
            draftDynamicQueryParam.setRpType("receivebill");
            draftDynamicQueryParam.setOrgId(Long.valueOf(orgId));
            draftDynamicQueryParam.setCurrencyId(Long.valueOf(curreyId));
            draftDynamicQueryParam.setQueryEndDate(dataDate);
            if (isbyBankAccount) {
                long bankAccountid = bankaccountDy.getLong("id");
                draftDynamicQueryParam.setBankAccountId(Long.valueOf(bankAccountid));
            }
            Set recDraftIdSet = (Set)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"QueryDraftBillIdsService", (String)"queryDraftBillIds", (Object[])new Object[]{JSON.toJSONString((Object)draftDynamicQueryParam)});
            if (ischeckPaybill) {
                draftDynamicQueryParam.setRpType("paybill");
                Set payDraftIdSet = (Set)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"QueryDraftBillIdsService", (String)"queryDraftBillIds", (Object[])new Object[]{JSON.toJSONString((Object)draftDynamicQueryParam)});
                if (EmptyUtil.isNoEmpty((Object)payDraftIdSet)) {
                    recDraftIdSet.addAll(payDraftIdSet);
                }
            }
            if (EmptyUtil.isNoEmpty((Object)recDraftIdSet)) {
                DynamicObject[] draftsArr;
                for (DynamicObject draft : draftsArr = BusinessDataServiceHelper.load((Object[])recDraftIdSet.toArray(new Object[0]), (DynamicObjectType)draftbillF7)) {
                    String rpType = draft.getString("rptype");
                    if ("receivebill".equalsIgnoreCase(rpType)) {
                        DynamicObject rec_ncd_entry = rec_ncd_entryentity.addNew();
                        rec_ncd_entry.set("e_ncd_recdraft", (Object)draft);
                        rec_ncd_entry.set("e_ncd_reccheckstatus", (Object)"A");
                        ncd_recAmountTotal = ncd_recAmountTotal.add(draft.getBigDecimal("amount"));
                        continue;
                    }
                    if (!ischeckPaybill) continue;
                    DynamicObject pay_ncd_entry = pay_ncd_entryentity.addNew();
                    pay_ncd_entry.set("e_ncd_paydraft", (Object)draft);
                    pay_ncd_entry.set("e_ncd_paycheckstatus", (Object)"A");
                    ncd_payAmountTotal = ncd_payAmountTotal.add(draft.getBigDecimal("amount"));
                }
            }
            int bankDraftCount = bank_ncd_entryentity.size();
            bussinessInventoryDy.set("recbankdraftcount", (Object)bankDraftCount);
            bussinessInventoryDy.set("recbankdraftamount", (Object)ncd_bankRecAmountTotal);
            int n = rec_ncd_entryentity.size();
            bussinessInventoryDy.set("recdraftcount", (Object)n);
            bussinessInventoryDy.set("recdraftamount", (Object)ncd_recAmountTotal);
            bussinessInventoryDy.set("recdiffereamount", (Object)ncd_bankRecAmountTotal.subtract(ncd_recAmountTotal));
            if (ischeckPaybill) {
                int bankPayDraftCount = bank_ncd_payentryentity.size();
                bussinessInventoryDy.set("paybankdraftcount", (Object)bankPayDraftCount);
                bussinessInventoryDy.set("paybankdraftamount", (Object)ncd_bankPayAmountTotal);
                int payDraftCount = pay_ncd_entryentity.size();
                bussinessInventoryDy.set("paydraftcount", (Object)payDraftCount);
                bussinessInventoryDy.set("paydraftamount", (Object)ncd_payAmountTotal);
                bussinessInventoryDy.set("paydiffereamount", (Object)ncd_bankPayAmountTotal.subtract(ncd_payAmountTotal));
            }
            if (EmptyUtil.isNoEmpty(needUpdateBankDraftSet)) {
                SaveServiceHelper.save((DynamicObject[])needUpdateBankDraftSet.toArray(new DynamicObject[0]));
            }
            OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_businessnventory", (DynamicObject[])new DynamicObject[]{bussinessInventoryDy}, (OperateOption)OperateOption.create());
            this.operationResult.setSuccess(true);
            this.operationResult.getBillNos().put("inventoryBillId", String.valueOf(pkId));
        }
    }
}

