/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AutoInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AutoInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        MainEntityType typeBankDataF7 = EntityMetadataCache.getDataEntityType((String)"cdm_bankdraftdatasf7");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7");
        HashSet<DynamicObject> needUpdateInventoryDataSet = new HashSet<DynamicObject>(16);
        HashSet needUpdateBankDraftsSet = new HashSet(16);
        for (DynamicObject data : dataEntities) {
            boolean ischeckPaybill = data.getBoolean("ischeckpaybill");
            DynamicObjectCollection bank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_entryentity");
            DynamicObjectCollection rec_ncd_entryentity = data.getDynamicObjectCollection("rec_ncd_entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bank_ncd_entryentity) && bank_ncd_entryentity.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)rec_ncd_entryentity) && rec_ncd_entryentity.size() > 0) {
                HashMap draftnoSubRangeAndIdMap = new HashMap(16);
                for (DynamicObject bank_ncd_entry : bank_ncd_entryentity) {
                    DynamicObject e_ncd_bankdraft = bank_ncd_entry.getDynamicObject("e_ncd_bankdraft");
                    long entryid = e_ncd_bankdraft.getLong("id");
                    Object e_subbillRange = e_ncd_bankdraft.getString("e_subbillrange");
                    String e_draftBillno = e_ncd_bankdraft.getString("e_draftbillno");
                    e_subbillRange = this.getSubRange((String)e_subbillRange);
                    String keyStr = e_draftBillno + ":" + (String)e_subbillRange;
                    if (!draftnoSubRangeAndIdMap.containsKey(keyStr)) {
                        HashSet<Long> entryIdSet = new HashSet<Long>(1);
                        entryIdSet.add(entryid);
                        draftnoSubRangeAndIdMap.put(keyStr, entryIdSet);
                        continue;
                    }
                    ((Set)draftnoSubRangeAndIdMap.get(keyStr)).add(entryid);
                }
                Set<Object> draftbillIdSet = rec_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_recdraft").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] draftBillSet = BusinessDataServiceHelper.load((Object[])draftbillIdSet.toArray(new Object[0]), (DynamicObjectType)type);
                Map<Long, DynamicObject> draftIdAndDyMap = Arrays.stream(draftBillSet).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                HashSet inventoriedBankDraftSet = new HashSet(16);
                HashSet<Long> inventoriedDraftSet = new HashSet<Long>(16);
                for (DynamicObject rec_ncd_entry : rec_ncd_entryentity) {
                    DynamicObject e_ncd_recdraft = rec_ncd_entry.getDynamicObject("e_ncd_recdraft");
                    long draftId = e_ncd_recdraft.getLong("id");
                    DynamicObject draftDy = (DynamicObject)draftIdAndDyMap.get(draftId);
                    String draftStatus = draftDy.getString("draftbillstatus");
                    String draftBillno = draftDy.getString("draftbillno");
                    String subbillRange = draftDy.getString("subbillrange");
                    subbillRange = this.getSubRange(subbillRange);
                    String keyStr = draftBillno + ":" + subbillRange;
                    Set bankDraftIdSet = (Set)draftnoSubRangeAndIdMap.get(keyStr);
                    if (!EmptyUtil.isNoEmpty((Object)bankDraftIdSet)) continue;
                    inventoriedBankDraftSet.addAll(bankDraftIdSet);
                    inventoriedDraftSet.add(draftId);
                }
                if (EmptyUtil.isNoEmpty(inventoriedBankDraftSet)) {
                    rec_ncd_entryentity.removeIf(e -> inventoriedDraftSet.contains(e.getDynamicObject("e_ncd_recdraft").getLong("id")));
                    bank_ncd_entryentity.removeIf(e -> inventoriedBankDraftSet.contains(e.getDynamicObject("e_ncd_bankdraft").getLong("id")));
                    DynamicObjectCollection bank_cd_entryentity = data.getDynamicObjectCollection("bank_cd_entryentity");
                    DynamicObjectCollection rec_cd_entryentity = data.getDynamicObjectCollection("rec_cd_entryentity");
                    DynamicObject[] bankDraftDataArr = BusinessDataServiceHelper.load((Object[])inventoriedBankDraftSet.toArray(new Object[0]), (DynamicObjectType)typeBankDataF7);
                    for (DynamicObject bankDraftData : bankDraftDataArr) {
                        bankDraftData.set("e_checkstatus", (Object)"B");
                        bankDraftData.set("e_inventorystatus", (Object)"B");
                        DynamicObject cd_bank_entry = bank_cd_entryentity.addNew();
                        cd_bank_entry.set("e_cd_bankdraft", (Object)bankDraftData);
                    }
                    needUpdateBankDraftsSet.addAll(Arrays.stream(bankDraftDataArr).collect(Collectors.toSet()));
                    for (Long inventoriedDraft : inventoriedDraftSet) {
                        DynamicObject rec_cd_entry = rec_cd_entryentity.addNew();
                        DynamicObject draftDy = (DynamicObject)draftIdAndDyMap.get(inventoriedDraft);
                        rec_cd_entry.set("e_cd_recdraft", (Object)draftDy);
                        rec_cd_entry.set("e_cd_reccheckstatus", (Object)"B");
                    }
                    needUpdateInventoryDataSet.add(data);
                }
            }
            if (!ischeckPaybill) continue;
            DynamicObjectCollection payBank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_payentryentity");
            DynamicObjectCollection pay_ncd_entryentity = data.getDynamicObjectCollection("pay_ncd_entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)payBank_ncd_entryentity) || payBank_ncd_entryentity.size() <= 0 || !EmptyUtil.isNoEmpty((DynamicObjectCollection)pay_ncd_entryentity) || pay_ncd_entryentity.size() <= 0) continue;
            HashMap draftnoSubRangeAndIdMap = new HashMap(16);
            for (DynamicObject bank_ncd_entry : payBank_ncd_entryentity) {
                DynamicObject e_ncd_bankdraft = bank_ncd_entry.getDynamicObject("e_ncd_paybankdraft");
                long entryid = e_ncd_bankdraft.getLong("id");
                Object e_subbillRange = e_ncd_bankdraft.getString("e_subbillrange");
                String e_draftBillno = e_ncd_bankdraft.getString("e_draftbillno");
                e_subbillRange = this.getSubRange((String)e_subbillRange);
                String keyStr = e_draftBillno + ":" + (String)e_subbillRange;
                if (!draftnoSubRangeAndIdMap.containsKey(keyStr)) {
                    HashSet<Long> entryIdSet = new HashSet<Long>(1);
                    entryIdSet.add(entryid);
                    draftnoSubRangeAndIdMap.put(keyStr, entryIdSet);
                    continue;
                }
                ((Set)draftnoSubRangeAndIdMap.get(keyStr)).add(entryid);
            }
            Set<Object> draftbillIdSet = pay_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_paydraft").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] draftBillSet = BusinessDataServiceHelper.load((Object[])draftbillIdSet.toArray(new Object[0]), (DynamicObjectType)type);
            Map<Long, DynamicObject> draftIdAndDyMap = Arrays.stream(draftBillSet).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            HashSet inventoriedBankDraftSet = new HashSet(16);
            HashSet<Long> inventoriedDraftSet = new HashSet<Long>(16);
            for (DynamicObject rec_ncd_entry : pay_ncd_entryentity) {
                DynamicObject e_ncd_recdraft = rec_ncd_entry.getDynamicObject("e_ncd_paydraft");
                long draftId = e_ncd_recdraft.getLong("id");
                DynamicObject draftDy = draftIdAndDyMap.get(draftId);
                String draftStatus = draftDy.getString("draftbillstatus");
                String draftBillno = draftDy.getString("draftbillno");
                String subbillRange = draftDy.getString("subbillrange");
                subbillRange = this.getSubRange(subbillRange);
                String keyStr = draftBillno + ":" + subbillRange;
                Set bankDraftIdSet = (Set)draftnoSubRangeAndIdMap.get(keyStr);
                if (!EmptyUtil.isNoEmpty((Object)bankDraftIdSet)) continue;
                inventoriedBankDraftSet.addAll(bankDraftIdSet);
                inventoriedDraftSet.add(draftId);
            }
            if (!EmptyUtil.isNoEmpty(inventoriedBankDraftSet)) continue;
            pay_ncd_entryentity.removeIf(e -> inventoriedDraftSet.contains(e.getDynamicObject("e_ncd_paydraft").getLong("id")));
            payBank_ncd_entryentity.removeIf(e -> inventoriedBankDraftSet.contains(e.getDynamicObject("e_ncd_paybankdraft").getLong("id")));
            DynamicObjectCollection bank_cd_entryentity = data.getDynamicObjectCollection("bank_cd_payentryentity");
            DynamicObjectCollection rec_cd_entryentity = data.getDynamicObjectCollection("pay_cd_entryentity");
            DynamicObject[] bankDraftDataArr = BusinessDataServiceHelper.load((Object[])inventoriedBankDraftSet.toArray(new Object[0]), (DynamicObjectType)typeBankDataF7);
            for (DynamicObject bankDraftData : bankDraftDataArr) {
                bankDraftData.set("e_checkstatus", (Object)"B");
                bankDraftData.set("e_inventorystatus", (Object)"B");
                DynamicObject cd_bank_entry = bank_cd_entryentity.addNew();
                cd_bank_entry.set("e_cd_paybankdraft", (Object)bankDraftData);
            }
            needUpdateBankDraftsSet.addAll(Arrays.stream(bankDraftDataArr).collect(Collectors.toSet()));
            for (Long inventoriedDraft : inventoriedDraftSet) {
                DynamicObject rec_cd_entry = rec_cd_entryentity.addNew();
                DynamicObject draftDy = draftIdAndDyMap.get(inventoriedDraft);
                rec_cd_entry.set("e_cd_paydraft", (Object)draftDy);
                rec_cd_entry.set("e_cd_paycheckstatus", (Object)"B");
            }
            needUpdateInventoryDataSet.add(data);
        }
        if (EmptyUtil.isNoEmpty(needUpdateInventoryDataSet) && needUpdateInventoryDataSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateInventoryDataSet.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(needUpdateBankDraftsSet) && needUpdateBankDraftsSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBankDraftsSet.toArray(new DynamicObject[0]));
        }
    }

    private String getSubRange(String e_subbillRange) {
        if (EmptyUtil.isNoEmpty((String)e_subbillRange)) {
            if (e_subbillRange.contains("-")) {
                String[] splitArr = e_subbillRange.split("-", -1);
                long startFlag = Long.parseLong(splitArr[0]);
                long endFlag = Long.parseLong(splitArr[1]);
                e_subbillRange = startFlag + "-" + endFlag;
            } else {
                e_subbillRange = "";
            }
        }
        return e_subbillRange;
    }
}

