/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDraftsSaveService
extends AbstractTmcBizOppService {
    private static final Log LOGGERTOOL = LogFactory.getLog(BankDraftsSaveService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("bankaccount");
        selector.add("totalamount");
        selector.add("org");
        selector.add("billcurrency");
        selector.add("biztype");
        selector.add("count");
        selector.add("datadate");
        selector.add("importway");
        selector.add("isonlynewdraft");
        selector.add("bankdraftentry");
        selector.add("e_org");
        selector.add("e_bankaccount");
        selector.add("e_draftamount");
        selector.add("e_billcurrency");
        selector.add("e_datadate");
        selector.add("e_biztype");
        selector.add("e_subbillrange");
        selector.add("e_subbillstartflag");
        selector.add("e_subbillendflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            int count;
            long dataId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("bankdraftentry");
            DynamicObject org = data.getDynamicObject("org");
            long orgId = org.getLong("id");
            String bizTypeStr = data.getString("biztype");
            DynamicObject bankAcc = data.getDynamicObject("bankaccount");
            long bankAccId = bankAcc.getLong("id");
            DynamicObject currency = data.getDynamicObject("billcurrency");
            long currencyId = currency.getLong("id");
            Date dataDate = data.getDate("datadate");
            String dateStr = DateUtils.formatString((Date)dataDate, (String)"yyyy-MM-dd");
            Date newDate = DateUtils.stringToDate((String)dateStr, (String)"yyyy-MM-dd");
            BigDecimal totalAmount = data.getBigDecimal("totalamount");
            if (EmptyUtil.isEmpty((BigDecimal)totalAmount) || BigDecimal.ZERO.compareTo(totalAmount) == 0) {
                BigDecimal amountSum = entrys.stream().map(d -> d.getBigDecimal("e_draftamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                data.set("totalamount", (Object)amountSum);
            }
            if (EmptyUtil.isEmpty((Integer)(count = data.getInt("count"))) && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                data.set("count", (Object)entrys.size());
            }
            for (DynamicObject entry : entrys) {
                DynamicObject e_org = entry.getDynamicObject("e_org");
                String e_bizTypeStr = entry.getString("e_biztype");
                DynamicObject e_bankAcc = entry.getDynamicObject("e_bankaccount");
                DynamicObject e_currency = entry.getDynamicObject("e_billcurrency");
                if (EmptyUtil.isEmpty((DynamicObject)e_org) || e_org.getLong("id") != orgId) {
                    entry.set("e_org", (Object)org);
                }
                if (EmptyUtil.isEmpty((String)e_bizTypeStr) || !bizTypeStr.equals(e_bizTypeStr)) {
                    entry.set("e_biztype", (Object)bizTypeStr);
                }
                if (EmptyUtil.isEmpty((DynamicObject)e_bankAcc) || e_bankAcc.getLong("id") != bankAccId) {
                    entry.set("e_bankaccount", (Object)bankAcc);
                }
                if (EmptyUtil.isEmpty((DynamicObject)e_currency) || e_currency.getLong("id") != currencyId) {
                    entry.set("e_billcurrency", (Object)currency);
                }
                entry.set("e_datadate", (Object)dataDate);
                boolean isSplit = entry.getBoolean("e_issplit");
                if (isSplit) continue;
                entry.set("e_subbillstartflag", (Object)0L);
                entry.set("e_subbillendflag", (Object)0L);
                entry.set("e_subbillrange", (Object)"0");
            }
            DynamicObjectCollection needCoverData = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccount", "=", (Object)bankAcc.getLong("id")), new QFilter("datadate", "=", (Object)newDate), new QFilter("id", "!=", (Object)dataId)});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)needCoverData)) continue;
            LOGGERTOOL.info("will cover data is:" + needCoverData);
            Set coverId = needCoverData.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((String)"cdm_bankdrafts", (QFilter[])new QFilter[]{new QFilter("id", "in", coverId)});
        }
    }
}

