/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BussinessInventoryAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BussinessInventoryAuditService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("draftinventoryreport");
        selector.add("draftinventoryreportid");
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("description");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("process is start");
        MainEntityType inventoryResultType = EntityMetadataCache.getDataEntityType((String)"cdm_inventoryresult");
        HashSet<DynamicObject> needUpdateInventoryDataSet = new HashSet<DynamicObject>(16);
        for (DynamicObject bussinessInventoryDy : dataEntities) {
            boolean ischeckPaybill = bussinessInventoryDy.getBoolean("ischeckpaybill");
            DynamicObject inventoryResultDy = this.fillInventoryHeadInfo((DynamicObjectType)inventoryResultType, bussinessInventoryDy);
            this.fillRecInventoryInfo(bussinessInventoryDy, inventoryResultDy);
            if (ischeckPaybill) {
                this.fillPayInventoryInfo(bussinessInventoryDy, inventoryResultDy);
            }
            needUpdateInventoryDataSet.add(inventoryResultDy);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])needUpdateInventoryDataSet.toArray(new DynamicObject[0]));
    }

    private DynamicObject fillInventoryHeadInfo(DynamicObjectType inventoryResultType, DynamicObject bussinessInventoryDy) {
        boolean ischeckPaybill = bussinessInventoryDy.getBoolean("ischeckpaybill");
        DynamicObject bankAcc = bussinessInventoryDy.getDynamicObject("bankaccount");
        DynamicObject orgDy = bussinessInventoryDy.getDynamicObject("company");
        DynamicObject currencyDy = bussinessInventoryDy.getDynamicObject("currency");
        Date inventoryDate = bussinessInventoryDy.getDate("inventorydate");
        Date dataDate = bussinessInventoryDy.getDate("bizdate");
        boolean isbybankAccount = bussinessInventoryDy.getBoolean("isbybankaccount");
        long inventoryId = bussinessInventoryDy.getLong("id");
        DynamicObject inventoryResultDy = new DynamicObject(inventoryResultType);
        long pkId = DB.genGlobalLongId();
        inventoryResultDy.set("id", (Object)pkId);
        String generateNumber = CodeRuleHelper.generateNumber((String)"cdm_inventoryresult", (DynamicObject)inventoryResultDy, (String)null, (String)null);
        inventoryResultDy.set("billno", (Object)generateNumber);
        inventoryResultDy.set("bankaccount", (Object)bankAcc);
        inventoryResultDy.set("currency", (Object)currencyDy);
        inventoryResultDy.set("company", (Object)orgDy);
        inventoryResultDy.set("inventorydate", (Object)inventoryDate);
        inventoryResultDy.set("bizdate", (Object)dataDate);
        inventoryResultDy.set("isbybankaccount", (Object)isbybankAccount);
        inventoryResultDy.set("ischeckpaybill", (Object)ischeckPaybill);
        inventoryResultDy.set("sourcebillid", (Object)inventoryId);
        inventoryResultDy.set("inventorytype", (Object)"business");
        inventoryResultDy.set("billstatus", (Object)"A");
        String description = bussinessInventoryDy.getString("description");
        inventoryResultDy.set("description", (Object)description);
        inventoryResultDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        bussinessInventoryDy.set("draftinventoryreport", (Object)generateNumber);
        bussinessInventoryDy.set("draftinventoryreportid", (Object)pkId);
        return inventoryResultDy;
    }

    private void fillRecInventoryInfo(DynamicObject bussinessInventoryDy, DynamicObject inventoryResultDy) {
        BigDecimal buss_ncd_bank_amountSum = BigDecimal.ZERO;
        DynamicObjectCollection buss_bank_ncd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_ncd_entryentity");
        DynamicObjectCollection result_bank_ncd_entryentity = inventoryResultDy.getDynamicObjectCollection("bank_ncd_entryentity");
        for (DynamicObject bank_ncd_entry : buss_bank_ncd_entryentity) {
            DynamicObject result_bank_ncd_entry = result_bank_ncd_entryentity.addNew();
            DynamicObject buss_e_ncd_bankdraft = bank_ncd_entry.getDynamicObject("e_ncd_bankdraft");
            result_bank_ncd_entry.set("e_ncd_bankdraft", (Object)buss_e_ncd_bankdraft);
            buss_ncd_bank_amountSum = buss_ncd_bank_amountSum.add(buss_e_ncd_bankdraft.getBigDecimal("e_draftamount"));
        }
        DynamicObjectCollection buss_rec_ncd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("rec_ncd_entryentity");
        DynamicObjectCollection result_rec_ncd_entryentity = inventoryResultDy.getDynamicObjectCollection("rec_ncd_entryentity");
        BigDecimal buss_ncd_rec_amountSum = BigDecimal.ZERO;
        for (DynamicObject buss_rec_ncd_entry : buss_rec_ncd_entryentity) {
            DynamicObject result_rec_ncd_entry = result_rec_ncd_entryentity.addNew();
            DynamicObject buss_e_ncd_recdraft = buss_rec_ncd_entry.getDynamicObject("e_ncd_recdraft");
            result_rec_ncd_entry.set("e_ncd_recdraft", (Object)buss_e_ncd_recdraft);
            buss_ncd_rec_amountSum = buss_ncd_rec_amountSum.add(buss_e_ncd_recdraft.getBigDecimal("amount"));
        }
        DynamicObjectCollection bank_cd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_cd_entryentity");
        BigDecimal buss_cd_bankAmountSum = bank_cd_entryentity.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_bankdraft"))).map(v -> v.getDynamicObject("e_cd_bankdraft").getBigDecimal("e_draftamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("reccdbankdraftamount", (Object)buss_cd_bankAmountSum);
        inventoryResultDy.set("recncddraftamount", (Object)buss_ncd_rec_amountSum);
        BigDecimal bankAdj = buss_cd_bankAmountSum.subtract(buss_ncd_rec_amountSum);
        inventoryResultDy.set("recbankadjamount", (Object)bankAdj);
        DynamicObjectCollection rec_cd_entryentity = bussinessInventoryDy.getDynamicObjectCollection("rec_cd_entryentity");
        BigDecimal buss_cd_recAmountSum = rec_cd_entryentity.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_recdraft"))).map(v -> v.getDynamicObject("e_cd_recdraft").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("reccddraftamount", (Object)buss_cd_recAmountSum);
        inventoryResultDy.set("recncdbankamount", (Object)buss_ncd_bank_amountSum);
        BigDecimal recAdj = buss_cd_recAmountSum.add(buss_ncd_bank_amountSum);
        inventoryResultDy.set("recdraftadjamount", (Object)recAdj);
        inventoryResultDy.set("recbdiffamount", (Object)bankAdj.subtract(recAdj));
    }

    private void fillPayInventoryInfo(DynamicObject bussinessInventoryDy, DynamicObject inventoryResultDy) {
        BigDecimal buss_ncd_bank_pay_amountSum = BigDecimal.ZERO;
        DynamicObjectCollection buss_bank_ncd_payEntryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_ncd_payentryentity");
        DynamicObjectCollection result_bank_ncd_payEntryentity = inventoryResultDy.getDynamicObjectCollection("bank_ncd_payentryentity");
        for (DynamicObject bank_ncd_payentry : buss_bank_ncd_payEntryentity) {
            DynamicObject result_bank_ncd_payEntry = result_bank_ncd_payEntryentity.addNew();
            DynamicObject buss_e_ncd_payBankdraft = bank_ncd_payentry.getDynamicObject("e_ncd_paybankdraft");
            result_bank_ncd_payEntry.set("e_ncd_paybankdraft", (Object)buss_e_ncd_payBankdraft);
            buss_ncd_bank_pay_amountSum = buss_ncd_bank_pay_amountSum.add(buss_e_ncd_payBankdraft.getBigDecimal("e_draftamount"));
        }
        BigDecimal buss_ncd_draft_pay_amountSum = BigDecimal.ZERO;
        DynamicObjectCollection buss_draft_ncd_payEntryentity = bussinessInventoryDy.getDynamicObjectCollection("pay_ncd_entryentity");
        DynamicObjectCollection result_ncd_payEntryentity = inventoryResultDy.getDynamicObjectCollection("pay_ncd_entryentity");
        for (DynamicObject draft_ncd_payentry : buss_draft_ncd_payEntryentity) {
            DynamicObject result_bank_ncd_payEntry = result_ncd_payEntryentity.addNew();
            DynamicObject buss_e_ncd_paydraft = draft_ncd_payentry.getDynamicObject("e_ncd_paydraft");
            result_bank_ncd_payEntry.set("e_ncd_paydraft", (Object)buss_e_ncd_paydraft);
            buss_ncd_draft_pay_amountSum = buss_ncd_draft_pay_amountSum.add(buss_e_ncd_paydraft.getBigDecimal("amount"));
        }
        DynamicObjectCollection bank_cd_payEntryentity = bussinessInventoryDy.getDynamicObjectCollection("bank_cd_payentryentity");
        BigDecimal buss_cd_bankPayAmountSum = bank_cd_payEntryentity.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_paybankdraft"))).map(v -> v.getDynamicObject("e_cd_paybankdraft").getBigDecimal("e_draftamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("paycdbankdraftamount", (Object)buss_cd_bankPayAmountSum);
        inventoryResultDy.set("payncddraftamount", (Object)buss_ncd_draft_pay_amountSum);
        BigDecimal bankAdjAmount = buss_cd_bankPayAmountSum.subtract(buss_ncd_draft_pay_amountSum);
        inventoryResultDy.set("paybankadjamount", (Object)bankAdjAmount);
        DynamicObjectCollection draft_cd_payEntryentity = bussinessInventoryDy.getDynamicObjectCollection("pay_cd_entryentity");
        BigDecimal buss_cd_payAmountSum = draft_cd_payEntryentity.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_paydraft"))).map(v -> v.getDynamicObject("e_cd_paydraft").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("paycddraftamount", (Object)buss_cd_payAmountSum);
        inventoryResultDy.set("payncdbankamount", (Object)buss_ncd_bank_pay_amountSum);
        BigDecimal payDraftAdjAmount = buss_cd_payAmountSum.add(buss_ncd_bank_pay_amountSum);
        inventoryResultDy.set("paydraftadjamount", (Object)payDraftAdjAmount);
        inventoryResultDy.set("paybddiffamount", (Object)bankAdjAmount.subtract(payDraftAdjAmount));
    }
}

