/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.common.enums.DataSourceMethodEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class GenDraftsByInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(GenDraftsByInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    /*
     * WARNING - void declaration
     */
    public void process(DynamicObject[] dataEntities) throws KDException {
        MainEntityType typeBankDataF7 = EntityMetadataCache.getDataEntityType((String)"cdm_bankdraftdatasf7");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7");
        HashSet<DynamicObject> needUpdateBankDraftsSet = new HashSet<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            boolean ischeckPaybill = data.getBoolean("ischeckpaybill");
            DynamicObjectCollection bank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_entryentity");
            DynamicObjectCollection rec_ncd_entryentity = data.getDynamicObjectCollection("rec_ncd_entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)bank_ncd_entryentity) || bank_ncd_entryentity.size() <= 0) continue;
            Set ncd_bankDraftIdSet = bank_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_bankdraft").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] ncdBankDraftsArr = BusinessDataServiceHelper.load((Object[])ncd_bankDraftIdSet.toArray(), (DynamicObjectType)typeBankDataF7);
            HashSet<String> rec_ncdKeySet = new HashSet<String>(16);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rec_ncd_entryentity) && rec_ncd_entryentity.size() > 0) {
                Set ncd_recDraftIdSet = rec_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_recdraft").getLong("id")).collect(Collectors.toSet());
                DynamicObjectCollection ncdRecDraftsArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,subbillrange,draftbillno", (QFilter[])new QFilter[]{new QFilter("id", "in", ncd_recDraftIdSet)});
                for (DynamicObject ncdRecDraft : ncdRecDraftsArr) {
                    void var20_26;
                    String draftBillNo = ncdRecDraft.getString("draftbillno");
                    String string = ncdRecDraft.getString("subbillrange");
                    if (EmptyUtil.isEmpty((String)string) || "0".equals(string)) {
                        String string2 = "0";
                    }
                    String keyStr = draftBillNo + ":" + (String)var20_26;
                    rec_ncdKeySet.add(keyStr);
                }
            }
            MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal");
            DynamicObject accountBank = data.getDynamicObject("bankaccount");
            Set<Long> openBankIdSet = new HashSet<Long>(16);
            if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
                long bankId = accountBank.getDynamicObject("bank").getLong("id");
                openBankIdSet.add(bankId);
            } else {
                Set bankIdSet = Arrays.stream(ncdBankDraftsArr).filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("e_bankaccount"))).map(e -> e.getDynamicObject("e_bankaccount").getDynamicObject("bank").getLong("id")).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty(bankIdSet)) {
                    openBankIdSet = bankIdSet;
                }
            }
            Map<Object, Object> bankIdAndCateMap = new HashMap(16);
            if (EmptyUtil.isNoEmpty(openBankIdSet)) {
                DynamicObjectCollection bankDyColl = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bank_cate,finorgtype", (QFilter[])new QFilter[]{new QFilter("id", "in", openBankIdSet)});
                bankIdAndCateMap = bankDyColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("bank_cate")));
            }
            HashSet<DynamicObject> eleRecDraftSet = new HashSet<DynamicObject>(16);
            for (DynamicObject ncd_bankDraft : ncdBankDraftsArr) {
                String bankKeyStr;
                String draftBillNo = ncd_bankDraft.getString("e_draftbillno");
                String subRange = ncd_bankDraft.getString("e_subbillrange");
                if (EmptyUtil.isEmpty((String)subRange) || "0".equals(subRange)) {
                    subRange = "0";
                }
                if (rec_ncdKeySet.contains(bankKeyStr = draftBillNo + ":" + subRange)) continue;
                long pkId = DB.genLongId((String)draftBillEntityType.getAlias());
                DynamicObject eleDraftBill = new DynamicObject((DynamicObjectType)draftBillEntityType, (Object)pkId);
                eleDraftBill.set("issueticketdate", (Object)ncd_bankDraft.getDate("e_issuedate"));
                eleDraftBill.set("ticketstatus", (Object)ncd_bankDraft.getString("e_ticketstatus"));
                eleDraftBill.set("bizdate", (Object)data.getDate("inventorydate"));
                eleDraftBill.set("exchangebillexpiredate", (Object)ncd_bankDraft.getDate("e_draftbillexpiredate"));
                eleDraftBill.set("billno", (Object)ncd_bankDraft.getString("e_draftbillno"));
                eleDraftBill.set("currencytext", (Object)(null != ncd_bankDraft.getDynamicObject("e_billcurrency") ? ncd_bankDraft.getDynamicObject("e_billcurrency").getString("name") : ""));
                eleDraftBill.set("currency", null != ncd_bankDraft.getDynamicObject("e_billcurrency") ? ncd_bankDraft.getDynamicObject("e_billcurrency") : Long.valueOf(0L));
                eleDraftBill.set("issueticketertext", (Object)ncd_bankDraft.getString("e_drawername"));
                eleDraftBill.set("issueticketacctext", (Object)ncd_bankDraft.getString("e_draweraccountname"));
                eleDraftBill.set("issueticketbanktext", (Object)(null != ncd_bankDraft.getDynamicObject("e_drawerbank") ? ncd_bankDraft.getDynamicObject("e_drawerbank").getString("name") : ""));
                eleDraftBill.set("issueticketbankno", (Object)ncd_bankDraft.getString("e_drawerbankno"));
                eleDraftBill.set("collectionertext", (Object)ncd_bankDraft.getString("e_receivername"));
                eleDraftBill.set("collectionacctext", (Object)ncd_bankDraft.getString("e_receiveraccount"));
                eleDraftBill.set("collectionbanktext", (Object)(null != ncd_bankDraft.getDynamicObject("e_receiverbank") ? ncd_bankDraft.getDynamicObject("e_receiverbank").getString("name") : ""));
                eleDraftBill.set("collectionbankno", (Object)ncd_bankDraft.getString("e_receiverbankno"));
                eleDraftBill.set("promisertext", (Object)ncd_bankDraft.getString("e_acceptername"));
                eleDraftBill.set("promiseracctext", (Object)ncd_bankDraft.getString("e_accepteraccount"));
                eleDraftBill.set("promiserbanktext", (Object)(null != ncd_bankDraft.getDynamicObject("e_accepterbank") ? ncd_bankDraft.getDynamicObject("e_accepterbank").getString("name") : ""));
                eleDraftBill.set("promiserbankno", (Object)ncd_bankDraft.getString("e_accepterbankno"));
                eleDraftBill.set("istransfer", (Object)("EM01".equals(ncd_bankDraft.getString("e_transferflag")) ? "0" : "1"));
                eleDraftBill.set("promisedate", (Object)ncd_bankDraft.getDate("e_issuedate"));
                eleDraftBill.set("promiseinfo", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u5df2\u7ecf\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                eleDraftBill.set("amount", (Object)ncd_bankDraft.getBigDecimal("e_draftamount"));
                eleDraftBill.set("company", (Object)ncd_bankDraft.getDynamicObject("e_org"));
                eleDraftBill.set("drafttype", (Object)ncd_bankDraft.getString("e_drafttype"));
                eleDraftBill.set("preholdername", (Object)ncd_bankDraft.getString("e_delivername"));
                eleDraftBill.set("oppaccname", (Object)ncd_bankDraft.getString("e_delivername"));
                eleDraftBill.set("rptype", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                eleDraftBill.set("rptype", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                eleDraftBill.set("conectno", (Object)(null == ncd_bankDraft.getDynamicObject("e_bankaccount") ? "" : ncd_bankDraft.getDynamicObject("e_bankaccount").getString("number")));
                eleDraftBill.set("notestatus", (Object)ncd_bankDraft.getString("e_notestatus"));
                eleDraftBill.set("cirstatus", (Object)ncd_bankDraft.getString("e_cirstatus"));
                eleDraftBill.set("subrange", (Object)ncd_bankDraft.getString("e_subbillrange"));
                eleDraftBill.set("ebstatus", (Object)EbStatus.BANK_SUCCESS.getName());
                eleDraftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                eleDraftBill.set("datasource", (Object)DataSourceMethodEnum.IMPORT.getValue());
                eleDraftBill.set("initsubrange", (Object)ncd_bankDraft.getString("e_subbillrange"));
                eleDraftBill.set("grdbag", (Object)ncd_bankDraft.getBoolean("e_issplit"));
                eleDraftBill.set("locamt", (Object)BigDecimal.ZERO);
                eleDraftBill.set("settleway", (Object)"ST01");
                String delivername = ncd_bankDraft.getString("e_delivername");
                String drawername = ncd_bankDraft.getString("e_drawername");
                if (delivername.equals(drawername)) {
                    eleDraftBill.set("trantype", (Object)"03");
                } else {
                    eleDraftBill.set("trantype", (Object)"10");
                }
                eleDraftBill.set("cleartype", (Object)"CT01");
                long bankId = ncd_bankDraft.getDynamicObject("e_bankaccount").getDynamicObject("bank").getLong("id");
                String bankCate = (String)bankIdAndCateMap.get(bankId);
                eleDraftBill.set("connchannel", (Object)bankCate);
                eleDraftBill.set("isinsertpayorrec", (Object)true);
                eleDraftBill.set("draftaccount", (Object)accountBank);
                ncd_bankDraft.set("gendraftbillid", (Object)pkId);
                needUpdateBankDraftsSet.add(ncd_bankDraft);
                eleRecDraftSet.add(eleDraftBill);
            }
            if (!EmptyUtil.isNoEmpty(eleRecDraftSet) || eleRecDraftSet.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])eleRecDraftSet.toArray(new DynamicObject[0]));
            List<Long> list = eleRecDraftSet.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            RecEleBillStorageService.storage(list, data.getDynamicObject("company"));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (EmptyUtil.isNoEmpty(needUpdateBankDraftsSet) && needUpdateBankDraftsSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBankDraftsSet.toArray(new DynamicObject[0]));
        }
    }
}

