/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InventoryResultDeleteService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InventoryResultDeleteService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billno");
        selector.add("sourcebillid");
        selector.add("inventorytype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("process is start");
        HashSet<Long> needUpdateBlankInventorySet = new HashSet<Long>(16);
        HashSet<Long> needUpdateBussinesInventorySet = new HashSet<Long>(16);
        for (DynamicObject inventoryResultDy : dataEntities) {
            long sourcebillid = inventoryResultDy.getLong("sourcebillid");
            String inventorytype = inventoryResultDy.getString("inventorytype");
            if ("blank".equals(inventorytype)) {
                needUpdateBlankInventorySet.add(sourcebillid);
                continue;
            }
            needUpdateBussinesInventorySet.add(sourcebillid);
        }
        this.updateInventoryData(needUpdateBlankInventorySet, "cdm_chequeinventory");
        this.updateInventoryData(needUpdateBussinesInventorySet, "cdm_businessnventory");
    }

    private void updateInventoryData(Set<Long> needUpdateBussinesInventorySet, String inventoryType) {
        if (EmptyUtil.isNoEmpty(needUpdateBussinesInventorySet) && needUpdateBussinesInventorySet.size() > 0) {
            DynamicObject[] bussinessInventorys;
            for (DynamicObject bussinessInventory : bussinessInventorys = BusinessDataServiceHelper.load((String)inventoryType, (String)"id,draftinventoryreport,draftinventoryreportid", (QFilter[])new QFilter[]{new QFilter("id", "in", needUpdateBussinesInventorySet)})) {
                bussinessInventory.set("draftinventoryreportid", (Object)0L);
                bussinessInventory.set("draftinventoryreport", (Object)"");
                SaveServiceHelper.save((DynamicObject[])bussinessInventorys);
            }
        }
    }
}

