/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.writeback.ElcDraftBillWriteBackDraftBill;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcDraftBillBackOpService
extends AbstractTmcBizOppService {
    private List<Object> receivableBillIdList = new ArrayList<Object>(16);
    private List<Object> payableBillIdList = new ArrayList<Object>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("ticketstatus");
        sic.add("bankstatus");
        sic.add("ebstatus");
        sic.add("sourceid");
        sic.add("backflag");
        sic.add("rptype");
        sic.add("tradeoppname");
        sic.add("traderemarks");
        sic.add("interfacetype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map recBillMap = Arrays.stream(dataEntities).collect(Collectors.toMap(o -> o.get("sourceid"), Function.identity(), (k1, k2) -> k1));
        String draftType = dataEntities[0].getString("rptype");
        for (DynamicObject data : dataEntities) {
            Object sourceId = data.get("sourceid");
            if (ReceivePayTypeEnum.RECEIVEBILL.getValue().equals(draftType)) {
                this.receivableBillIdList.add(sourceId);
            } else {
                this.payableBillIdList.add(sourceId);
            }
            data.set("ebstatus", (Object)EbStatus.BANK_FAIL.getName());
            data.set("backflag", (Object)"1");
            data.set("tradeoppname", (Object)"");
            data.set("traderemarks", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (ReceivePayTypeEnum.PAYBILL.getValue().equals(draftType) && this.payableBillIdList.size() > 0) {
            DynamicObject[] payBills;
            for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((Object[])this.payableBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_payablebill"))) {
                payBill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                payBill.set("electag", (Object)"0");
                payBill.set("isrelatedprebill", (Object)"0");
                payBill.set("relatedelcbillid", (Object)0L);
            }
            SaveServiceHelper.save((DynamicObject[])payBills);
        } else if (ReceivePayTypeEnum.RECEIVEBILL.getValue().equals(draftType) && this.receivableBillIdList.size() > 0) {
            DynamicObject[] recBills;
            for (DynamicObject recBill : recBills = BusinessDataServiceHelper.load((Object[])this.receivableBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                recBill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                recBill.set("electag", (Object)"0");
                DynamicObject eleRecBill = (DynamicObject)recBillMap.get(recBill.get("id"));
                if (ObjectUtils.isEmpty((Object)eleRecBill) || !EleDraftIsNewECDS.NEW.getValue().equals(eleRecBill.getString("interfacetype"))) continue;
                recBill.set("elccirculatestatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])recBills);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        if (this.receivableBillIdList.size() > 0) {
            DynamicObject[] recBills;
            for (DynamicObject dataEntity : recBills = BusinessDataServiceHelper.load((Object[])this.receivableBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                ElcDraftBillWriteBackDraftBill.validateAndWriteBack((Long)dataEntity.getPkValue());
            }
        }
    }
}

