/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class ElcDraftBusinessRecOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcDraftBusinessRecOpService.class);
    private String opType;

    public ElcDraftBusinessRecOpService(String opType) {
        this.opType = opType;
    }

    public ElcDraftBusinessRecOpService() {
    }

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("id");
        sic.add("tradetype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        if (StringUtils.isEmpty((CharSequence)this.opType)) {
            this.opType = (String)this.getOperationVariable().get("opType");
        }
        List<Long> signInPkIds = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toList());
        this.opService(this.opType, signInPkIds);
    }

    private void opService(String operateKey, List<Long> signInPkIds) {
        OperationResult operationResult = this.getOperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.draftBillOp(operateKey, signInPkIds);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(signInPkIds.size());
        if (noteResults != null && noteResults.size() != 0) {
            for (NoteResult noteResult : noteResults) {
                if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                    successBillIdList.add(noteResult.getBillId());
                    continue;
                }
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                operateErrorInfoList.add(operateErrorInfo);
                operationResult.setAllErrorInfo(operateErrorInfoList);
            }
        }
        operationResult.setSuccessPkIds(successBillIdList);
    }
}

