/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcDraftSyncPayOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcDraftSyncPayOpService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("id");
        sic.add("ebstatus");
        sic.add("batchseqid");
        sic.add("prebatchseqid");
        sic.add("tradetype");
        sic.add("bankmsg");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> signInPkIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String ebStatus = dataEntity.getString("ebstatus");
            if (EbStatus.BANK_FAIL.getName().equals(ebStatus) && StringUtils.isNotEmpty((CharSequence)dataEntity.getString("prebatchseqid"))) {
                dataEntity.set("batchseqid", (Object)dataEntity.getString("prebatchseqid"));
                dataEntity.set("tradetype", (Object)"");
                dataEntity.set("bankmsg", (Object)"");
                dataEntity.set("ebstatus", (Object)EbStatus.EB_PROCESSING.getName());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                continue;
            }
            signInPkIds.add(dataEntity.getLong("id"));
        }
        if (signInPkIds.size() > 0) {
            this.syncDataStatus(signInPkIds);
        }
    }

    private void syncDataStatus(List<Long> signInPkIds) {
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.draftPayBillSync(signInPkIds);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(signInPkIds.size());
        if (noteResults != null && noteResults.size() != 0) {
            for (NoteResult noteResult : noteResults) {
                if (!EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue((Object)noteResult.getBillId());
                    operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                    operateErrorInfoList.add(operateErrorInfo);
                    this.operationResult.setAllErrorInfo(operateErrorInfoList);
                    continue;
                }
                successBillIdList.add(noteResult.getBillId());
            }
        }
        this.operationResult.setSuccessPkIds(successBillIdList);
    }
}

