/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcDraftSyncRecOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcDraftSyncRecOpService.class);
    private static final List<String> NOT_ROLLBACK = Arrays.asList(ElcDraftBillOpEnum.NOTEENDORSE.getValue(), ElcDraftBillOpEnum.NOTEDISCOUNT.getValue(), ElcDraftBillOpEnum.PLEDGENOTE.getValue(), ElcDraftBillOpEnum.REMOVEPLEDGE.getValue(), ElcDraftBillOpEnum.PRESENTPAYMENT.getValue(), ElcDraftBillOpEnum.NOTESIGNIN.getValue(), ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue());

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(16);
        sic.add("id");
        sic.add("ebstatus");
        sic.add("batchseqid");
        sic.add("prebatchseqid");
        sic.add("tradetype");
        sic.add("bankmsg");
        sic.add("pretradetype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> signInPkIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String ebStatus = dataEntity.getString("ebstatus");
            if (EbStatus.BANK_FAIL.getName().equals(ebStatus) && !NOT_ROLLBACK.contains(dataEntity.getString("tradetype"))) {
                dataEntity.set("batchseqid", (Object)dataEntity.getString("prebatchseqid"));
                dataEntity.set("tradetype", (Object)dataEntity.getString("pretradetype"));
                dataEntity.set("bankmsg", (Object)"");
                dataEntity.set("ebstatus", (Object)EbStatus.EB_PROCESSING.getName());
                logger.info("ElcDraftSyncRecOpService afterProcess batchseqid rollback prebatchseqid id = {}", (Object)dataEntity.getLong("id"));
                continue;
            }
            signInPkIds.add(dataEntity.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (signInPkIds.size() > 0) {
            logger.info("ElcDraftSyncRecOpService afterProcess ids = {}", (Object)((Object)signInPkIds).toString());
            this.syncDataStatus(signInPkIds);
        }
        logger.info("ElcDraftSyncRecOpService afterProcess done");
    }

    private void syncDataStatus(List<Long> signInPkIds) {
        logger.info("ElcDraftSyncRecOpService syncDataStatus do");
        try {
            IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
            List<NoteResult> noteResults = bankService.draftBillSync(signInPkIds);
            ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
            ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(signInPkIds.size());
            if (noteResults != null && noteResults.size() != 0) {
                for (NoteResult noteResult : noteResults) {
                    if (!EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setLevel(ErrorLevel.Error);
                        operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                        operateErrorInfoList.add(operateErrorInfo);
                        this.operationResult.setAllErrorInfo(operateErrorInfoList);
                        continue;
                    }
                    successBillIdList.add(noteResult.getBillId());
                }
            }
            this.operationResult.setSuccessPkIds(successBillIdList);
        }
        catch (Exception ex) {
            logger.error("ElcDraftSyncRecOpService.syncDataStatus exception\uff1a", (Throwable)ex);
            throw ex;
        }
        logger.info("ElcDraftSyncRecOpService syncDataStatus done");
    }
}

