/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElcPayDealCancelRelatedPayBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcPayDealCancelRelatedPayBillService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("tradecontractno");
        sic.add("sourcenumber");
        sic.add("sourceid");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        QFilter filter;
        Object[] payableBills;
        logger.info("ElcPayDealCancelRelatedPayBillService process is start");
        HashSet<Long> idSet = new HashSet<Long>(64);
        for (DynamicObject data2 : dynamicObjects) {
            idSet.add((Long)data2.getPkValue());
            data2.set("sourcenumber", null);
            data2.set("sourceid", (Object)0L);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        Set tradeContractNoSet = Arrays.stream(dynamicObjects).filter(data -> EmptyUtil.isNoEmpty((String)data.getString("tradecontractno"))).map(o -> o.getString("tradecontractno")).collect(Collectors.toSet());
        if (!EmptyUtil.isEmpty(tradeContractNoSet)) {
            QFilter filter2 = new QFilter("tradecontractno", "in", tradeContractNoSet);
            filter2.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.PREREGISTER.getValue()));
            filter2.and(new QFilter("sourceid", ">", (Object)0L));
            filter2.and(new QFilter("id", "not in", idSet));
            DynamicObject[] eleBills = TmcDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,sourcenumber,sourceid", (QFilter[])new QFilter[]{filter2});
            for (DynamicObject data3 : eleBills) {
                idSet.add((Long)data3.getPkValue());
                data3.set("sourcenumber", null);
                data3.set("sourceid", (Object)0L);
            }
            SaveServiceHelper.update((DynamicObject[])eleBills);
        }
        logger.info("update cdm_electronic_pay_deal success,sum:" + idSet.size() + ",idSet:" + JSON.toJSONString(idSet));
        if (idSet != null && idSet.size() > 0 && EmptyUtil.isNoEmpty((Object[])(payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,isrelatedprebill,relatedelcbillid,electag,draftbilltranstatus", (QFilter[])new QFilter[]{filter = new QFilter("relatedelcbillid", "in", (Object)idSet.toArray())})))) {
            for (Object payableBill : payableBills) {
                payableBill.set("isrelatedprebill", (Object)false);
                payableBill.set("relatedelcbillid", (Object)0L);
                payableBill.set("electag", (Object)false);
                String draftbilltranstatus = payableBill.getString("draftbilltranstatus");
                if (!DraftTranStatusEnum.HANDLEING.getValue().equals(draftbilltranstatus)) continue;
                payableBill.set("draftbilltranstatus", null);
            }
            SaveServiceHelper.update((DynamicObject[])payableBills);
            logger.info("update cdm_payablebill success,sum\uff1a" + payableBills.length);
        }
        logger.info("ElcPayDealCancelRelatedPayBillService process is end");
    }
}

