/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizTypeEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountApplInvalidService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DiscountApplInvalidService.class);
    private Set<Long> invalidDraftIdSet = new HashSet<Long>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("isinvalid");
        selector.add("amount");
        selector.add("amount");
        selector.add("bizdate");
        selector.add("discountdays");
        selector.add("rate");
        selector.add("interestday");
        selector.add("draftbill");
        selector.add("billamt");
        selector.add("currency");
        selector.add("roughlyinterest");
        selector.add("bankcharge");
        selector.add("entrys.billamt");
        selector.add("entrys.billlogid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.invalidDraftIdSet = (Set)SerializationUtils.fromJsonString((String)((String)this.getOperationVariable().get("invalidDraftId")), Set.class);
        List<DraftLockInfo> releaseInfoList = this.getReleaseInfo(dataEntities);
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
        LockDraftHelper.checkHasFail(lockResultList);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entrysColl = data.getDynamicObjectCollection("entrys");
            BigDecimal newAmount = BigDecimal.ZERO;
            for (DynamicObject entry : entrysColl) {
                long draftId = entry.getDynamicObject("draftbill").getLong("id");
                if (this.invalidDraftIdSet.contains(draftId)) {
                    entry.set("isinvalid", (Object)true);
                    continue;
                }
                if (entry.getBoolean("isinvalid")) continue;
                newAmount = newAmount.add(entry.getBigDecimal("billamt"));
            }
            data.set("amount", (Object)newAmount);
            BigDecimal newRoughlyInterest = DraftHelper.calRoughlyInterest((DynamicObject)data);
            data.set("roughlyinterest", (Object)newRoughlyInterest);
            BigDecimal newDiscAmt = DraftHelper.calDiscAmt((DynamicObject)data);
            data.set("discamt", (Object)newDiscAmt);
            DynamicObject creditlimit = data.getDynamicObject("creditlimited");
            String billstatus = data.getString("billstatus");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditlimit) || !BillStatusEnum.SUBMIT.getValue().equals(billstatus) && !BillStatusEnum.AUDIT.getValue().equals(billstatus)) continue;
            BigDecimal creditamount = data.getBigDecimal("amount");
            CreditLimitServiceHelper.updateCreditLimitUse((String)"cdm_discount_apply", (Long)data.getLong("id"), (BigDecimal)creditamount, (boolean)true);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        logger.info("afterProcess is end");
    }

    private List<DraftLockInfo> getReleaseInfo(DynamicObject[] dataEntities) {
        String tradeBillType = dataEntities[0].getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject tradebill : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = tradebill.getLong("id");
            String billno = tradebill.getString("billno");
            draftLockInfo.setBillTrade(LogBizTypeEnum.DISCOUNT.getValue());
            draftLockInfo.setSourceBillType(tradeBillType);
            draftLockInfo.setSourceBillId(tradeBillId);
            draftLockInfo.setBizBillNo(billno);
            draftLockInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
            DynamicObjectCollection entrysColl = tradebill.getDynamicObjectCollection("entrys");
            List entrys = entrysColl.stream().filter(e -> this.invalidDraftIdSet.contains(e.getDynamicObject("draftbill").getLong("id"))).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(entrys)) continue;
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                draftAmountreleaseSubInfo.setBillId(lockDraftId);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                draftAmountreleaseSubInfo.setBillTrade(LogBizTypeEnum.DISCOUNT.getValue());
                releaseSubInfoList.add(draftAmountreleaseSubInfo);
            }
            draftLockInfo.setLockSubInfoList(releaseSubInfoList);
            releaseInfoList.add(draftLockInfo);
        }
        return releaseInfoList;
    }
}

