/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountCreaditSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DiscountCreaditSubmitService.class);
    private boolean isRpcSuccess = false;

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimited");
        sic.add("company");
        sic.add("currency");
        sic.add("drafttype");
        sic.add("recbody");
        sic.add("entrys");
        sic.add("draftbill");
        sic.add("amount");
        sic.add("actualcreditamount");
        sic.add("isinvalid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("afterProcess is start");
        for (DynamicObject data : dataEntities) {
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimited"))) {
                try {
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                    List availDraftEntry = entrys.stream().filter(e -> !e.getBoolean("isinvalid")).collect(Collectors.toList());
                    if (EmptyUtil.isEmpty(availDraftEntry)) continue;
                    logger.info("start to do cfm");
                    DynamicObject creditLimit = data.getDynamicObject("creditlimited");
                    CreditLimitUseBean useBean = this.getCreditLimitUseInfo(data);
                    useBean.setPreOccupy(Boolean.valueOf(true));
                    useBean.setCreditLimitNo(creditLimit.getString("number"));
                    useBean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
                    CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
                    logger.info("do cfm end");
                }
                catch (Exception e2) {
                    logger.error("afterProcess e:", (Throwable)e2);
                }
                CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("bizdate"));
                boolean isRpcSuccess = creditLimitInfo.isSuccess();
                if (!isRpcSuccess) {
                    this.operationResult.setSuccess(false);
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
            }
            logger.info("afterProcess is end");
        }
    }

    private CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        DynamicObject draftbilltype = bill.getDynamicObject("drafttype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("recbody").getLong("id")));
            useBean.setCreditFinType("bd_finorginfo");
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            }
            useBean.setCreditVariety(draftbilltype.getString("name"));
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
        DynamicObject maxDateDy = entrys.stream().filter(e -> !e.getBoolean("isinvalid")).max(Comparator.comparing(e -> e.getDynamicObject("draftbill").getDate("draftbillexpiredate"))).get();
        useBean.setMaxAmt(bill.getBigDecimal("amount"));
        useBean.setStartDate(bill.getDate("bizdate"));
        useBean.setEndDate(maxDateDy.getDynamicObject("draftbill").getDate("draftbillexpiredate"));
        useBean.setBizAmt(bill.getBigDecimal("amount"));
        useBean.setSourceBillId(Long.valueOf(bill.getLong("id")));
        return useBean;
    }
}

