/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.opservice.payablebill.DiscountApplyBillUnAuditService;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountUnCreaditSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DiscountApplyBillUnAuditService.class);
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimited");
        sic.add("drafttype");
        sic.add("billstatus");
        sic.add("bizdate");
        sic.add("billno");
        sic.add("isinvalid");
        sic.add("entrys");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataObj : dataEntities) {
            if (!EmptyUtil.isNoEmpty((DynamicObject)dataObj.getDynamicObject("creditlimited"))) continue;
            logger.info("DiscountUnCreaditSubmitService start cancelCreditLimit");
            DynamicObjectCollection entrys = dataObj.getDynamicObjectCollection("entrys");
            List availDraftEntry = entrys.stream().filter(e -> !e.getBoolean("isinvalid")).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(availDraftEntry)) continue;
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataObj, null, (boolean)true);
            this.isRpcSuccess = creditLimitInfo.isSuccess();
            logger.info("DiscountUnCreaditSubmitService cancelCreditLimit isRpcSuccess:" + this.isRpcSuccess);
            if (this.isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
    }
}

