/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillCancelRelatedPreBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableBillCancelRelatedPreBillService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("isrelatedprebill");
        sic.add("relatedelcbillid");
        sic.add("electag");
        sic.add("eledraftstatus");
        sic.add("draftbilltranstatus");
        sic.add("contractno");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        QFilter elefilter;
        Object[] electronicPayBills;
        Set ids;
        Collection bills;
        logger.info("PayableBillCancelRelatedPreBillService process is start");
        HashMap<Long, DynamicObject> allPayBills = new HashMap<Long, DynamicObject>(8);
        ArrayList<DynamicObject> updatePaybills = new ArrayList<DynamicObject>();
        ArrayList<Object> updateElebills = new ArrayList<Object>();
        if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        Long company = dynamicObjects[0].getDynamicObject("company").getLong("id");
        HashSet<String> contractnos = new HashSet<String>(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = (Long)dynamicObject.getPkValue();
            allPayBills.put(id, dynamicObject);
            String contractno = dynamicObject.getString("contractno");
            if (!EmptyUtil.isNoEmpty((String)contractno)) continue;
            contractnos.add(contractno);
        }
        if (EmptyUtil.isNoEmpty(contractnos) && contractnos.size() > 0) {
            DynamicObject[] payableBills;
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and("company", "=", (Object)company);
            filter.and("isrelatedprebill", "=", (Object)"1");
            filter.and("contractno", "in", (Object)contractnos.toArray());
            for (DynamicObject payableBill : payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"billno,company,contractno,eledraftstatus,isrelatedprebill,relatedelcbillid,electag,draftbilltranstatus,modifier,modifytime", (QFilter[])new QFilter[]{filter})) {
                Long id = payableBill.getLong("id");
                if (allPayBills.containsKey(id)) continue;
                allPayBills.put(id, payableBill);
            }
        }
        if (EmptyUtil.isNoEmpty(bills = allPayBills.values())) {
            for (DynamicObject bill : bills) {
                bill.set("isrelatedprebill", (Object)false);
                bill.set("relatedelcbillid", (Object)0L);
                bill.set("electag", (Object)false);
                String draftbilltranstatus = bill.getString("draftbilltranstatus");
                if (DraftTranStatusEnum.HANDLEING.getValue().equals(draftbilltranstatus)) {
                    bill.set("draftbilltranstatus", null);
                }
                updatePaybills.add(bill);
            }
        }
        if (EmptyUtil.isNoEmpty(ids = allPayBills.keySet()) && EmptyUtil.isNoEmpty((Object[])(electronicPayBills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,sourceid,sourcenumber,rptype,billno", (QFilter[])new QFilter[]{elefilter = new QFilter("sourceid", "in", (Object)ids.toArray())})))) {
            for (Object electronicPayBill : electronicPayBills) {
                electronicPayBill.set("sourcenumber", null);
                electronicPayBill.set("sourceid", (Object)0L);
                updateElebills.add(electronicPayBill);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            if (EmptyUtil.isNoEmpty(updatePaybills) && updatePaybills.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updatePaybills.toArray(new DynamicObject[0]));
                logger.info("\u53d6\u6d88\u9884\u51fa\u7968\u6210\u529f\uff0c\u66f4\u65b0\u5e94\u4ed8\u7968\u636e" + updatePaybills.size() + "\u6761");
            }
            if (EmptyUtil.isNoEmpty(updateElebills) && updateElebills.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateElebills.toArray(new DynamicObject[0]));
                logger.info("\u53d6\u6d88\u9884\u51fa\u7968\u6210\u529f\uff0c\u66f4\u65b0\u7535\u7968" + updateElebills.size() + "\u6761");
            }
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u5173\u8054\u9884\u51fa\u7968\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
        logger.info("PayableBillCancelRelatedPreBillService process is end");
    }
}

