/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.surety.SuretyBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillSuretyConfigmService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillSuretyConfigmService.class);
    private static final Map<String, Map<String, String>> entityBizPropMap = new HashMap<String, Map<String, String>>(16);

    public PayableBillSuretyConfigmService() {
        HashMap<String, String> bizPropMap = new HashMap<String, String>();
        bizPropMap.put("org", "company");
        bizPropMap.put("bizno", "billno");
        bizPropMap.put("finorginfo", "drawerorg");
        bizPropMap.put("currency", "currency");
        bizPropMap.put("amount", "amounttotal");
        bizPropMap.put("suretystatus", "draftbillstatus");
        bizPropMap.put("credit", "creditlimit");
        bizPropMap.put("debtstartdate", "bizdate");
        entityBizPropMap.put("cdm_payablebill_ap_manual", bizPropMap);
        HashMap<String, String> cdmBizPropMap = new HashMap<String, String>();
        cdmBizPropMap.put("org", "company");
        cdmBizPropMap.put("bizno", "billno");
        cdmBizPropMap.put("finorginfo", "");
        cdmBizPropMap.put("currency", "currency");
        cdmBizPropMap.put("amount", "amount");
        cdmBizPropMap.put("suretystatus", "draftbillstatus");
        cdmBizPropMap.put("credit", "creditlimit");
        bizPropMap.put("debtstartdate", "bizdate");
        entityBizPropMap.put("cdm_payablebill", cdmBizPropMap);
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (int i = 0; i < dataEntities.length; ++i) {
            Long bizId = dataEntities[i].getLong("id");
            String entityName = dataEntities[0].getDataEntityType().getName();
            QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)bizId);
            qFilter.and("entry.debttype", "=", (Object)entityName);
            qFilter.and("billstatus", "=", (Object)"A");
            Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"org,billno,billstatus,enable", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isEmpty((Object[])suretyBills)) {
                DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)bizId, (String)entityName);
                this.generateSuretyBill(bizBill);
                suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"org,billno,billstatus,enable,finorginfo,currency,amount,settleaccount,intdate,term,expiredate,entry,entry.debtbillid,entry.suretysource", (QFilter[])new QFilter[]{qFilter});
                this.addEntrySurety(bizBill, (DynamicObject[])suretyBills);
            }
            for (Object suretyBill : suretyBills) {
                if (suretyBill.getBoolean("enable")) continue;
                suretyBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fbd_suretybill", (DynamicObject)suretyBill, (String)suretyBill.getDynamicObject("org").getString("id"), (String)""));
                suretyBill.set("enable", (Object)true);
            }
            TmcDataServiceHelper.save((DynamicObject[])suretyBills);
        }
    }

    private void addEntrySurety(DynamicObject payablebillApManual, DynamicObject[] suretyBills) {
        DynamicObjectCollection suretybills = payablebillApManual.getDynamicObjectCollection("entry_surety");
        for (DynamicObject sourtyBill : suretyBills) {
            DynamicObject suretybill = new DynamicObject(suretybills.getDynamicObjectType());
            suretybill.set("guaranteetype", (Object)"deposit");
            suretybill.set("suretybill", sourtyBill.getPkValue());
            suretybill.set("suretysource", (Object)this.getSuretySource((Long)payablebillApManual.getPkValue(), sourtyBill));
            suretybills.add((Object)suretybill);
        }
        payablebillApManual.set("entry_surety", (Object)suretybills);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payablebillApManual});
    }

    private void generateSuretyBill(DynamicObject srcBill) {
        String entityName = srcBill.getDataEntityType().getName();
        String bizNoProp = this.getBizPropName(entityName, "bizno");
        String orgProp = this.getBizPropName(entityName, "org");
        String creditLimitProp = this.getBizPropName(entityName, "credit");
        DynamicObjectCollection suretyEntry = srcBill.getDynamicObjectCollection("entry_surety");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) {
            SuretyBean suretyBean = this.generateDefaultSuretyBean(srcBill, bizNoProp, orgProp, creditLimitProp);
            ArrayList<SuretyBean> suretyList = new ArrayList<SuretyBean>(1);
            suretyList.add(suretyBean);
            PayableBillSuretyConfigmService.saveSurety(suretyList);
        }
    }

    public static void saveSurety(List<SuretyBean> suretyList) {
        ArrayList<DynamicObject> suretyDOList = new ArrayList<DynamicObject>(suretyList.size());
        for (SuretyBean suretyBean : suretyList) {
            if (EmptyUtil.isNoEmpty((Long)suretyBean.getSuretyBillId())) {
                DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBean.getSuretyBillId(), (String)"fbd_suretybill");
                PayableBillSuretyConfigmService.newEntry(suretyBean, suretyBill);
                suretyDOList.add(suretyBill);
                continue;
            }
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fbd_suretybill");
            newDO.set("org", (Object)suretyBean.getOrgId());
            newDO.set("finorginfo", (Object)suretyBean.getFinOrgId());
            newDO.set("settleaccount", (Object)suretyBean.getSettleAccountId());
            newDO.set("currency", (Object)suretyBean.getCurrencyId());
            newDO.set("amount", (Object)suretyBean.getAmount());
            newDO.set("intdate", (Object)suretyBean.getIntDate());
            newDO.set("term", (Object)suretyBean.getTerm());
            newDO.set("expiredate", (Object)suretyBean.getExpireDate());
            newDO.set("basis", (Object)BasisEnum.Actual_360.getValue());
            newDO.set("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
            newDO.set("bizdate", (Object)DateUtils.truncateDate((Date)new Date()));
            newDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newDO.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_ING.getValue());
            newDO.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDO.set("enable", (Object)false);
            newDO.set("demandrate", (Object)0);
            PayableBillSuretyConfigmService.newEntry(suretyBean, newDO);
            suretyDOList.add(newDO);
        }
        if (EmptyUtil.isNoEmpty(suretyDOList)) {
            logger.info("\u6d3b\u671f\u5229\u7387\u7684\u503c\u662f\uff1a{}", (Object)((DynamicObject)suretyDOList.get(0)).getString("demandrate"));
            SaveServiceHelper.save((DynamicObject[])suretyDOList.toArray(new DynamicObject[0]));
        }
    }

    private static void newEntry(SuretyBean suretyBean, DynamicObject suretyBill) {
        DynamicObjectCollection entry = suretyBill.getDynamicObjectCollection("entry");
        DynamicObject r1 = entry.addNew();
        r1.set("debttype", (Object)suretyBean.getSrcBillType());
        r1.set("debtbillno", (Object)suretyBean.getSrcBillNo());
        r1.set("bizno", (Object)suretyBean.getBizNo());
        r1.set("debtbillid", (Object)suretyBean.getSrcBillId());
        r1.set("counterparty", (Object)suretyBean.getDebtFinOrgId());
        r1.set("debtcurrency", (Object)suretyBean.getDebtCurrencyId());
        r1.set("debtamt", (Object)suretyBean.getDebtAmount());
        r1.set("debtstartdate", (Object)suretyBean.getDebtStartDate());
        r1.set("debtenddate", (Object)suretyBean.getDebtEndDate());
        r1.set("suretysource", (Object)suretyBean.getSuretySource());
        r1.set("suretystatus", (Object)suretyBean.getBizStatus());
        if (EmptyUtil.isNoEmpty((Long)suretyBean.getCreditId())) {
            r1.set("credit", (Object)suretyBean.getCreditId());
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditlimit", "=", (Object)suretyBean.getCreditId())).and(new QFilter("sourcebillno", "=", (Object)suretyBean.getSrcBillNo()));
            DynamicObject creditUse = TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"currency,realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                r1.set("creditcurrency", creditUse.getDynamicObject("currency").getPkValue());
                r1.set("creditamount", (Object)creditUse.getBigDecimal("realamt"));
                r1.set("releasecreditamt", (Object)creditUse.getBigDecimal("realamt"));
            }
        }
    }

    protected String getBizPropName(String entityName, String prop) {
        Map<String, String> bizPropMap = entityBizPropMap.get(entityName);
        return bizPropMap.get(prop);
    }

    private SuretyBean generateDefaultSuretyBean(DynamicObject srcBill, String bizNoProp, String orgProp, String creditLimitProp) {
        String startDateProp;
        DynamicObjectCollection entryentity;
        SuretyBean suretyBean = new SuretyBean();
        suretyBean.setSrcBillId(Long.valueOf(srcBill.getLong("id")));
        suretyBean.setSrcBillType(srcBill.getDataEntityType().getName());
        suretyBean.setSrcBillNo(srcBill.getString("billno"));
        suretyBean.setBizNo(srcBill.getString(bizNoProp));
        String entityName = srcBill.getDataEntityType().getName();
        String finOrgProp = this.getBizPropName(entityName, "finorginfo");
        if (EmptyUtil.isNoEmpty((String)finOrgProp) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entryentity = srcBill.getDynamicObjectCollection("entryentity"))) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)entryentity.get(0)).getDynamicObject(finOrgProp))) {
            suretyBean.setFinOrgId(Long.valueOf(((DynamicObject)entryentity.get(0)).getDynamicObject(finOrgProp).getLong("id")));
            suretyBean.setDebtFinOrgId(Long.valueOf(((DynamicObject)entryentity.get(0)).getDynamicObject(finOrgProp).getLong("id")));
        }
        String currencyProp = this.getBizPropName(entityName, "currency");
        suretyBean.setCurrencyId(Long.valueOf(srcBill.getDynamicObject(currencyProp).getLong("id")));
        suretyBean.setDebtCurrencyId(Long.valueOf(srcBill.getDynamicObject(currencyProp).getLong("id")));
        String amountProp = this.getBizPropName(entityName, "amount");
        suretyBean.setAmount(srcBill.getBigDecimal(amountProp));
        suretyBean.setDebtAmount(srcBill.getBigDecimal(amountProp));
        DynamicObject org = srcBill.getDynamicObject(orgProp);
        suretyBean.setOrgId(Long.valueOf(org.getLong("id")));
        suretyBean.setSuretySource(BillSourceEnum.HAND.getValue());
        String bizStatus = this.getActDebtBizStatus(srcBill, entityName);
        suretyBean.setBizStatus(bizStatus);
        DynamicObject creditLimit = srcBill.getDynamicObject(creditLimitProp);
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            suretyBean.setCreditId(Long.valueOf(creditLimit.getLong("id")));
        }
        if (EmptyUtil.isNoEmpty((String)(startDateProp = this.getBizPropName(entityName, "debtstartdate"))) && EmptyUtil.isNoEmpty((Object)srcBill.getDate(startDateProp))) {
            suretyBean.setDebtStartDate(srcBill.getDate(startDateProp));
        }
        return suretyBean;
    }

    public String getActDebtBizStatus(DynamicObject bizBill, String entityName) {
        String suretyStatus = "guaranting";
        if ("cdm_payablebill".equals(entityName)) {
            String draftStatus = bizBill.getString("draftbillstatus");
            if ("payoffed".equals(draftStatus) || "sendback".equals(draftStatus)) {
                suretyStatus = "settled";
            }
        } else if ("cdm_payablebill_ap_manual".equals(entityName)) {
            suretyStatus = "settled";
        }
        return suretyStatus;
    }

    private String getSuretySource(Long id, DynamicObject suretyBill) {
        DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            Long debtBillId = entry.getLong("debtbillid");
            if (!id.equals(debtBillId)) continue;
            return entry.getString("suretysource");
        }
        return BillSourceEnum.HAND.getValue();
    }
}

