/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableCancelDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableCancelDrawService.class);
    private Set<Long> needUpdateCasPaySet = new HashSet<Long>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(21);
        sic.add("draftbillno");
        sic.add("issuedate");
        sic.add("creditlimit");
        sic.add("draftbilltranstatus");
        sic.add("draftbillexpiredate");
        sic.add("sourcebillid");
        sic.add("draftbilltype");
        sic.add("draftbilltype.settlementtype");
        sic.add("draftbilltype.billmedium");
        sic.add("draftbillstatus");
        sic.add("bizdate");
        sic.add("eledraftstatus");
        sic.add("releatedcasbillentrys");
        sic.add("eledraftstatusnew");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet ids = new HashSet(10);
        ArrayList payIds = new ArrayList(10);
        for (DynamicObject data : dataEntities) {
            Map SrcMap;
            HashSet payBillIds;
            String appId;
            boolean isSucWriteBack;
            Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_payablebill", (Long[])new Long[]{data.getLong("id")});
            HashSet pkValues = (HashSet)botpMap.get("cdm_receivablebill");
            if (null != pkValues && pkValues.size() > 0) {
                ids.addAll(pkValues);
            }
            if (isSucWriteBack = ((Boolean)SystemParamServiceHelper.getAppParameter((String)(appId = AppMetadataCache.getAppInfo((String)"cdm").getId()), (String)"08", (Long)data.getLong("company.id"), (String)"issucwriteback")).booleanValue()) {
                String sourcebillid = data.getString("sourcebillid");
                String sourceStr = data.getString("source");
                long sourCasBillId = Long.parseLong(sourcebillid);
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                switch (sourceStr) {
                    case "cas": {
                        this.writePayStatus(sourcebillid);
                        billSet.add(data);
                        DraftHelper.updateDratBillCasEntry(billSet, (String)"cas_paybill", (String)"delete", (Long)sourCasBillId);
                        break;
                    }
                    case "ifm": {
                        String failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"B");
                        if (EmptyUtil.isNoEmpty((String)failErrorMsg)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
                        }
                        billSet.add(data);
                        DraftHelper.updateDratBillCasEntry(billSet, (String)"ifm_transhandlebill", (String)"delete", (Long)sourCasBillId);
                        break;
                    }
                }
            }
            String draftStatus = data.getString("draftbillstatus");
            if (DraftBillStatusEnum.PAYOFFED.getValue().equals(draftStatus) && DraftHelper.isPromissory((Object)data.getDynamicObject("draftbilltype")) && null != (payBillIds = (HashSet)(SrcMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_payablebill", (Long[])new Long[]{data.getLong("id")})).get("cas_paybill")) && payBillIds.size() > 0) {
                Iterator iterator = payBillIds.iterator();
                while (iterator.hasNext()) {
                    payIds.add(iterator.next());
                }
            }
            data.set("draftbilltranstatus", null);
            String billmedium = data.getDynamicObject("draftbilltype").getString("billmedium");
            if ("2".equals(billmedium)) {
                data.set("eledraftstatus", null);
            }
            if (DraftBillStatusEnum.PAYOFFED.getValue().equals(data.getString("draftbillstatus"))) {
                data.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            }
            data.set("eledraftstatusnew", (Object)"registering");
        }
        if (null != ids && ids.size() > 0) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cdm_receivablebill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        }
        if (null != payIds && payIds.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"cancelBook", (Object[])new Object[]{"cas_paybill", payIds});
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,matchflag", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills) && payBills.size() > 0) {
                for (DynamicObject payBill : payBills) {
                    String matchflag = payBill.getString("matchflag");
                    if (!EmptyUtil.isNoEmpty((String)matchflag) || !"0".equals(matchflag)) continue;
                    this.needUpdateCasPaySet.add(payBill.getLong("id"));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] payBills;
        super.afterProcess(dataEntities);
        logger.info("needUpdateCasPaySet size is:" + this.needUpdateCasPaySet.size());
        if (EmptyUtil.isNoEmpty(this.needUpdateCasPaySet) && (payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,matchflag", (QFilter[])new QFilter[]{new QFilter("id", "in", this.needUpdateCasPaySet)})).length > 0) {
            for (DynamicObject payBill : payBills) {
                payBill.set("matchflag", (Object)"8");
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])payBills);
            }
        }
    }

    private void writePayStatus(String sourceBillId) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] payBills;
            if (EmptyUtil.isNoEmpty((String)sourceBillId) && !"0".equals(sourceBillId) && (payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))})).length > 0) {
                long id = Long.parseLong(sourceBillId);
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(id);
                OperateOption create = OperateOption.create();
                create.setVariableValue("isfrombill", "y");
                create.setVariableValue("isfrompaydraft", "Y");
                TmcOperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])idList.toArray(), (OperateOption)create);
            }
        }
    }
}

