/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableSuretyReleaseConfigmService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableSuretyReleaseConfigmService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bizdate");
        selector.add("entryentity");
        selector.add("suretyinput");
        selector.add("sourcebillid");
        selector.add("suretymoney");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            this.dealSuretyRepay(data);
        }
        this.updateSuretyInputStatus(dataEntities);
    }

    private void writeBackPayableApplyBill(DynamicObject[] dataEntities) {
        Set sourceBillIdSet = Arrays.stream(dataEntities).map(a -> a.getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter entryIdsFilter = new QFilter("entryentity.id", "in", sourceBillIdSet);
        DynamicObject[] payableApplyBills = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,billno,entryentity,entryentity.id,entryentity.entry_suretyamount", (QFilter[])new QFilter[]{entryIdsFilter});
        ArrayList<DynamicObject> needUpdateBills = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : dataEntities) {
            long sourceBillId = data.getLong("sourcebillid");
            BigDecimal suretyMoney = data.getBigDecimal("suretymoney");
            for (DynamicObject payableApplyBill : payableApplyBills) {
                DynamicObjectCollection entrys = payableApplyBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    long entryId = entry.getLong("id");
                    BigDecimal suretyAmount = entry.getBigDecimal("entry_suretyamount");
                    if (entryId != sourceBillId || suretyAmount.compareTo(suretyMoney) == 0) continue;
                    entry.set("entry_suretyamount", (Object)suretyMoney);
                    needUpdateBills.add(payableApplyBill);
                }
            }
        }
        if (!EmptyUtil.isEmpty(needUpdateBills)) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBills.toArray(new DynamicObject[0]));
        }
    }

    private void updateSuretyInputStatus(DynamicObject[] dataEntities) {
        String entityName = dataEntities[0].getDataEntityType().getName();
        if (EmptyUtil.equals((CharSequence)entityName, (CharSequence)"cdm_payablebill_ap_manual")) {
            for (DynamicObject data : dataEntities) {
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
                entrys.stream().forEach(e -> e.set("suretyinput", (Object)false));
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        } else if (EmptyUtil.equals((CharSequence)entityName, (CharSequence)"cdm_payablebill")) {
            Set payableBillIds = Arrays.stream(dataEntities).map(a -> a.getLong("id")).collect(Collectors.toSet());
            QFilter debtBillIdFilter = new QFilter("entry.debtbillid", "in", payableBillIds);
            DynamicObject[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,entry,entry.debtbillid,entry.debttype", (QFilter[])new QFilter[]{debtBillIdFilter});
            HashSet allDebtBillIds = new HashSet(8);
            for (DynamicObject suretyBill : suretyBills) {
                DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
                Set debtBillIds = entrys.stream().map(a -> a.getLong("debtbillid")).collect(Collectors.toSet());
                allDebtBillIds.addAll(debtBillIds);
            }
            logger.info("updateSuretyInputStatus,allDebtBillIds:" + JSON.toJSONString(allDebtBillIds));
            QFilter idFilter = new QFilter("id", "in", allDebtBillIds);
            DynamicObject[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,suretyinput", (QFilter[])new QFilter[]{idFilter});
            Arrays.stream(payableBills).forEach(v -> v.set("suretyinput", (Object)false));
            SaveServiceHelper.save((DynamicObject[])payableBills);
        }
    }

    private void dealSuretyRepay(DynamicObject data) {
        logger.info("PayableSuretyReleaseConfigmService dealSuretyRepay start");
        QFilter idFilter = new QFilter("entry.debtbillid", "=", data.getPkValue());
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,amount", (QFilter[])new QFilter[]{idFilter});
        if (!EmptyUtil.isEmpty((Object[])suretyBills)) {
            OperateOption operateOption = OperateOption.create();
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
            returnDataMap.put("srcEntity", data.getDataEntityType().getName());
            returnDataMap.put("bizno", data.get("billno"));
            HashMap<String, Comparable<Date>> suretyBillMap = new HashMap<String, Comparable<Date>>();
            suretyBillMap.put("repaydate", data.getDate("bizdate"));
            suretyBillMap.put("repayamount", suretyBills[0].getBigDecimal("amount"));
            HashMap<String, HashMap<String, Comparable<Date>>> suretyMap = new HashMap<String, HashMap<String, Comparable<Date>>>(2);
            long suretyId = suretyBills[0].getLong("id");
            suretyMap.put(String.valueOf(suretyId), suretyBillMap);
            suretyBillMap.put("repaydate", data.getDate("bizdate"));
            suretyBillMap.put("repayamount", suretyBills[0].getBigDecimal("amount"));
            returnDataMap.put("valueMap", suretyMap);
            String returnData = SerializationUtils.toJsonString(returnDataMap);
            operateOption.setVariableValue("returnDataMap", returnData);
            operateOption.setVariableValue("debitId", String.valueOf(data.getPkValue()));
            operateOption.setVariableValue("debitType", data.getDataEntityType().getName());
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"suretyrepay", (String)"fbd_suretybill", (Object[])new Object[]{suretyId}, (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                throw new KDBizException(operationResult.getMessage());
            }
            logger.info("PayableSuretyReleaseConfigmService dealSuretyRepay end");
        }
    }
}

