/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FillRecNoticeBillnoService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(FillRecNoticeBillnoService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("id");
        selector.add("claimnoticebillno");
        selector.add("billstatus");
        selector.add("draftbilltranstatus");
        selector.add("rptype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("FillRecNoticeBillnoService  is start:");
        List<DynamicObject> dynamicObjectStream = Arrays.stream(dynamicObjects).filter(x -> EmptyUtil.isEmpty((String)x.getString("claimnoticebillno")) && "C".equals(x.getString("billstatus")) && "receivebill".equals(x.getString("rptype")) && "success".equals(x.getString("draftbilltranstatus"))).collect(Collectors.toList());
        Object[] receivablebills = dynamicObjectStream.toArray(new DynamicObject[0]);
        if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
            logger.info("receivablebills  size  is:" + receivablebills.length);
            ArrayList<DynamicObject> willSaveDyn = new ArrayList<DynamicObject>();
            HashSet<String> billnoSet = new HashSet<String>();
            Map<String, DynamicObject> billIdAndBillMap = Arrays.stream(receivablebills).collect(Collectors.toMap(x -> x.getPkValue().toString(), x -> x));
            QFilter qFilterSource = new QFilter("datasource", "=", (Object)"ticket");
            QFilter qFilterSourceid = new QFilter("sourceid", "in", billIdAndBillMap.keySet());
            QFilter qFilterSourceType = new QFilter("sourcetype", "=", (Object)"cdm_receivablebill");
            DynamicObjectCollection claimcenterbills = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"billno,sourceid,sourcetype,datasource", (QFilter[])new QFilter[]{qFilterSource, qFilterSourceType, qFilterSourceid});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)claimcenterbills)) {
                logger.info("claimcenterbills  size  is:" + claimcenterbills.size());
                for (DynamicObject claimcenterbill : claimcenterbills) {
                    String claimnoticebillnoStr;
                    String sourceid = claimcenterbill.getString("sourceid");
                    String billno = claimcenterbill.getString("billno");
                    DynamicObject recBill = billIdAndBillMap.get(sourceid);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)recBill) || !EmptyUtil.isEmpty((String)(claimnoticebillnoStr = recBill.getString("claimnoticebillno")))) continue;
                    recBill.set("claimnoticebillno", (Object)billno);
                    willSaveDyn.add(recBill);
                    billnoSet.add(recBill.getString("billno"));
                }
            }
            logger.info("willSaveDyn size is:" + willSaveDyn.size());
            logger.info("billnoSet is:" + SerializationUtils.toJsonString(billnoSet));
            if (EmptyUtil.isNoEmpty(willSaveDyn)) {
                TmcDataServiceHelper.save((DynamicObject[])willSaveDyn.toArray(new DynamicObject[0]));
            }
        }
    }
}

