/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ReceivableBillAuditService.class);
    Set<Long> companyIds = new HashSet<Long>(16);
    Set<String> draftIdSet = new HashSet<String>(16);
    Set<BigDecimal> amountSet = new HashSet<BigDecimal>(16);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(36);
        selector.add("id");
        selector.add("billpool");
        selector.add("bankaccount");
        selector.add("draftbilltype");
        selector.add("intopooltime");
        selector.add("draftbilltranstatus");
        selector.add("amount");
        selector.add("supperbillamount");
        selector.add("accepteraccount");
        selector.add("company");
        selector.add("draftbillno");
        selector.add("locksourcebillid");
        selector.add("locksourcebilltype");
        selector.add("isendorsepay");
        selector.add("isfromequalspilt");
        selector.add("isequalbill");
        selector.add("euqaldifferetype");
        selector.add("draftbillstatus");
        selector.add("supperbillid");
        selector.add("subbillrange");
        selector.add("sourcebillid");
        selector.add("availableamount");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject receivableBill : dynamicObjects) {
            logger.info("bill is will audit bill:" + receivableBill.getLong("id"));
            receivableBill.set("draftbilltranstatus", (Object)"success");
            BigDecimal billamount = receivableBill.getBigDecimal("supperbillamount");
            BigDecimal amount = receivableBill.getBigDecimal("amount");
            if (EmptyUtil.isEmpty((BigDecimal)billamount)) {
                receivableBill.set("supperbillamount", (Object)amount);
            }
            if (!"2".equals(receivableBill.getDynamicObject("draftbilltype").getString("billmedium"))) continue;
            this.draftIdSet.add(receivableBill.getString("draftbillno"));
            this.companyIds.add(receivableBill.getDynamicObject("company").getLong("id"));
            this.amountSet.add(receivableBill.getBigDecimal("availableamount"));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("ReceivableBillAuditService audit start:" + dataEntities.length);
        try {
            List<DynamicObject> needInPoolList;
            QFilter amountQFilter;
            QFilter draftIdQFilter;
            QFilter qFilterBillStatus;
            QFilter qFilterOrg;
            DynamicObjectCollection casPayBills;
            DataSet poolRules = QueryServiceHelper.queryDataSet((String)"ReceivableBillAuditService", (String)"cdm_intopoolrule", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).toArray(), null);
            if (poolRules == null || poolRules.isEmpty()) {
                logger.info("poolrules is null");
                return;
            }
            HashSet<Long> willNotInPoolId = new HashSet<Long>(6);
            if (EmptyUtil.isNoEmpty(this.companyIds) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(casPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"billno,cas_draftinfo.draftbillinfo,cas_draftinfo.draftbillinfo.draftbillno,cas_draftinfo.transamount,cas_draftinfo.draftbillinfo.rptype,id,org", (QFilter[])new QFilter[]{qFilterOrg = new QFilter("org", "in", this.companyIds), qFilterBillStatus = new QFilter("billstatus", "=", (Object)"J"), draftIdQFilter = new QFilter("cas_draftinfo.draftbillinfo.draftbillno", "in", this.draftIdSet), amountQFilter = new QFilter("cas_draftinfo.transamount", "in", this.amountSet)})))) {
                HashMap billnoAndOrgIdAndAmountMap = new HashMap(16);
                for (DynamicObject casPayBill : casPayBills) {
                    HashSet<BigDecimal> bigDecimalsNew;
                    String draftBillno = casPayBill.getString("cas_draftinfo.draftbillinfo.draftbillno");
                    BigDecimal transamount = casPayBill.getBigDecimal("cas_draftinfo.transamount");
                    long orgId = casPayBill.getLong("org");
                    Map longSetMap = (Map)billnoAndOrgIdAndAmountMap.get(draftBillno);
                    if (EmptyUtil.isNoEmpty((Object)longSetMap) && longSetMap.size() > 0) {
                        Set bigDecimals = (Set)longSetMap.get(orgId);
                        if (EmptyUtil.isNoEmpty((Object)bigDecimals)) {
                            bigDecimals.add(transamount);
                            continue;
                        }
                        bigDecimalsNew = new HashSet(1);
                        bigDecimalsNew.add(transamount);
                        longSetMap.put(orgId, bigDecimalsNew);
                        continue;
                    }
                    HashMap longSetMapNew = new HashMap(1);
                    bigDecimalsNew = new HashSet<BigDecimal>(1);
                    bigDecimalsNew.add(transamount);
                    longSetMapNew.put(orgId, bigDecimalsNew);
                    billnoAndOrgIdAndAmountMap.put(draftBillno, longSetMapNew);
                }
                for (DynamicObject data : dataEntities) {
                    Set bigDecimals;
                    String billNo = data.getString("draftbillno");
                    long companyId = data.getLong("company");
                    BigDecimal availableamount = data.getBigDecimal("availableamount");
                    Map longSetMap = (Map)billnoAndOrgIdAndAmountMap.get(billNo);
                    if (!EmptyUtil.isNoEmpty((Object)longSetMap) || longSetMap.size() <= 0 || !EmptyUtil.isNoEmpty((Object)(bigDecimals = (Set)longSetMap.get(companyId))) || !bigDecimals.contains(availableamount)) continue;
                    willNotInPoolId.add(data.getLong("id"));
                }
            }
            if (EmptyUtil.isNoEmpty(needInPoolList = Arrays.stream(dataEntities).filter(x -> !willNotInPoolId.contains(x.getLong("id"))).collect(Collectors.toList()))) {
                logger.info("intopool start needInPoolList.size = {},billNos = {}" + needInPoolList.size(), (Object)Arrays.toString(needInPoolList.stream().map(o -> o.getString("draftbillno")).toArray()));
                TmcOperateServiceHelper.execOperate((String)"intopool", (String)"cdm_receivablebill", (DynamicObject[])needInPoolList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                logger.info("intopool end,to save bills");
            } else {
                logger.info("not to intopool");
            }
            logger.info("start  to GenEleBIlls");
        }
        catch (Exception e) {
            logger.error("intopool has exception:", (Throwable)e);
        }
    }

    private DynamicObject getCorrectPayBill(String draftBillNo, DynamicObject[] casPayBills) {
        int n = 0;
        DynamicObject[] dynamicObjectArray = casPayBills;
        int n2 = dynamicObjectArray.length;
        if (n < n2) {
            DynamicObject casPayBill = dynamicObjectArray[n];
            DynamicObjectCollection draftBills = casPayBill.getDynamicObjectCollection("draftbill");
            long matchCounts = draftBills.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("fbasedataid")) && draftBillNo.equals(o.getDynamicObject("fbasedataid").getString("draftbillno")) && "receivebill".equals(o.getDynamicObject("fbasedataid").getString("rptype"))).count();
            if (matchCounts > 0L) {
                return casPayBill;
            }
            return null;
        }
        return null;
    }
}

