/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillAuditService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetype");
        selector.add("beendorsor");
        selector.add("description");
        selector.add("oldstatus");
        selector.add("company");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("amount");
        selector.add("exchangerate");
        selector.add("locamt");
        selector.add("billno");
        selector.add("createtime");
        selector.add("allocbillentryid");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("deposit");
        selector.add("isgenbysplit");
        selector.add("allbillsamount");
        selector.add("billamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        logger.info("afterProcess is start");
        String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
        boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
        if (autoAllocation) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            boolean isEqualdiffere;
            TradeBillAmountHelper.setAllBillAmount((DynamicObject)dataEntity);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entrys");
            Object[] pkValues = dynamicObjectCollection.stream().map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
            DynamicObject[] draftBill = TmcDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            long draftBillCounts = Arrays.stream(draftBill).filter(o -> o.getDynamicObject("draftbilltype").getString("billmedium").equals("1")).count();
            DynamicObject company = dataEntity.getDynamicObject("company");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean isElectronicBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)company.getLong("id"), (String)"iselectronicbill");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            String tradetype = dataEntity.getString("tradetype");
            boolean isAllowmodifydate = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)company.getLong("id"), (String)"isallowmodifydate");
            if (isAllowmodifydate && "endorse".equals(tradetype)) {
                return;
            }
            if ("refund".equals(tradetype)) {
                isElectronicBill = false;
            }
            logger.info("isElectronicBill is :" + isElectronicBill + ",draftBillCounts is :" + draftBillCounts);
            boolean isSameCounts = draftBillCounts == (long)dynamicObjectCollection.size();
            boolean bl = isEqualdiffere = "billsplit".equals(tradetype) && dataEntity.getBoolean("isgenbysplit");
            if (isElectronicBill && !isSameCounts && !isEqualdiffere) continue;
            this.callDrawSave(dataEntity, option);
        }
    }

    private void callDrawSave(DynamicObject dataEntity, OperateOption option) {
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"drawbillsave", (String)"cdm_drafttradebill", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
        if (!opResult.isSuccess()) {
            String errorStr = this.getErrorStr(opResult);
            throw new KDBizException(errorStr);
        }
    }

    private String getErrorStr(OperationResult opResult) {
        StringJoiner errorStr = new StringJoiner("\r\n");
        try {
            errorStr.add(opResult.getMessage());
            ValidateResultCollection validateResult = opResult.getValidateResult();
            if (EmptyUtil.isNoEmpty((Object)validateResult)) {
                List validateErrors = validateResult.getValidateErrors();
                for (ValidateResult validateError : validateErrors) {
                    List allErrorInfos = validateError.getAllErrorInfo();
                    for (OperateErrorInfo allErrorInfo : allErrorInfos) {
                        errorStr.add(allErrorInfo.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("getErrorStr has error:", (Throwable)e);
        }
        return errorStr.toString();
    }
}

