/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillRejectRefundService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillRejectRefundService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isrejectrefund");
        selector.add("electag");
        selector.add("isrejectrefundgen");
        selector.add("isrepay");
        selector.add("entrys");
        selector.add("entrys.draftbill");
        selector.add("draftbilltranstatus");
        selector.add("transtatus");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillRejectRefundService process start.");
        List idList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_drafttradebill", (String)"rejectRefund");
        ArrayList errors = new ArrayList();
        List requestIds = MutexServiceHelper.getRequestResultList(idList, errors, (Map)request);
        Map<Object, String> idAndBillNoMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getString("billno"), (m1, m2) -> m1));
        try {
            if (idList.size() != requestIds.size()) {
                ArrayList errorBillNos = new ArrayList(10);
                errors.forEach(error -> {
                    String billNo = idAndBillNoMap.getOrDefault(Long.parseLong(error.getPkValue().toString()), "");
                    errorBillNos.add(billNo);
                });
                throw new KDBizException(ResManager.loadKDString((String)"\u62d2\u6536\u9000\u7968\u64cd\u4f5c\u7533\u8bf7\u9501\u5931\u8d25\uff0c\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u7f16\u53f7\uff1a{0}", (String)"TradeBillRejectRefundService_0", (String)"tmc-cdm-business", (Object[])new Object[]{errorBillNos}));
            }
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entrys");
                if (!TradeBillHelper.canRepayOrRejectRefundCallTradeBillDraw((DynamicObjectCollection)entries)) continue;
                dataEntity.set("electag", (Object)true);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("rejectRefund", "true");
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"drawbillsave", (String)"cdm_drafttradebill", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
                if (opResult.isSuccess()) continue;
                throw new KDBizException(opResult.getMessage());
            }
            logger.info("TradeBillRejectRefundService process end.");
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u5355\u62d2\u6536\u9000\u7968\u64cd\u4f5c\u5f02\u5e38\u3002", (Throwable)e);
            if (e instanceof KDBizException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u62d2\u6536\u9000\u7968\u64cd\u4f5c\u5f02\u5e38\uff0c\u539f\u56e0\uff1a{0}", (String)"TradeBillRejectRefundService_1", (String)"tmc-cdm-business", (Object[])new Object[]{e.getMessage()}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u62d2\u6536\u9000\u7968\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"TradeBillRejectRefundService_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            MutexServiceHelper.batchRelease((List)requestIds, (String)"cdm_drafttradebill", (String)"rejectRefund");
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillRejectRefundService afterProcess start.");
        for (DynamicObject dataEntity : dataEntities) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("rejectRefund", "true");
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"pushrefunddrafttradebill", (String)"cdm_drafttradebill", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
            if (result.isSuccess()) {
                dataEntity.set("isrejectrefund", (Object)"1");
                Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])new Long[]{dataEntity.getLong("id")});
                HashSet pkValues = (HashSet)botpMap.get("cdm_drafttradebill");
                if (null != pkValues && pkValues.size() > 0) {
                    DynamicObject[] targetBills;
                    Object[] targetBillIds = pkValues.toArray();
                    for (DynamicObject targetBill : targetBills = TmcDataServiceHelper.load((Object[])targetBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"))) {
                        targetBill.set("isrejectrefundgen", (Object)"1");
                        DynamicObjectCollection dynamicObjectCollection = targetBill.getDynamicObjectCollection("entrys");
                        for (DynamicObject failedEntry : dynamicObjectCollection) {
                            DynamicObject failedReceiveDraftF7 = failedEntry.getDynamicObject("draftbill");
                            DynamicObject failedReceiveDraft = TmcDataServiceHelper.loadSingle((Object)failedReceiveDraftF7.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
                            failedReceiveDraft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                            failedReceiveDraft.set("electag", (Object)"0");
                            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{failedReceiveDraft});
                        }
                    }
                    DynamicObjectCollection sourceBillEntries = dataEntity.getDynamicObjectCollection("entrys");
                    sourceBillEntries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill"))).filter(TradeBillHelper::canRepayOrRejectRefundDraftEntry).forEach(e -> e.set("entryisrejectrefund", (Object)true));
                    TmcDataServiceHelper.save((DynamicObject[])targetBills);
                }
            }
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
        logger.info("TradeBillRejectRefundService afterProcess end.");
    }
}

