/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class TradeBillSyncEbStatusService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillSyncEbStatusService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftbilltranstatus");
        selector.add("electag");
        selector.add("entrys");
        selector.add("electag");
        selector.add("billno");
        selector.add("entrys.draftbill");
        selector.add("entrys.transtatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillSyncEbStatusService.afterProcess do");
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject company;
            List<Object> electBillIds;
            DynamicObject[] eleRecBills;
            DynamicObjectCollection subDynamicObject = dataEntity.getDynamicObjectCollection("entrys");
            Object[] recBillIds = subDynamicObject.stream().filter(e -> !"success".equals(e.getString("transtatus")) && !"failing".equals(e.getString("transtatus"))).map(e -> e.getDynamicObject("draftbill").getLong("id")).toArray();
            if (recBillIds.length == 0) {
                recBillIds = subDynamicObject.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).toArray();
                eleRecBills = BusinessDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,company", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", (Object)recBillIds)});
                electBillIds = Collections.singletonList(eleRecBills[0].getLong("id"));
                company = eleRecBills[0].getDynamicObject("company");
                RecEleBillStorageService.storage(electBillIds, company);
                logger.info("TradeBillSyncEbStatusService.afterProcess filter draftBill conditions one:recBillIds.length == 0,eleRecBills = {}", electBillIds);
            } else {
                eleRecBills = BusinessDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,company,ebstatus", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", (Object)recBillIds)});
                electBillIds = Arrays.stream(eleRecBills).filter(o -> !"BANK_SUCCESS".equals(o.getString("ebstatus")) && !"BANK_FAIL".equals(o.getString("ebstatus"))).map(o -> o.getLong("id")).collect(Collectors.toList());
                if (electBillIds.size() > 0) {
                    logger.info("TradeBillSyncEbStatusService.afterProcess filter draftBill conditions two:electBillIds.size() > 0,eleRecBills = {}", electBillIds);
                    this.syncEleRecEbStatus(electBillIds);
                } else {
                    electBillIds = Arrays.stream(eleRecBills).map(o -> o.getLong("id")).collect(Collectors.toList());
                    company = eleRecBills[0].getDynamicObject("company");
                    RecEleBillStorageService.storage(electBillIds, company);
                    logger.info("TradeBillSyncEbStatusService.afterProcess filter draftBill conditions three:electBillIds.size() == 0,eleRecBills = {}", electBillIds);
                }
            }
            logger.info("TradeBillSyncEbStatusService.afterProcess filter draftBill sourceBillId final is {},draftTradeBillNo = {}", electBillIds, (Object)dataEntity.getString("billno"));
        }
        logger.info("TradeBillSyncEbStatusService .afterProcess done");
    }

    private void syncEleRecEbStatus(List<Long> eleBillPkIds) {
        logger.info("TradeBillSyncEbStatusService.syncEleRecEbStatus do");
        try {
            IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
            List<NoteResult> noteResults = bankService.draftBillSync(eleBillPkIds);
            ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
            ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(eleBillPkIds.size());
            if (noteResults != null && noteResults.size() != 0) {
                for (NoteResult noteResult : noteResults) {
                    if (!EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setLevel(ErrorLevel.Error);
                        operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                        operateErrorInfoList.add(operateErrorInfo);
                        this.operationResult.setAllErrorInfo(operateErrorInfoList);
                        continue;
                    }
                    successBillIdList.add(noteResult.getBillId());
                }
            }
            this.operationResult.setSuccessPkIds(successBillIdList);
        }
        catch (Exception ex) {
            logger.error("TradeBillSyncEbStatusService.syncEleRecEbStatus exception\uff1a", (Throwable)ex);
            throw ex;
        }
        logger.info("TradeBillSyncEbStatusService.syncEleRecEbStatus done");
    }
}

