/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.business.opservice.tradebill.TradeBillAuditService;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class TradeDrawPayoffService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillAuditService.class);
    public static final String PUSHPAYBILL = "pushpaybill";
    public static final String PUSHRECBILL = "pushrecbill";
    public static final String PUSHANDSAVERECBILL = "pushandsaverecbill";
    public static final String PUSHPLEDGE = "pushpledge";
    public static final String DEPOSITPUSH = "depositpush";
    public static final String PAYINTERESTPUSH = "payinterestpush";
    public static final String SPLITPUSHRECBILL = "splitpushrecbill";
    public static final String SPLITPUSHPAYCBILL = "splitpushpaycbill";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetype");
        selector.add("beendorsor");
        selector.add("description");
        selector.add("oldstatus");
        selector.add("company");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("amount");
        selector.add("exchangerate");
        selector.add("locamt");
        selector.add("billno");
        selector.add("createtime");
        selector.add("allocbillentryid");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("deposit");
        selector.add("depositamount");
        selector.add("transtatus");
        selector.add("electag");
        selector.add("draftbilltranstatus");
        selector.add("draftcount");
        selector.add("amount");
        selector.add("discamt");
        selector.add("discount_interest");
        selector.add("roughly_interest");
        selector.add("collection");
        selector.add("electag");
        selector.add("transtatus");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("interestday");
        selector.add("discount_days");
        selector.add("rate");
        selector.add("sourcebilltype");
        selector.add("isrepay");
        selector.add("isrejectrefundgen");
        selector.add("poundage");
        selector.add("refunddesc");
        selector.add("pledgeenddate");
        selector.add("rptype");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("bizfinishdate");
        selector.add("iseditdiscountentry");
        selector.add("discountentry");
        selector.add("depositentry");
        selector.add("depositentry.dpbillno");
        selector.add("depositentry.dpdeductamount");
        selector.add("depositentry.dpbillnos_tag");
        selector.add("depositentry.dpbillnos");
        selector.add("depositentry.revenueway");
        selector.add("billno");
        selector.add("isrejectrefund");
        selector.add("bizdate");
        selector.add("isrepaygen");
        selector.add("billamt");
        selector.add("agreerate");
        selector.add("alldiscountinterest");
        selector.add("owndiscountinterest");
        selector.add("agreepayertype");
        selector.add("payerofinterest");
        selector.add("payerofinterestname");
        selector.add("payinterbankaccount");
        selector.add("payinteropenbank");
        selector.add("payinterestamount");
        selector.add("dis_payinterestamount");
        selector.add("payinteramount_bank");
        selector.add("payerofinteresttype");
        selector.add("dis_owninterest_bank");
        selector.add("dis_payinterest_bank");
        selector.add("dis_subamount");
        selector.add("isgenbysplit");
        selector.add("euqaldifferetype");
        selector.add("isneedsplit");
        selector.add("billoldelestatus");
        selector.add("equalamount");
        selector.add("ispaybyagree");
        selector.add("billlogid");
        selector.add("pledgeetype");
        selector.add("pledgeetext");
        selector.add("pledgeebase");
        selector.add("isequalsplit");
        selector.add("subentrys");
        selector.add("e_subbillamount");
        selector.add("isnotneedgen");
        selector.add("pledgeeaccounttext");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeetypebase");
        selector.add("isrejectrefundgen");
        selector.add("deducttype");
        selector.add("depositentry.dinterestamount");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        selector.add("entrys.draftbillstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeDrawPayoffService is start :" + dataEntities[0].getString("billno"));
        ArrayList pushdataEmtities = new ArrayList();
        ArrayList<Object> depositPushList = new ArrayList<Object>();
        for (DynamicObject data : dataEntities) {
            TradeBillHelper.fillPushData(pushdataEmtities, (DynamicObject)data);
            String tradeType = data.getString("tradetype");
            if (!DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType) || !data.getBoolean("deposit")) continue;
            depositPushList.add(data.getPkValue());
        }
        logger.info("pushdataEmtities size is:" + pushdataEmtities.size());
        this.pushCasBill(pushdataEmtities.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty(depositPushList)) {
            this.depositPushPayBill(depositPushList);
        }
        logger.info("TradeDrawPayoffService is end!");
    }

    private void depositPushPayBill(List<Object> depositPushList) {
        OperateOption operateOption = this.getOperateOption();
        operateOption.setVariableValue("deposit", String.valueOf(Boolean.TRUE));
        TradeBillHelper.pushCasBill((String)DEPOSITPUSH, (Object[])depositPushList.toArray(), (OperateOption)operateOption, (String)"cas_paybill");
    }

    private void pushCasBill(DynamicObject[] dataEntities) {
        List pushPayingBillList = Arrays.stream(dataEntities).filter(e -> DraftTradeTypeEnum.PAYOFF.getValue().equals(e.getString("tradetype"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pushPayingBillList)) {
            Iterator iterators = pushPayingBillList.iterator();
            while (iterators.hasNext()) {
                DynamicObject ite = (DynamicObject)iterators.next();
                DynamicObject company = ite.getDynamicObject("company");
                if (company == null || !DraftHelper.getCdmParameterBoolean((long)company.getLong("id"), (String)"ispushpay") || !this.checkFromCas(ite)) continue;
                String settlementtype = ite.getDynamicObject("drafttype").getString("settlementtype");
                if (!StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)settlementtype)) continue;
                iterators.remove();
            }
            pushPayingBillList.removeIf(bill -> Objects.equals(bill.getString("tradetype"), DraftTradeTypeEnum.PAYOFF.getValue()) && bill.getBigDecimal("depositamount").add(bill.getBigDecimal("deductamount")).compareTo(bill.getBigDecimal("amount")) == 0);
            if (!CollectionUtils.isEmpty(pushPayingBillList)) {
                TradeBillHelper.pushCasBill((String)PUSHPAYBILL, (Object[])pushPayingBillList.stream().map(DataEntityBase::getPkValue).toArray(), (OperateOption)this.getOperateOption(), (String)"cas_paybill");
            }
        }
    }

    private OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("tradetype", DraftTradeTypeEnum.PAYOFF.getValue());
        return operateOption;
    }

    private boolean checkFromCas(DynamicObject info) {
        DynamicObject entry;
        DynamicObject draftBill;
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entrys");
        if (entrys != null && entrys.size() == 1 && (draftBill = (entry = (DynamicObject)entrys.get(0)).getDynamicObject("draftbill")) != null) {
            Long draftId = draftBill.getLong("id");
            if ("cas".equals(draftBill.getString("source")) || LockDraftHelper.draftIsQuoteCas(draftId).booleanValue()) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

