/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.actions.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.business.pool.actions.impl.AbstractTransferAction;
import kd.tmc.cdm.business.pool.state.TransferStateEnums;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.TransBillOpStatusEnum;
import kd.tmc.cdm.common.helper.BankAccountHelper;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.RecEleDraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EndorseCreateAction
extends AbstractTransferAction {
    private static final Log logger = LogFactory.getLog(EndorseCreateAction.class);

    @Override
    public boolean validate() {
        boolean validate = super.validate();
        if (!validate) {
            logger.info("EndorseCreateAction validate is false");
            return false;
        }
        DynamicObject transferBill = this.context.getTransferBill();
        DynamicObject transferEntry = this.context.getTransferEntry();
        DynamicObject draftBill = transferEntry.getDynamicObject("e_draftbill");
        if (this.isSubmitEle()) {
            DynamicObject bankAccount = draftBill.getDynamicObject("bankaccount");
            if (Objects.isNull(bankAccount)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u4ecb\u8d28\u4e3a\u7535\u7968\u65f6\uff0c\u94f6\u884c\u8d26\u6237\u4e3a\u5fc5\u586b\u9879\u3002", (String)"EndorseCreateAction_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            boolean judgeOfEleOrPaperBill = RecEleDraftHelper.judgeOfEleOrPaperBill((DynamicObject)transferBill, (DynamicObject)draftBill);
            Long resourceId = transferBill.getLong("sourcebillid");
            logger.info("judgeOfEleOrPaperBill is:" + judgeOfEleOrPaperBill);
            String dispatchrule = transferBill.getString("dispatchrule");
            boolean isDirect = Objects.equals(dispatchrule, DispatchRuleEnum.DIRECT.getValue());
            if (judgeOfEleOrPaperBill && EmptyUtil.isNoEmpty((Long)resourceId) && !isDirect) {
                DynamicObject bankAccountDy = TmcDataServiceHelper.loadSingle((Object)bankAccount.getPkValue(), (String)"bd_accountbanks");
                this.getCreatePoolOrg(transferBill, bankAccountDy);
            }
        }
        return true;
    }

    private void getCreatePoolOrg(DynamicObject transferBill, DynamicObject bankAccount) {
        DynamicObject createPoolOrg = transferBill.getDynamicObject("company");
        long bankId = bankAccount.getDynamicObject("bank").getDynamicObject("bank_cate").getLong("id");
        QFilter billBankIdIdFilter = new QFilter("defaultaccount", "=", (Object)bankId);
        QFilter createOrgIdFilter = new QFilter("company", "=", createPoolOrg.getPkValue());
        Object[] eleDirectSetListByBank = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{createOrgIdFilter, billBankIdIdFilter});
        if (EmptyUtil.isEmpty((Object[])eleDirectSetListByBank)) {
            Object[] eleDirectSetListByCreateOrg = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount,istransbank", (QFilter[])new QFilter[]{createOrgIdFilter});
            if (EmptyUtil.isNoEmpty((Object[])eleDirectSetListByCreateOrg)) {
                List istransbankList = Arrays.stream(eleDirectSetListByCreateOrg).filter(x -> x.getBoolean("istransbank")).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(istransbankList)) {
                    transferBill.set("createpoolaccount", (Object)((DynamicObject)istransbankList.get(0)).getDynamicObject("defaultaccount"));
                } else {
                    transferBill.set("createpoolaccount", (Object)eleDirectSetListByCreateOrg[0].getDynamicObject("defaultaccount"));
                }
            }
        } else {
            transferBill.set("createpoolaccount", (Object)eleDirectSetListByBank[0].getDynamicObject("defaultaccount"));
        }
    }

    @Override
    protected boolean doExecute() {
        DynamicObject inAccount;
        DynamicObject transferBill = this.context.getTransferBill();
        DynamicObject transferEntry = this.context.getTransferEntry();
        logger.info("EndorseCreateAction doExecute start that\u3002");
        DynamicObject[] tradeBills = null;
        boolean isFromReFail = false;
        try {
            String e_opbilltsteps = transferEntry.getString("e_opbilltsteps");
            String e_transoptionstatus = transferEntry.getString("e_transoptionstatus");
            if (TransBillOpStatusEnum.FAIL.getValue().equals(e_transoptionstatus)) {
                QFilter qFilters = new QFilter("sourcebilltype", "=", (Object)"cdm_draftallocation").and(new QFilter("allocbillentryid", "=", transferEntry.getPkValue())).and(new QFilter("sourcebillid", "=", (Object)transferBill.getLong("id")));
                switch (e_opbilltsteps) {
                    case "endorseup_create": {
                        qFilters.and(new QFilter("beendorsor", "=", (Object)transferBill.getDynamicObject("billpool").getDynamicObject("company")));
                        break;
                    }
                    case "endorsedown_create": 
                    case "endorse_create": {
                        qFilters.and(new QFilter("beendorsor", "=", transferBill.get("incompany")));
                    }
                }
                DynamicObjectCollection tradeBillArr = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilters});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)tradeBillArr)) {
                    logger.info("EndorseCreateAction doExecute tradeBillArr is not null\u3002" + ((DynamicObject)tradeBillArr.get(0)).getLong("id"));
                    long teadeBillId = ((DynamicObject)tradeBillArr.get(0)).getLong("id");
                    tradeBills = BusinessDataServiceHelper.load((Object[])new Object[]{teadeBillId}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
                    isFromReFail = true;
                }
            }
            if (EmptyUtil.isEmpty(tradeBills)) {
                logger.info("EndorseCreateAction doExecute tradeBillArr is null\u3002");
                HashMap<String, String> tCustomParam = new HashMap<String, String>();
                tCustomParam.put("autoallocation", "true");
                tradeBills = BotpHelper.push((DynamicObject)transferBill, (String)"cdm_drafttradebill", tCustomParam);
                isFromReFail = false;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u62e8\u5355\u4e0b\u63a8\u4e1a\u52a1\u5904\u7406\u5355\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
        if (tradeBills == null || tradeBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u6c60\u8c03\u5ea6\u5355\u4e0b\u63a8\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e3a\u7a7a\u3002", (String)"EndorseCreateAction_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        List tradeBillList = Arrays.stream(tradeBills).collect(Collectors.toList());
        TransferStateEnums currState = this.context.getCurrState();
        tradeBillList.removeIf(tb -> !Objects.equals(tb.getLong("sourcebillentryid"), transferEntry.getPkValue()));
        DynamicObject createPoolCompany = transferBill.getDynamicObject("billpool").getDynamicObject("company");
        if (tradeBillList.isEmpty()) {
            logger.info("tradeBillList \u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u6c60\u8c03\u5ea6\u5355\u4e0b\u63a8\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e3a\u7a7a\u3002", (String)"EndorseCreateAction_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        String dispatchRule = transferBill.getString("dispatchrule");
        DynamicObject tradeBill = (DynamicObject)tradeBillList.get(0);
        logger.info("tradeBill is:" + tradeBill.getLong("id"));
        if (currState == TransferStateEnums.ENDORSEUP_CREATE) {
            tradeBill.set("beendorsor", (Object)createPoolCompany);
            if (Objects.equals(dispatchRule, DispatchRuleEnum.INDIRECT.getValue())) {
                DynamicObject createAccount = transferBill.getDynamicObject("createpoolaccount");
                this.setBankAcctByAm(tradeBill, createAccount);
            }
        } else if (currState == TransferStateEnums.ENDORSEDOWN_CREATE) {
            tradeBill.set("beendorsor", transferBill.get("incompany"));
            if (Objects.equals(dispatchRule, DispatchRuleEnum.INDIRECT.getValue())) {
                inAccount = transferBill.getDynamicObject("inaccount");
                this.setBankAcctByAm(tradeBill, inAccount);
            }
        } else if (currState == TransferStateEnums.ENDORSE_CREATE) {
            tradeBill.set("beendorsor", transferBill.get("incompany"));
            if (Objects.equals(dispatchRule, DispatchRuleEnum.DIRECT.getValue())) {
                inAccount = transferBill.getDynamicObject("inaccount");
                this.setBankAcctByAm(tradeBill, inAccount);
            }
        }
        DynamicObject draftBill = ((DynamicObject)tradeBill.getDynamicObjectCollection("entrys").get(0)).getDynamicObject("draftbill");
        tradeBill.set("company", draftBill.get("company"));
        String bankAcctStr = tradeBill.getString("bankacct");
        if (this.isCloseSubmEle(draftBill) && EmptyUtil.isEmpty((String)bankAcctStr)) {
            this.setBankAccountInfo(tradeBill, draftBill);
        }
        this.setOppAccName(tradeBill);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("autoallocation", "true");
        OperationResult result = null;
        try {
            logger.info("isFromReFail is:" + isFromReFail);
            if (isFromReFail) {
                String billstatus;
                DynamicObject tradeBillDy = (DynamicObject)tradeBillList.get(0);
                switch (billstatus = tradeBillDy.getString("billstatus")) {
                    case "save": {
                        result = this.doOperate("submit", "cdm_drafttradebill", new DynamicObject[]{tradeBillDy}, operateOption);
                        if (!result.isSuccess()) break;
                        DynamicObject[] submitDys = BusinessDataServiceHelper.load((Object[])result.getSuccessPkIds().stream().map(o -> Long.parseLong(o.toString())).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
                        result = this.doOperate("audit", "cdm_drafttradebill", submitDys, operateOption);
                        break;
                    }
                    case "submit": {
                        result = this.doOperate("audit", "cdm_drafttradebill", new DynamicObject[]{tradeBillDy}, operateOption);
                    }
                }
            } else {
                DynamicObject[] saveDys;
                result = this.doOperate("save", "cdm_drafttradebill", new DynamicObject[]{(DynamicObject)tradeBillList.get(0)}, operateOption);
                if (result.isSuccess() && (result = this.doOperate("submit", "cdm_drafttradebill", saveDys = BusinessDataServiceHelper.load((Object[])result.getSuccessPkIds().stream().map(o -> Long.parseLong(o.toString())).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill")), operateOption)).isSuccess()) {
                    DynamicObject[] submitDys = BusinessDataServiceHelper.load((Object[])result.getSuccessPkIds().stream().map(o -> Long.parseLong(o.toString())).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
                    result = this.doOperate("audit", "cdm_drafttradebill", submitDys, operateOption);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u5355\u521b\u5efa\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
        if (result != null && !result.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result));
        }
        return true;
    }

    private void setBankAccountInfo(DynamicObject draftTrade, DynamicObject draftbill) {
        DynamicObject beendorsor = draftTrade.getDynamicObject("beendorsor");
        QFilter companyFilter = new QFilter("company", "=", beendorsor.getPkValue());
        DynamicObject sourceRecBill = BusinessDataServiceHelper.loadSingle((Object)draftbill.getPkValue(), (String)"cdm_receivablebill");
        DynamicObject bankAcc = sourceRecBill.getDynamicObject("bankaccount");
        DynamicObject bankDny = bankAcc.getDynamicObject("bank");
        DynamicObjectCollection bdfinorginfo = QueryServiceHelper.query((String)"bd_finorginfo", (String)"bebank,union_number,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "=", bankDny.getPkValue())});
        long bank_cate = ((DynamicObject)bdfinorginfo.get(0)).getLong("bank_cate");
        QFilter channelFilter = new QFilter("directconnchannel", "=", (Object)bank_cate);
        DynamicObject[] eleDirConSets = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{companyFilter, channelFilter});
        logger.info("eleDirConSets.length is:" + eleDirConSets.length);
        if (eleDirConSets.length > 0) {
            logger.info("setBankAcct by bank_cate and company of electicdirconset:");
            this.setBankAcct(draftTrade, eleDirConSets[0]);
        } else {
            DynamicObject[] eleDirConSetsByCompany = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{companyFilter});
            logger.info("eleDirConSets.length is:" + eleDirConSetsByCompany.length);
            if (eleDirConSetsByCompany.length > 0) {
                logger.info("setBankAcct by company of electicdirconset:");
                this.setBankAcct(draftTrade, eleDirConSetsByCompany[0]);
            } else {
                QFilter companyIdFilter = new QFilter("company", "=", beendorsor.getPkValue());
                QFilter bankCateFilter = new QFilter("bank.bank_cate", "=", (Object)bank_cate);
                Object[] amBanks = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,bank", (QFilter[])new QFilter[]{companyIdFilter, bankCateFilter});
                if (EmptyUtil.isNoEmpty((Object[])amBanks)) {
                    logger.info("setBankAcct by bank_cate and company of Am:");
                    this.setBankAcctByAm(draftTrade, (DynamicObject)amBanks[0]);
                } else {
                    Object[] amBanksAnyOne = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,bank", (QFilter[])new QFilter[]{companyIdFilter});
                    if (EmptyUtil.isNoEmpty((Object[])amBanksAnyOne)) {
                        logger.info("setBankAcct by company of Am:");
                        this.setBankAcctByAm(draftTrade, (DynamicObject)amBanksAnyOne[0]);
                    }
                }
            }
        }
    }

    private void setBankAcctByAm(DynamicObject draftTrade, DynamicObject amBank) {
        if (EmptyUtil.isEmpty((DynamicObject)amBank)) {
            return;
        }
        draftTrade.set("bankacct", (Object)amBank.getString("bankaccountnumber"));
        Object pkId = amBank.getDynamicObject("bank").getPkValue();
        DynamicObject[] bdfinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"bebank,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (null != bdfinorginfo && bdfinorginfo.length > 0) {
            draftTrade.set("bankcode", (Object)bdfinorginfo[0].getString("union_number"));
            draftTrade.set("bank", (Object)bdfinorginfo[0].getDynamicObject("bebank"));
        }
    }

    private void setBankAcct(DynamicObject draftTrade, DynamicObject eleDirConSet) {
        DynamicObject defaultAccount = eleDirConSet.getDynamicObject("defaultaccount");
        draftTrade.set("bankacct", (Object)defaultAccount.getString("bankaccountnumber"));
        Object pkId = defaultAccount.getDynamicObject("bank").getPkValue();
        DynamicObject[] bdfinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"bebank,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (null != bdfinorginfo && bdfinorginfo.length > 0) {
            draftTrade.set("bankcode", (Object)bdfinorginfo[0].getString("union_number"));
            draftTrade.set("bank", (Object)bdfinorginfo[0].getDynamicObject("bebank"));
        }
    }

    protected boolean isCloseSubmEle(DynamicObject draftBill) {
        DynamicObject draftBillType = draftBill.getDynamicObject("draftbilltype");
        draftBillType = TmcDataServiceHelper.loadSingle((Object)draftBillType.getPkValue(), (String)"cdm_billtype");
        String billMedium = draftBillType.getString("billmedium");
        logger.info("billMedium:" + billMedium);
        return Objects.equals(billMedium, BillMediumEnum.ELECTRIC.getValue());
    }

    private void setOppAccName(DynamicObject draftTrade) {
        String tradeTypeStr = draftTrade.getString("tradetype");
        if (DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeTypeStr)) {
            DynamicObject beenDorSor;
            String payeeTypeText = draftTrade.getString("payeetypetext");
            String bankAcct = draftTrade.getString("bankacct");
            if ("bd_supplier".equals(payeeTypeText) || "bd_customer".equals(payeeTypeText)) {
                DynamicObject beenDorSor2 = draftTrade.getDynamicObject("beendorsor");
                if (EmptyUtil.isNoEmpty((DynamicObject)beenDorSor2)) {
                    DynamicObject beendorsor = TmcDataServiceHelper.loadSingle((Object)beenDorSor2.getPkValue(), (String)beenDorSor2.getDataEntityType().getName());
                    DynamicObjectCollection banks = beendorsor.getDynamicObjectCollection("entry_bank");
                    boolean isInnerOrg = BaseDataHelper.isExistInternalBusinessUnit((DynamicObject)beendorsor);
                    if (isInnerOrg) {
                        long orgId = draftTrade.getDynamicObject("company").getLong("id");
                        AppParam appParam = new AppParam((String)null, AppMetadataCache.getAppInfo((String)"cas").getId(), "08", Long.valueOf(orgId), Long.valueOf(0L), Long.valueOf(0L));
                        String cs126 = (String)SystemParamServiceHelper.getAppParameter((AppParam)appParam, (String)"cs126");
                        if ("1".equals(cs126) && StringUtils.isNotEmpty((CharSequence)bankAcct)) {
                            QFilter accountBankFilter = new QFilter("bankaccountnumber", "=", (Object)bankAcct);
                            accountBankFilter.and(BankAccountHelper.getNormalBankStatusFilter());
                            Object[] bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,acctname", (QFilter[])new QFilter[]{accountBankFilter});
                            if (!EmptyUtil.isEmpty((Object[])bankAccts)) {
                                draftTrade.set("oppaccname", (Object)bankAccts[0].getString("acctname"));
                            } else {
                                draftTrade.set("oppaccname", null);
                            }
                        } else if ("2".equals(cs126) && EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
                            String accountName = ((DynamicObject)banks.get(0)).getString("accountname");
                            draftTrade.set("oppaccname", (Object)accountName);
                        }
                    } else if (EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
                        String accountName = ((DynamicObject)banks.get(0)).getString("accountname");
                        draftTrade.set("oppaccname", (Object)accountName);
                    }
                }
            } else if ("bos_org".equals(payeeTypeText) && EmptyUtil.isNoEmpty((DynamicObject)(beenDorSor = draftTrade.getDynamicObject("beendorsor")))) {
                Object[] bankAccts;
                QFilter accountBankFilter = new QFilter("company", "in", beenDorSor.getPkValue()).and(BankAccountHelper.getNormalBankStatusFilter());
                if (StringUtils.isNotEmpty((CharSequence)bankAcct)) {
                    accountBankFilter.and(new QFilter("bankaccountnumber", "=", (Object)bankAcct));
                }
                if (!EmptyUtil.isEmpty((Object[])(bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,bank,acctname", (QFilter[])new QFilter[]{accountBankFilter})))) {
                    draftTrade.set("oppaccname", (Object)bankAccts[0].getString("acctname"));
                } else {
                    draftTrade.set("oppaccname", null);
                }
            }
        }
    }
}

