/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.executor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.opservice.allocation.scheduling.CalculationHeadService;
import kd.tmc.cdm.business.pool.ITransferExecutor;
import kd.tmc.cdm.business.pool.actions.ITransferAction;
import kd.tmc.cdm.business.pool.actions.TransferActionContext;
import kd.tmc.cdm.business.pool.state.TransferStateEnums;
import kd.tmc.cdm.business.pool.state.TransferStateMachine;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.TransBillOpStatusEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransferExecutor
implements ITransferExecutor {
    private static Log logger = LogFactory.getLog(TransferExecutor.class);
    private List<String> errMsgList = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DynamicObject transferBill, List<Long> entryIdList) {
        List entryList = transferBill.getDynamicObjectCollection("entryentity").stream().filter(o -> entryIdList.contains(o.getLong("id"))).collect(Collectors.toList());
        block9: for (DynamicObject entry : entryList) {
            entry.set("e_executetime", (Object)DateUtils.getCurrentTime());
            DynamicObject draftBill = entry.getDynamicObject("e_draftbill");
            String noteNo = draftBill.getString("draftbillno");
            String entryIdStr = entry.getString("id");
            logger.info("\u83b7\u53d6\u7968\u636e" + noteNo + "\u8c03\u5ea6\u7684\u7f51\u7edc\u4e92\u65a5\u9501");
            boolean isRequired = MutexServiceHelper.request((String)entryIdStr, (String)"cdm_draftallocation", (String)"draftbilltransfer");
            if (!isRequired) {
                String mutexErrMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25, \u7968\u636e[%s]\u6b63\u5728\u8fdb\u884c\u7968\u636e\u8c03\u5ea6\u64cd\u4f5c", (String)"TransferExecutor_2", (String)"tmc-cdm-business", (Object[])new Object[0]), noteNo);
                this.errMsgList.add(mutexErrMsg);
                continue;
            }
            logger.info("\u83b7\u53d6\u7968\u636e" + noteNo + "\u8c03\u5ea6\u7684\u7f51\u7edc\u4e92\u65a5\u9501\u6210\u529f");
            try {
                ITransferAction action;
                boolean isSuccess;
                TransferStateMachine stateMachine = new TransferStateMachine(transferBill, entry);
                TransferStateEnums currState = stateMachine.getState();
                if (currState == null) {
                    logger.info("\u83b7\u53d6\u7968\u636e" + noteNo + "\u64cd\u4f5c\u72b6\u6001\u5931\u8d25");
                    this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801:[%s]\u72b6\u6001\u5f02\u5e38\u5bfc\u81f4\u8c03\u5ea6\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"TransferExecutor_0", (String)"tmc-cdm-business", (Object[])new Object[0]), noteNo));
                    continue;
                }
                if (currState.isFinalState()) {
                    logger.info("\u7968\u636e" + noteNo + "\u5df2\u7ecf\u5b8c\u6210\u5168\u90e8\u8c03\u5ea6\u4efb\u52a1");
                    this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25, \u7968\u636e[%s]\u5df2\u5b8c\u6210\u5168\u90e8\u8c03\u5ea6\u4efb\u52a1", (String)"TransferExecutor_3", (String)"tmc-cdm-business", (Object[])new Object[0]), noteNo));
                    continue;
                }
                TransferActionContext context = new TransferActionContext();
                context.setTransferBill(transferBill);
                context.setTransferEntry(entry);
                DynamicObject transferEntry = context.getTransferEntry();
                do {
                    String opStatus = transferEntry.getString("e_transoptionstatus");
                    if (!TransBillOpStatusEnum.FAIL.getValue().equals(opStatus)) {
                        currState = stateMachine.next();
                    }
                    if (currState == null) continue block9;
                    String name = currState.getName();
                    logger.info("name is:" + name);
                    context.setCurrState(currState);
                    action = currState.createAction(context);
                    isSuccess = false;
                    try {
                        isSuccess = action.validate();
                    }
                    catch (Exception e) {
                        logger.error("action.validate \u5f02\u5e38", (Throwable)e);
                        entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.FAIL.getValue());
                        entry.set("e_errmsg", (Object)e.getMessage().substring(0, Math.min(e.getMessage().length(), 50)));
                        entry.set("e_errmsg_TAG", (Object)e.getMessage());
                        TransferStateEnums currStatus = context.getCurrState();
                        entry.set("e_opbilltype", (Object)currStatus.getBillType());
                        entry.set("e_opbilltsteps", (Object)currStatus.getOpVal());
                    }
                    if (isSuccess) {
                        logger.info("\u6821\u9a8c\u6210\u529f, \u5f00\u59cb\u6267\u884c\u8c03\u62e8\u4efb\u52a1");
                        isSuccess = action.execute();
                        TransferStateEnums currStatus = context.getCurrState();
                        if (isSuccess) {
                            logger.info("\u8c03\u5ea6\u6210\u529f{}\uff0c{}", (Object)currStatus.getBillType(), (Object)currStatus.getOpVal());
                            continue;
                        }
                        logger.info("\u8c03\u5ea6\u5931\u8d25:" + String.join((CharSequence)";", action.getErrMsgList()));
                        continue;
                    }
                    logger.info("\u6821\u9a8c\u5931\u8d25:" + String.join((CharSequence)";", action.getErrMsgList()));
                } while (isSuccess);
                this.errMsgList.addAll(action.getErrMsgList());
            }
            catch (Exception e) {
                logger.error("\u7968\u636e\u8c03\u5ea6\u4e2d, \u4ea7\u751f\u5f02\u5e38:", (Throwable)e);
                this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u7968\u636e\u8c03\u5ea6\u4e2d, \u4ea7\u751f\u5f02\u5e38:%s", (String)"TransferExecutor_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            finally {
                logger.info("\u91ca\u653e\u7968\u636e" + noteNo + "\u8c03\u5ea6\u7684\u7f51\u7edc\u4e92\u65a5\u9501");
                MutexServiceHelper.release((String)entryIdStr, (String)"cdm_draftallocation", (String)"draftbilltransfer");
            }
        }
        CalculationHeadService.fillHeader(transferBill, entryIdList);
        boolean allSuccess = transferBill.getDynamicObjectCollection("entryentity").stream().allMatch(d -> Objects.equals(d.getString("e_transoptionstatus"), TransBillOpStatusEnum.SUCCESS.getValue()));
        if (allSuccess) {
            logger.info("all is Success" + transferBill.getLong("id"));
            transferBill.set("issubmitendorse", (Object)"1");
            this.pushDraftTradeBills(transferBill);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transferBill});
        return this.errMsgList.isEmpty();
    }

    private void poolOutDeal(DynamicObject transferBill) {
        Set<DynamicObject> entrysBill = transferBill.getDynamicObjectCollection("entryentity").stream().map(e -> e.getDynamicObject("e_draftbill")).collect(Collectors.toSet());
        DynamicObject[] bills = entrysBill.toArray(new DynamicObject[0]);
        DynamicObject[] realbills = this.getGenerateReceivableBills(bills);
        Object[] billIdsArr = Arrays.stream(realbills).filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("billpool"))).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isEmpty((Object[])billIdsArr)) {
            return;
        }
        logger.info("will out pool bills:" + SerializationUtils.toJsonString((Object)billIdsArr));
        OperationResult pushResult = TmcOperateServiceHelper.execOperate((String)"pushout", (String)"cdm_receivablebill", (Object[])billIdsArr, (OperateOption)OperateOption.create());
        DynamicObject[] outBills = null;
        if (pushResult.isSuccess()) {
            QFilter sourceBillFilter = new QFilter("sourcebillid", "in", (Object)billIdsArr);
            QFilter typeFilter = new QFilter("businesstype", "=", (Object)BizBusinessTypeEnum.OUT.getValue());
            outBills = BusinessDataServiceHelper.load((String)"cdm_billpoolbiz", (String)"id,bizdate,businesstype,billstatus", (QFilter[])new QFilter[]{sourceBillFilter, typeFilter});
        } else {
            logger.info("pushout has exception:" + TmcOperateServiceHelper.decodeErrorMsg((OperationResult)pushResult));
        }
        if (outBills == null) {
            logger.info(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u4e0b\u63a8\u7684\u51fa\u6c60\u7533\u8bf7\u5355\u4e3a\u7a7a\u3002", (String)"PoolOutAction_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        long allocId = transferBill.getLong("id");
        operateOption.setVariableValue("autoallocation", "true");
        operateOption.setVariableValue("allocationid", String.valueOf(allocId));
        OperationResult result = null;
        try {
            Object[] outBillIds = Arrays.stream(outBills).filter(e -> "A".equalsIgnoreCase(e.getString("billstatus"))).map(DataEntityBase::getPkValue).toArray();
            if (EmptyUtil.isNoEmpty((Object[])outBillIds)) {
                logger.info("is will submit" + outBillIds.length);
                result = this.doOperate("submit", "cdm_billpoolbiz", outBillIds, operateOption);
                if (result.isSuccess()) {
                    logger.info("is will audit");
                    result = this.doOperate("audit", "cdm_billpoolbiz", result.getSuccessPkIds().toArray(), operateOption);
                }
            } else {
                logger.info("outBillIds is null");
            }
        }
        catch (Exception e2) {
            logger.error("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\u3002", (Throwable)e2);
        }
        if (result != null && !result.isSuccess()) {
            logger.info("pushout has exception:" + TmcOperateServiceHelper.decodeErrorMsg(result));
        }
    }

    private void pushDraftTradeBills(DynamicObject transferBill) {
        long paymentBillId = transferBill.getLong("sourcebillid");
        if (paymentBillId > 0L) {
            Set<DynamicObject> entrysBill = transferBill.getDynamicObjectCollection("entryentity").stream().map(e -> e.getDynamicObject("e_draftbill")).collect(Collectors.toSet());
            Object[] bills = entrysBill.toArray(new DynamicObject[0]);
            try {
                this.poolOutDeal(transferBill);
            }
            catch (Exception e2) {
                logger.error("\u51fa\u6c60\u5931\u8d25\u3002", (Throwable)e2);
            }
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)paymentBillId, (String)"cas_paybill");
            if (EmptyUtil.isNoEmpty((Object[])bills)) {
                DynamicObjectCollection entitys = transferBill.getDynamicObjectCollection("entryentity");
                HashSet<String> draftbillNoSet = new HashSet<String>(8);
                HashSet<BigDecimal> draftAmountSet = new HashSet<BigDecimal>(8);
                for (DynamicObject entity : entitys) {
                    String draftbillno = entity.getDynamicObject("e_draftbill").getString("draftbillno");
                    BigDecimal e_subbillamt = entity.getBigDecimal("e_subbillamt");
                    draftbillNoSet.add(draftbillno);
                    draftAmountSet.add(e_subbillamt);
                }
                logger.info("billno is that:" + SerializationUtils.toJsonString(draftbillNoSet));
                QFilter qFilterCompany = new QFilter("company", "=", payBill.getDynamicObject("org").getPkValue());
                QFilter qFilterBillno = new QFilter("draftbillno", "in", draftbillNoSet);
                QFilter qFilterAmount = new QFilter("availableamount", "in", draftAmountSet);
                QFilter qFilterStatus = new QFilter("billstatus", "=", (Object)"C");
                QFilter qFilterRptype = new QFilter("rptype", "=", (Object)"receivebill");
                QFilter qFilterDraftBIllStatus = new QFilter("draftbillstatus", "=", (Object)"registered");
                Object[] recIds = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,draftbillno", (QFilter[])new QFilter[]{qFilterCompany, qFilterBillno, qFilterStatus, qFilterRptype, qFilterDraftBIllStatus, qFilterAmount});
                if (EmptyUtil.isNoEmpty((Object[])recIds)) {
                    Set draftbillnoSet = Arrays.stream(recIds).map(e -> e.getString("draftbillno")).collect(Collectors.toSet());
                    Set draftbillIdSet = Arrays.stream(recIds).map(e -> e.getLong("id")).collect(Collectors.toSet());
                    logger.info("draftbillnoSet.size() :" + draftbillnoSet.size() + ",draftbillNoSet.size() is:" + draftbillNoSet.size() + ",draftbillIdSet is:" + SerializationUtils.toJsonString(draftbillIdSet));
                    if (draftbillnoSet.size() == draftbillNoSet.size()) {
                        OperationResult result;
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("autoallocation", "true");
                        logger.info("\u4ed8\u6b3e\u5355:" + payBill.getString("billno") + "\u4ed8\u6b3e\u5355\u5f53\u524d\u72b6\u6001" + payBill.get("billstatus"));
                        try {
                            result = OperateServiceHelper.execOperate((String)"pushdrafttrade", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)operateOption);
                        }
                        catch (Exception e3) {
                            logger.error("\u4ed8\u6b3e\u5355\u4e0b\u63a8\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u3002", (Throwable)e3);
                            throw e3;
                        }
                        if (result != null && !result.isSuccess()) {
                            logger.error("\u4ed8\u6b3e\u5355\u4e0b\u63a8\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u3002");
                            throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)result));
                        }
                    } else {
                        logger.info("payOrgGeneBillsSet size not equals bills");
                    }
                } else {
                    logger.info("recIds is null");
                }
            }
        }
    }

    @Override
    public List<String> getErrMsgList() {
        return this.errMsgList;
    }

    private DynamicObject[] getGenerateReceivableBills(DynamicObject[] draftBills) {
        Object[] receivableBillIds = Arrays.stream(draftBills).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] loadFromDB = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id", (QFilter[])new QFilter("sourcedraft", "in", (Object)receivableBillIds).toArray());
        if (loadFromDB.length == 0) {
            draftBills = BusinessDataServiceHelper.load((Object[])receivableBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_draftbillf7"));
            return draftBills;
        }
        receivableBillIds = Arrays.stream(loadFromDB).map(DataEntityBase::getPkValue).toArray();
        draftBills = BusinessDataServiceHelper.load((Object[])receivableBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_draftbillf7"));
        return this.getGenerateReceivableBills(draftBills);
    }

    protected OperationResult doOperate(String opName, String entityName, Object[] idArr, OperateOption option) {
        OperationResult result = TmcOperateServiceHelper.execOperate((String)opName, (String)entityName, (Object[])idArr, (OperateOption)option);
        this.handleOpResult(result);
        return result;
    }

    private void handleOpResult(OperationResult result) {
        if (!result.isSuccess()) {
            String errMsg = TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)result);
            this.errMsgList.add(errMsg);
        }
    }
}

