/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.state;

import java.util.Collections;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.pool.state.TransferStateEnums;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.cdm.common.helper.RecEleDraftHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransferStateMachine {
    private static final Log logger = LogFactory.getLog(TransferStateMachine.class);
    private DynamicObject transferBill;
    private DynamicObject transferEntry;
    private TransferStateEnums currState;

    public TransferStateMachine(DynamicObject transferBill, DynamicObject transferEntry) {
        this.transferBill = transferBill;
        this.transferEntry = transferEntry;
        this.initState();
    }

    public TransferStateEnums getState() {
        return this.currState;
    }

    public TransferStateEnums next() {
        this.currState = this.getNextState();
        return this.currState;
    }

    private void initState() {
        boolean finishFlag = this.transferEntry.getBoolean("e_transfinish");
        if (finishFlag) {
            this.currState = TransferStateEnums.FINAL;
            return;
        }
        String billType = this.transferEntry.getString("e_opbilltype");
        if (EmptyUtil.isEmpty((String)billType)) {
            this.currState = TransferStateEnums.INIT;
            return;
        }
        String opType = this.transferEntry.getString("e_opbilltsteps");
        for (TransferStateEnums state : TransferStateEnums.values()) {
            if (!Objects.equals(state.getBillType(), billType) || !Objects.equals(state.getOpVal(), opType)) continue;
            this.currState = state;
            return;
        }
        this.currState = null;
    }

    private TransferStateEnums getNextState() {
        if (this.currState == null || TransferStateEnums.FINAL == this.currState) {
            return null;
        }
        String bizType = this.transferBill.getString("biztype");
        if (DraftAllocateBizTypeEnum.ALLOCATE.getValue().equals(bizType)) {
            String dispatchRule = this.transferBill.getString("dispatchrule");
            if (Objects.equals(dispatchRule, DispatchRuleEnum.DIRECT.getValue())) {
                switch (this.currState) {
                    case INIT: {
                        return TransferStateEnums.ENDORSE_CREATE;
                    }
                    case ENDORSE_CREATE: {
                        if (this.isSubmitEle()) {
                            return TransferStateEnums.ENDORSE_SUBMITELE;
                        }
                        return TransferStateEnums.ENDORSE_COMPLETE;
                    }
                    case ENDORSE_COMPLETE: 
                    case ENDORSE_SUBMITELE: {
                        return TransferStateEnums.POOLOUT;
                    }
                    case POOLOUT: {
                        return TransferStateEnums.FINAL;
                    }
                }
                return null;
            }
            switch (this.currState) {
                case INIT: {
                    return TransferStateEnums.ENDORSEUP_CREATE;
                }
                case ENDORSEUP_CREATE: {
                    if (this.isSubmitEle()) {
                        return TransferStateEnums.ENDORSEUP_SUBMITELE;
                    }
                    return TransferStateEnums.ENDORSEUP_COMPLETE;
                }
                case ENDORSEUP_COMPLETE: 
                case ENDORSEUP_SUBMITELE: {
                    return TransferStateEnums.ENDORSEDOWN_CREATE;
                }
                case ENDORSEDOWN_CREATE: {
                    if (this.isSubmitEle()) {
                        return TransferStateEnums.ENDORSEDOWN_SUBMITELE;
                    }
                    return TransferStateEnums.ENDORSEDOWN_COMPLETE;
                }
                case ENDORSEDOWN_COMPLETE: 
                case ENDORSEDOWN_SUBMITELE: {
                    return TransferStateEnums.POOLOUT;
                }
                case POOLOUT: {
                    return TransferStateEnums.FINAL;
                }
            }
            return null;
        }
        if (DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue().equals(bizType)) {
            switch (this.currState) {
                case INIT: {
                    return TransferStateEnums.ENDORSEUP_CREATE;
                }
                case ENDORSEUP_CREATE: {
                    if (this.isSubmitEle()) {
                        return TransferStateEnums.ENDORSEUP_SUBMITELE;
                    }
                    return TransferStateEnums.ENDORSEUP_COMPLETE;
                }
                case ENDORSEUP_COMPLETE: 
                case ENDORSEUP_SUBMITELE: {
                    return TransferStateEnums.POOLOUT;
                }
                case POOLOUT: {
                    return TransferStateEnums.FINAL;
                }
            }
            return null;
        }
        if (DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue().equals(bizType)) {
            switch (this.currState) {
                case INIT: {
                    return TransferStateEnums.ENDORSEDOWN_CREATE;
                }
                case ENDORSEDOWN_CREATE: {
                    if (this.isSubmitEle()) {
                        return TransferStateEnums.ENDORSEDOWN_SUBMITELE;
                    }
                    return TransferStateEnums.ENDORSEDOWN_COMPLETE;
                }
                case ENDORSEDOWN_COMPLETE: 
                case ENDORSEDOWN_SUBMITELE: {
                    return TransferStateEnums.POOLOUT;
                }
                case POOLOUT: {
                    return TransferStateEnums.FINAL;
                }
            }
            return null;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u5904\u7406\u7c7b\u578b\u3002", (String)"TransferStateMachine_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
    }

    private boolean isSubmitEle() {
        boolean usualJudage = RecEleDraftHelper.isSubmitEleNew((DynamicObject)this.transferBill, Collections.singletonList(this.transferEntry.getDynamicObject("e_draftbill").getLong("id")));
        Long sourceId = this.transferBill.getLong("sourcebillid");
        logger.info("usualJudage is:" + usualJudage);
        if (usualJudage) {
            if (EmptyUtil.isEmpty((Long)sourceId)) {
                DynamicObject bankaccount = this.transferEntry.getDynamicObject("e_draftbill").getDynamicObject("bankaccount");
                Object[] electricDirect = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount", "=", bankaccount.getPkValue())});
                if (EmptyUtil.isNoEmpty((Object[])electricDirect)) {
                    return true;
                }
                logger.info("electricDirect is null");
                return false;
            }
            DynamicObject draftBill = this.transferEntry.getDynamicObject("e_draftbill");
            boolean judgeOfEleOrPaperBill = RecEleDraftHelper.judgeOfEleOrPaperBill((DynamicObject)this.transferBill, (DynamicObject)draftBill);
            logger.info("judgeOfEleOrPaperBill is :" + judgeOfEleOrPaperBill);
            return judgeOfEleOrPaperBill;
        }
        return false;
    }
}

