/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class EleBillCommonHelper {
    private static final Log logger = LogFactory.getLog(EleBillCommonHelper.class);
    public static final String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();

    public static boolean isBackInfoSeries(DynamicObjectCollection sideInfos) {
        String preEndorser = "";
        for (int i = 0; i < sideInfos.size(); ++i) {
            if ("02".equals(((DynamicObject)sideInfos.get(i)).getString("businesscode")) || "17".equals(((DynamicObject)sideInfos.get(i)).getString("businesscode"))) continue;
            String endorse = ((DynamicObject)sideInfos.get(i)).getString("endorsee");
            if (i > 0 && !endorse.equals(preEndorser)) {
                return Boolean.FALSE;
            }
            preEndorser = ((DynamicObject)sideInfos.get(i)).getString("endorser");
        }
        return Boolean.TRUE;
    }

    public static boolean isCorrectTimeToEB(List<NoteResult> result, Long companyId) {
        try {
            Date rightNowDate = new Date();
            int year = DateUtils.getYear((Date)rightNowDate);
            boolean isExist = EleBillCommonHelper.existCalendar(year);
            if (isExist) {
                String orderBys;
                ORM orm = ORM.create();
                String selectFields = "id,number,name,entitys.id,entitys.year,entitys.workdate,entitys.datetype";
                QFilter[] qf = new QFilter[]{new QFilter("entitys.year", "=", (Object)year), new QFilter("enable", "=", (Object)Boolean.TRUE)};
                DynamicObjectCollection workCalendar = orm.query("tbd_workcalendar", selectFields, qf, orderBys = "id desc");
                Set<Long> wcIds = workCalendar.stream().distinct().map(o -> o.getLong("id")).collect(Collectors.toSet());
                if (WorkCalendarHelper.isWorkDay((Long[])wcIds.toArray(new Long[0]), (Date)DateUtils.getDataFormat((Date)rightNowDate, (boolean)true))) {
                    return EleBillCommonHelper.isWorkTime(companyId, rightNowDate, result);
                }
                for (NoteResult noteResult : result) {
                    noteResult.setStatusCode(EBResultStatusCode.ERROR);
                    noteResult.setErrMsg(ResManager.loadKDString((String)"\u8bf7\u5728\u5de5\u4f5c\u65f6\u95f4\u64cd\u4f5c\u3002", (String)"EleBillCommonHelper_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                return Boolean.FALSE;
            }
            return EleBillCommonHelper.isWorkTime(companyId, rightNowDate, result);
        }
        catch (NumberFormatException e) {
            logger.error("EleBillCommonHelper.isCorrectTimeToEB Exception :", (Throwable)e);
            throw e;
        }
    }

    private static boolean isWorkTime(Long companyId, Date rightNowDate, List<NoteResult> result) {
        Object eleBillWorkTimeS = SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)companyId, (String)"elebillworktime_start");
        Object eleBillWorkTimeE = SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)companyId, (String)"elebillworktime_end");
        int eleBillWorkTimeIntS = Integer.parseInt(eleBillWorkTimeS.toString());
        int eleBillWorkTimeIntE = Integer.parseInt(eleBillWorkTimeE.toString());
        long startTime = System.currentTimeMillis();
        if (eleBillWorkTimeIntS > -1 && eleBillWorkTimeIntE > -1) {
            String eleBillWorkTimeSS = EleBillCommonHelper.second2Time(Integer.parseInt(eleBillWorkTimeS.toString()));
            String eleBillWorkTimeSE = EleBillCommonHelper.second2Time(Integer.parseInt(eleBillWorkTimeE.toString()));
            String rightNowTime = EleBillCommonHelper.setDateToHHMMSS(rightNowDate);
            int rightNowTimeToSeconds = EleBillCommonHelper.time2Second(rightNowTime);
            if (eleBillWorkTimeIntS <= rightNowTimeToSeconds && rightNowTimeToSeconds <= eleBillWorkTimeIntE) {
                long endTime = System.currentTimeMillis();
                EleBillCommonHelper.costTime(startTime, endTime);
                return Boolean.TRUE;
            }
            for (NoteResult noteResult : result) {
                noteResult.setStatusCode(EBResultStatusCode.ERROR);
                noteResult.setErrMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u5de5\u4f5c\u65f6\u95f4 %1$s ~ %2$s \u64cd\u4f5c\u3002", (String)"EleBillCommonHelper_0", (String)"tmc-cdm-business", (Object[])new Object[0]), eleBillWorkTimeSS, eleBillWorkTimeSE));
            }
            long endTime = System.currentTimeMillis();
            EleBillCommonHelper.costTime(startTime, endTime);
            return Boolean.FALSE;
        }
        long endTime = System.currentTimeMillis();
        EleBillCommonHelper.costTime(startTime, endTime);
        return Boolean.TRUE;
    }

    public static boolean existCalendar(int year) {
        QFilter[] qf = new QFilter[]{new QFilter("entitys.year", "=", (Object)year), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.exists((String)"tbd_workcalendar", (QFilter[])qf);
    }

    public static String second2Time(Integer seconds) {
        if (seconds == null || seconds < 0) {
            return "00:00:00";
        }
        int hour = seconds / 3600;
        int minute = seconds % 3600 / 60;
        int second = seconds % 60;
        String timeFormat = (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":";
        timeFormat = timeFormat + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":";
        timeFormat = timeFormat + (second < 10 ? "0" + second : Integer.valueOf(second));
        return timeFormat;
    }

    public static int time2Second(String timeFormat) {
        int index1 = timeFormat.indexOf(":");
        int index2 = timeFormat.indexOf(":", index1 + 1);
        int hh = Integer.parseInt(timeFormat.substring(0, index1));
        int mi = Integer.parseInt(timeFormat.substring(index1 + 1, index2));
        int ss = Integer.parseInt(timeFormat.substring(index2 + 1));
        return hh * 60 * 60 + mi * 60 + ss;
    }

    public static String setDateToHHMMSS(Date newDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String newDateStr = dateFormat.format(newDate);
        return newDateStr.substring(11);
    }

    private static void costTime(long startTime, long endTime) {
        logger.info("EleBillCommonHelper.isCorrectTimeToEB start time ={}", (Object)startTime);
        logger.info("EleBillCommonHelper.isCorrectTimeToEB end time ={}", (Object)endTime);
        logger.info("EleBillCommonHelper.isCorrectTimeToEB cost time ={}", (Object)(endTime - startTime));
    }

    public static boolean isInternalUnit(String value, DynamicObject company) {
        DynamicObject internalCompany;
        DynamicObject internalCompany2;
        long orgId = company == null ? 0L : company.getLong("id");
        boolean isAutoSignIn = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (String)"08", (Long)orgId, (String)"isautosignin");
        if (!isAutoSignIn) {
            return Boolean.FALSE;
        }
        QFilter nameQFilter = new QFilter("name", "=", (Object)value);
        nameQFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] customerArr = TmcDataServiceHelper.load((String)"bd_customer", (String)"id,internal_company", (QFilter[])new QFilter[]{nameQFilter});
        if (customerArr.length > 0 && !ObjectUtils.isEmpty((Object)(internalCompany2 = customerArr[0].getDynamicObject("internal_company")))) {
            return Boolean.TRUE;
        }
        DynamicObject[] supplierArr = TmcDataServiceHelper.load((String)"bd_supplier", (String)"id,internal_company", (QFilter[])new QFilter[]{nameQFilter});
        if (supplierArr.length > 0 && !ObjectUtils.isEmpty((Object)(internalCompany = supplierArr[0].getDynamicObject("internal_company")))) {
            return Boolean.TRUE;
        }
        DynamicObject[] orgArr = TmcDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (orgArr.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

