/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillBatchPushAttachment {
    private static final Log logger = LogFactory.getLog(PayableBillBatchPushAttachment.class);
    public static final String ATTACHMENTPANEL = "attachmentpanel";
    public static final String ATTACHMENTENTRY = "attachmententry";
    public static final String ENTRYENTITY = "entryentity";
    public static final String SOURCEBILLID = "sourcebillid";

    public void pushAttachment(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            String entityName = dynamicObject.getDataEntityType().getName();
            List<Map<String, Object>> attachmentDataFromTemp = this.buildAttachmentDataFromTemp(dynamicObject, entityName);
            this.buildAttachmentDataAndSave(dynamicObject, entityName, attachmentDataFromTemp);
        }
    }

    private void buildAttachmentDataAndSave(DynamicObject dynamicObject, String entityName, List<Map<String, Object>> attachmentDataFromTemp) {
        Map tarBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{(Long)dynamicObject.get("id")});
        HashSet pkValues = (HashSet)tarBills.get("cdm_payablebill");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
        Map<String, String> dynamicObjectMap = this.buildDynamicObjectMap(dynamicObjectCollection);
        this.pushAttachment(dynamicObject, entityName, dynamicObjectMap, attachmentDataFromTemp);
    }

    private Map<String, String> buildDynamicObjectMap(DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, String> dynamicObjectMap = new HashMap<String, String>();
        for (DynamicObject dynamicObjectTargetBills : dynamicObjectCollection) {
            dynamicObjectMap.put(dynamicObjectTargetBills.get(SOURCEBILLID).toString(), dynamicObjectTargetBills.get("id").toString());
        }
        return dynamicObjectMap;
    }

    private List<Map<String, Object>> buildAttachmentDataFromTemp(DynamicObject dynamicObject, String entityName) {
        DynamicObject file = BusinessDataServiceHelper.loadSingle((String)entityName, (String)ATTACHMENTPANEL, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)((String)dynamicObject.get("billno")))});
        return AttachmentServiceHelper.getAttachments((String)entityName, (Object)file.getPkValue().toString(), (String)ATTACHMENTPANEL);
    }

    private void pushAttachment(DynamicObject dynamicObject, String entityName, Map<String, String> dynamicObjectMap, List<Map<String, Object>> attachmentDataFromTemp) {
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            this.updateAttachmentDataUrl(attachmentDataFromTemp);
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"cdm_payablebill_ap_manual");
            DynamicObjectCollection dynamicObjectCollection = loadSingle.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject dynamicObjectEntry : dynamicObjectCollection) {
                DynamicObjectCollection sourceAttach;
                List<Map<String, Object>> attachmentDataEntryentity;
                if (!dynamicObjectMap.containsKey(dynamicObjectEntry.get("id").toString())) continue;
                if (EmptyUtil.isNoEmpty(attachmentDataFromTemp)) {
                    AttachmentServiceHelper.upload((String)"cdm_payablebill", (Object)dynamicObjectMap.get(dynamicObjectEntry.get("id").toString()), (String)ATTACHMENTPANEL, attachmentDataFromTemp);
                }
                if (!EmptyUtil.isNoEmpty(attachmentDataEntryentity = this.buildAttachmentDataEntryentity(sourceAttach = (DynamicObjectCollection)dynamicObjectEntry.get(ATTACHMENTENTRY), entityName, dynamicObjectEntry.get("id").toString()))) continue;
                HashMap<String, List<Map<String, Object>>> attachemnts = new HashMap<String, List<Map<String, Object>>>();
                attachemnts.put(ATTACHMENTPANEL, attachmentDataEntryentity);
                AttachmentServiceHelper.saveTempAttachments((String)"cdm_payablebill", (Object)dynamicObjectMap.get(dynamicObjectEntry.get("id").toString()), (String)ATTACHMENTPANEL, attachemnts);
            }
        }
    }

    private void updateAttachmentDataUrl(List<Map<String, Object>> attachmentDataFromTemp) {
        attachmentDataFromTemp.forEach(attach -> {
            try {
                attach.put("lastModified", null);
                attach.put("url", this.getPathfromDownloadUrl(URLDecoder.decode(String.valueOf(attach.get("url")), "UTF-8")));
            }
            catch (IOException e) {
                logger.error("updateAttachmentDataUrl", (Throwable)e);
            }
        });
    }

    private List<Map<String, Object>> buildAttachmentDataEntryentity(DynamicObjectCollection sourceAttachCol, String entityName, String billPkId) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        sourceAttachCol.forEach(attach -> {
            DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
            HashMap<String, Object> attachMap = new HashMap<String, Object>();
            attachMap.put("description", attachObj.getString("description"));
            attachMap.put("type", attachObj.getString("type"));
            InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attachObj.getString("url"));
            String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachObj.getString("name"), (InputStream)new BufferedInputStream(inputStream), 7200);
            attachMap.put("url", saveUrl);
            attachMap.put("uid", this.getUid().toString());
            attachMap.put("name", attachObj.getString("name"));
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", ATTACHMENTPANEL);
            attachMap.put("entityNum", entityName);
            attachMap.put("billPkId", billPkId);
            attachMap.put("lastModified", new Date().getTime());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        });
        return attachDataList;
    }

    private StringBuffer getUid() {
        StringBuffer uid = new StringBuffer("rc-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        SecureRandom random = new SecureRandom();
        int index = (int)(random.nextDouble() * 10.0);
        uid.append(index);
        return uid;
    }

    private String getPathfromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        path = URLDecoder.decode(path, "UTF-8");
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }
}

