/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.allocation;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class AsyncPushPledgeBill
implements Runnable {
    private static final Log logger = LogFactory.getLog(AsyncPushPledgeBill.class);
    private Object[] draftbillsArr;

    public AsyncPushPledgeBill(Object[] draftbills) {
        this.draftbillsArr = draftbills;
    }

    @Override
    public void run() {
        this.pushPledgeBill(this.draftbillsArr);
    }

    private void pushPledgeBill(Object[] pkIds) {
        try (TXHandle tx = TX.requiresNew();){
            OperateOption operateOption = OperateOption.create();
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushpledge", (String)"cdm_drafttradebill", (Object[])pkIds, (OperateOption)operateOption);
            if (!result.isSuccess()) {
                List successPkIds = result.getSuccessPkIds();
                if (successPkIds.size() > 0) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("cdm_drafttradebill_ignore", "1");
                    String entityName = "gm_pledgebill";
                    OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)entityName, (Object[])successPkIds.toArray(), (OperateOption)option);
                    if (!deleteResult.isSuccess()) {
                        successPkIds.removeAll(deleteResult.getSuccessPkIds());
                        logger.error(String.format("\u8d28\u62bc\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", entityName, successPkIds.toString()));
                    }
                }
                String string = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result);
            }
        }
    }
}

