/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.billstorage;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import org.apache.commons.lang3.ObjectUtils;

public class PayEleBillStorageService {
    private static final Log logger = LogFactory.getLog(PayEleBillStorageService.class);
    private static final String STORAGE_OP_KEY = "storage_op_key";

    public static List<StorageResult> storage(List<Long> payEleBillIdS, boolean isInnerBill) {
        logger.info("PayEleBillStorageService.storage payEleBillIdS = {}", (Object)JSON.toJSONString(payEleBillIdS));
        if (payEleBillIdS == null || payEleBillIdS.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<StorageResult> storageResults = new ArrayList<StorageResult>();
        try {
            DynamicObject[] finalPayEleBillArr = TmcDataServiceHelper.load((Object[])payEleBillIdS.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
            finalPayEleBillArr = (DynamicObject[])Arrays.stream(finalPayEleBillArr).filter(o -> !o.getString("ticketstatus").equals("destroy") || !o.getString("backflag").equals("1")).toArray(DynamicObject[]::new);
            if (finalPayEleBillArr.length == 0) {
                logger.info("PayEleBillStorageService.storage finalPayEleBillArr = {}", (Object)finalPayEleBillArr.length);
                StorageResult sr = new StorageResult();
                sr.setSuccess(Boolean.FALSE);
                storageResults.add(sr);
                return storageResults;
            }
            Set billIds = Stream.of(finalPayEleBillArr).map(o -> o.get("sourceid")).collect(Collectors.toSet());
            QFilter billNoQFilter = new QFilter("id", "in", billIds);
            DynamicObjectCollection payBillColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])new QFilter[]{billNoQFilter});
            if (payBillColl.size() == 0) {
                logger.info("PayEleBillStorageService storage payBillColl.size = {}", (Object)finalPayEleBillArr.length);
                StorageResult sr = new StorageResult();
                sr.setSuccess(Boolean.FALSE);
                storageResults.add(sr);
                return storageResults;
            }
            DynamicObject[] payBillArr = TmcDataServiceHelper.load((Object[])payBillColl.stream().map(o -> o.getLong("id")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_payablebill"));
            Map payBillMap = Stream.of(payBillArr).collect(Collectors.toMap(o -> o.get("id"), Function.identity(), (k1, k2) -> k1));
            for (DynamicObject eleRecDraftBill : finalPayEleBillArr) {
                DynamicObject payableBill = (DynamicObject)payBillMap.get(eleRecDraftBill.get("sourceid"));
                if (payableBill == null) continue;
                PayEleBillStorageService.buildPayableBill(payableBill, eleRecDraftBill);
                String billIdStr = payableBill.getPkValue() == null ? "" : payableBill.getPkValue().toString();
                try {
                    boolean isLock = MutexServiceHelper.request((String)billIdStr, (String)"cdm_payablebill", (String)STORAGE_OP_KEY);
                    StorageResult sr = new StorageResult();
                    if (isLock) {
                        OperateOption operateOption;
                        boolean isFinishStatus;
                        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{payableBill});
                        sr.setSuccess(Boolean.TRUE);
                        sr.setBillId(payableBill.getLong("id"));
                        sr.setBillNo(payableBill.getString("billno"));
                        storageResults.add(sr);
                        boolean grdBag = eleRecDraftBill.getBoolean("grdbag");
                        boolean isTransSuccess = BankReturnStatusEnum.BANK_SUCCESS.getValue().equals(eleRecDraftBill.getString("ebstatus"));
                        if (grdBag) {
                            boolean bl = isFinishStatus = EleDraftNoteStatusEnum.CS03.getValue().equalsIgnoreCase(eleRecDraftBill.getString("notestatus")) && EleDraftCirStatusEnum.TF0301.getValue().equalsIgnoreCase(eleRecDraftBill.getString("cirstatus"));
                            if (!isTransSuccess || !isFinishStatus) continue;
                            operateOption = OperateOption.create();
                            operateOption.setVariableValue("isInnerBill", String.valueOf(isInnerBill));
                            TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{payableBill}, (OperateOption)operateOption);
                            continue;
                        }
                        isFinishStatus = EleDraftBillStatusEnum.INVOICESIGNED.getValue().equalsIgnoreCase(eleRecDraftBill.getString("ticketstatus"));
                        if (!isTransSuccess || !isFinishStatus) continue;
                        operateOption = OperateOption.create();
                        operateOption.setVariableValue("isInnerBill", String.valueOf(isInnerBill));
                        TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{payableBill}, (OperateOption)operateOption);
                        continue;
                    }
                    sr.setSuccess(Boolean.FALSE);
                    sr.setBillId(ObjectUtils.isEmpty((Object)billIdStr) ? 0L : Long.parseLong(billIdStr));
                    sr.setErrCode("BILL_MUTEX_LOCK");
                    sr.setErrMsg(ResManager.loadKDString((String)"\u5355\u636e\u88ab\u5176\u4ed6\u64cd\u4f5c\u9501\u5b9a, \u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"RecEleBillStorageService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    storageResults.add(sr);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    throw e;
                }
                finally {
                    MutexServiceHelper.release((String)billIdStr, (String)"cdm_payablebill", (String)STORAGE_OP_KEY);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        return storageResults;
    }

    private static void buildPayableBill(DynamicObject payBill, DynamicObject eleRecDraftBill) {
        payBill.set("modifytime", (Object)new Date());
        logger.info("\u5e94\u4ed8\u7968\u636e\u540c\u6b65\uff1a\u7535\u7968\u7968\u636e\u72b6\u6001=" + eleRecDraftBill.getString("ticketstatus") + ",\u7535\u7968\u64cd\u4f5c\u72b6\u6001=" + eleRecDraftBill.getString("ebstatus"));
        payBill.set("draftbilltranstatus", (Object)PayEleBillStorageService.getDraftBillTranStatus(eleRecDraftBill.getString("ebstatus")));
        logger.info("\u5e94\u4ed8\u7968\u636e\u540c\u6b65\uff1a\u7968\u636e\u4ea4\u6613\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        payBill.set("issplit", eleRecDraftBill.get("grdbag"));
        String subRange = eleRecDraftBill.getString("subrange");
        payBill.set("subbillrange", (Object)subRange);
        if (EmptyUtil.isNoEmpty((String)subRange) && subRange.contains("-")) {
            long subBillStartFlag = Long.parseLong(subRange.split("-")[0]);
            long subBillEndFlag = Long.parseLong(subRange.split("-")[1]);
            payBill.set("subbillstartflag", (Object)subBillStartFlag);
            payBill.set("subbillendflag", (Object)subBillEndFlag);
            payBill.set("subbillquantity", (Object)(subBillEndFlag - subBillStartFlag + 1L));
        }
        payBill.set("eledraftstatus", eleRecDraftBill.get("ticketstatus"));
        payBill.set("eledraftstatusnew", eleRecDraftBill.get("notestatus"));
        payBill.set("elccirculatestatus", eleRecDraftBill.get("cirstatus"));
        payBill.set("draftbillno", eleRecDraftBill.get("billno"));
        payBill.set("acceptdate", eleRecDraftBill.get("promisedate"));
        payBill.set("billidentitycode", eleRecDraftBill.get("uniquecode"));
    }

    private static String getDraftBillTranStatus(String ebstatus) {
        switch (ebstatus) {
            case "BANK_SUCCESS": {
                return "success";
            }
            case "BANK_FAIL": {
                return "failing";
            }
        }
        return "handleing";
    }
}

