/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.tradebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeChangeBillHelper {
    private static final Log LOGGER = LogFactory.getLog(TradeChangeBillHelper.class);

    public static void tradeAutoChangeBill(Map<Object, Map<Object, Object>> dataMap) throws KDBizException {
        if (dataMap == null || dataMap.size() == 0) {
            LOGGER.error("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff0c\u7968\u636e\u96c6\u5408\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff0c\u7968\u636e\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"TradeChangeBillService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        HashSet beChangeDraftIdSet = new HashSet(8);
        HashSet toChangeDraftIdSet = new HashSet(8);
        dataMap.values().forEach(map -> {
            beChangeDraftIdSet.addAll(map.keySet());
            toChangeDraftIdSet.addAll(new HashSet(map.values()));
        });
        DynamicObject[] beChangeDraftBills = TmcDataServiceHelper.load((Object[])beChangeDraftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
        Map<Object, DynamicObject> beChangeDraftIdAndDyMap = Arrays.stream(beChangeDraftBills).collect(Collectors.toMap(DataEntityBase::getPkValue, x -> x));
        DynamicObject[] toChangeDraftBills = TmcDataServiceHelper.load((Object[])toChangeDraftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
        Map<Object, DynamicObject> toChangeDraftIdAndDyMap = Arrays.stream(toChangeDraftBills).collect(Collectors.toMap(DataEntityBase::getPkValue, x -> x));
        Object[] tradeIds = dataMap.keySet().toArray();
        Object[] tradeBills = TmcDataServiceHelper.load((Object[])tradeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        if (EmptyUtil.isEmpty((Object[])tradeBills)) {
            LOGGER.error("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u4e1a\u52a1\u5904\u7406\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e1a\u52a1id\u96c6\u5408\uff1a{}", tradeIds);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e1a\u52a1id\u96c6\u5408\uff1a{0}", (String)"TradeChangeBillService_1", (String)"tmc-cdm-business", (Object[])new Object[]{beChangeDraftIdSet}));
        }
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_draftbillchange");
        LOGGER.info("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u4e1a\u52a1\u5904\u7406\u5355\u6570\u91cf\uff1a{}\uff0cid\u6570\u91cf\uff1a{}", (Object)tradeBills.length, (Object)tradeIds.length);
        HashSet changeBillResultSet = new HashSet(8);
        Arrays.stream(tradeBills).forEach(tradeBill -> {
            Object tradeId = tradeBill.getPkValue();
            Map draftIdMap = (Map)dataMap.get(tradeId);
            LOGGER.info("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u5f00\u59cb\u5904\u7406\u4e1a\u52a1\u5355\uff1a{}\uff0c\u88ab\u6362\u7968\u636eid\u548c\u5f85\u6362\u7968\u636eid\u96c6\u5408\uff1a{}", tradeId, (Object)draftIdMap);
            DynamicObjectCollection entries = tradeBill.getDynamicObjectCollection("entrys");
            HashSet changBillDataSet = new HashSet(8);
            entries.forEach(entry -> {
                DynamicObject entryDraftBill = entry.getDynamicObject("draftbill");
                Object entryDraftBillId = entryDraftBill.getPkValue();
                LOGGER.info("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u5f00\u59cb\u5904\u7406\u4e1a\u52a1\u5355\u5206\u5f55\uff1a{}\uff0c\u5206\u5f55\u7968\u636eid\uff1a{}", entry.getPkValue(), entryDraftBillId);
                DynamicObject beChangeDraftBill = (DynamicObject)beChangeDraftIdAndDyMap.get(entryDraftBillId);
                DynamicObject toChangeDraftBill = (DynamicObject)toChangeDraftIdAndDyMap.get(draftIdMap.get(entryDraftBillId));
                if (EmptyUtil.isNoEmpty((DynamicObject)beChangeDraftBill) && EmptyUtil.isNoEmpty((DynamicObject)toChangeDraftBill)) {
                    HashMap<String, DynamicObject> changeBillDataMap = new HashMap<String, DynamicObject>();
                    changeBillDataMap.put("tradeEntry", (DynamicObject)entry);
                    changeBillDataMap.put("beChangeDraftBill", beChangeDraftBill);
                    changeBillDataMap.put("toChangeDraftBill", toChangeDraftBill);
                    changBillDataSet.add(changeBillDataMap);
                }
            });
            if (changBillDataSet.size() > 0) {
                LOGGER.info("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u5f00\u59cb\u5904\u7406\u6362\u7968\u8bb0\u5f55\u5355\uff0c\u4e1a\u52a1\u5355\uff1a{}\uff0c\u5373\u5c06\u4ea7\u751f\u7684\u6362\u7968\u8bb0\u5f55\u5355\u6570\u91cf\uff1a{}", tradeId, (Object)changBillDataSet.size());
                DynamicObject changeBill = new DynamicObject((DynamicObjectType)targetDataEntityType);
                changeBill.set("tradetype", tradeBill.get("tradetype"));
                changeBill.set("tradebillno", tradeBill.get("billno"));
                changeBill.set("company", tradeBill.get("company"));
                changeBill.set("drafttype", tradeBill.get("drafttype"));
                changeBill.set("currency", tradeBill.get("currency"));
                changeBill.set("sourcebillid", tradeBill.getPkValue());
                changeBill.set("bizdate", (Object)new Date());
                changeBill.set("billstatus", (Object)"A");
                changeBill.set("reason", (Object)ResManager.loadKDString((String)"\u81ea\u52a8\u6362\u7968\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355\u3002", (String)"TradeChangeBillHelper_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
                DynamicObjectCollection toChangeEntries = changeBill.getDynamicObjectCollection("havechange_entry");
                changBillDataSet.forEach(data -> {
                    DynamicObject tradeEntry = (DynamicObject)data.get("tradeEntry");
                    DynamicObject beChangeDraftBill = (DynamicObject)data.get("beChangeDraftBill");
                    DynamicObject toChangeDraftBill = (DynamicObject)data.get("toChangeDraftBill");
                    DynamicObject newBeChangeEntry = beChangeEntries.addNew();
                    newBeChangeEntry.set("b_draftbill", (Object)beChangeDraftBill);
                    newBeChangeEntry.set("b_billamt", tradeEntry.get("billamt"));
                    newBeChangeEntry.set("b_billamountfield", beChangeDraftBill.get("amount"));
                    newBeChangeEntry.set("b_subbillrangefield", (Object)beChangeDraftBill.getString("subbillrange"));
                    newBeChangeEntry.set("b_subbillquantityfield", (Object)beChangeDraftBill.getLong("subbillquantity"));
                    newBeChangeEntry.set("b_subbillstartflagfield", (Object)beChangeDraftBill.getLong("subbillstartflag"));
                    newBeChangeEntry.set("b_subbillendflagfield", (Object)beChangeDraftBill.getLong("subbillendflag"));
                    newBeChangeEntry.set("b_oldstatus", (Object)beChangeDraftBill.getString("draftbillstatus"));
                    boolean isSplitAndEleBill = TradeChangeBillHelper.isSplitAndEleBill(tradeBill, beChangeDraftBill);
                    String billEleOldStatus = isSplitAndEleBill ? beChangeDraftBill.getString("eledraftstatusnew") : beChangeDraftBill.getString("eledraftstatus");
                    newBeChangeEntry.set("b_billoldelestatus", (Object)billEleOldStatus);
                    newBeChangeEntry.set("b_billlogid", tradeEntry.get("billlogid"));
                    newBeChangeEntry.set("b_tradeentryid", tradeEntry.getPkValue());
                    DynamicObject newToChangeEntry = toChangeEntries.addNew();
                    newToChangeEntry.set("draftbill", (Object)toChangeDraftBill);
                    newToChangeEntry.set("billamt", toChangeDraftBill.get("amount"));
                    newToChangeEntry.set("billamountfield", toChangeDraftBill.get("amount"));
                    newToChangeEntry.set("subbillrangefield", (Object)toChangeDraftBill.getString("subbillrange"));
                    newToChangeEntry.set("subbillquantityfield", (Object)toChangeDraftBill.getLong("subbillquantity"));
                    newToChangeEntry.set("subbillstartflagfield", (Object)toChangeDraftBill.getLong("subbillstartflag"));
                    newToChangeEntry.set("subbillendflagfield", (Object)toChangeDraftBill.getLong("subbillendflag"));
                    newToChangeEntry.set("oldstatus", (Object)toChangeDraftBill.getString("draftbillstatus"));
                    isSplitAndEleBill = TradeChangeBillHelper.isSplitAndEleBill(tradeBill, toChangeDraftBill);
                    billEleOldStatus = isSplitAndEleBill ? toChangeDraftBill.getString("eledraftstatusnew") : toChangeDraftBill.getString("eledraftstatus");
                    newToChangeEntry.set("billoldelestatus", (Object)billEleOldStatus);
                });
                BigDecimal amount = beChangeEntries.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("b_draftbill"))).map(o -> o.getBigDecimal("b_billamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                int count = beChangeEntries.stream().filter(v -> EmptyUtil.isNoEmpty((DynamicObject)v.getDynamicObject("b_draftbill"))).toArray().length;
                changeBill.set("havechangeamount", (Object)amount);
                changeBill.set("bechangeamount", (Object)amount);
                changeBill.set("havechangecount", (Object)count);
                changeBill.set("bechangecount", (Object)count);
                changeBillResultSet.add(changeBill);
            }
        });
        LOGGER.info("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u5f00\u59cb\u8c03\u7528\u6362\u7968\u8bb0\u5f55\u5355\u4fdd\u5b58\u3001\u63d0\u4ea4\u548c\u5ba1\u6838\u64cd\u4f5c\uff0c\u9700\u5904\u7406\u6761\u6570\uff1a{}", (Object)changeBillResultSet.size());
        if (changeBillResultSet.size() > 0) {
            DynamicObject[] dataEntities = changeBillResultSet.toArray(new DynamicObject[0]);
            boolean successFlag = false;
            OperateOption option = OperateOption.create();
            option.setVariableValue("changeBillWay", "1");
            try (TXHandle tx = TX.required();){
                try {
                    OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cdm_draftbillchange", (DynamicObject[])dataEntities, (OperateOption)option);
                    if (operationResult.isSuccess() && (operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)"cdm_draftbillchange", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)option)).isSuccess()) {
                        operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cdm_draftbillchange", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)option);
                        successFlag = operationResult.isSuccess();
                    }
                    if (!successFlag) {
                        String errorMsg = TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)operationResult);
                        LOGGER.error("[\u4e1a\u52a1\u5904\u7406\u5355\u81ea\u52a8\u6362\u7968\uff0c\u751f\u6210\u6362\u7968\u8bb0\u5f55\u5355]\u8c03\u7528\u6362\u7968\u8bb0\u5f55\u5355\u4fdd\u5b58/\u63d0\u4ea4/\u5ba1\u6838\u5931\u8d25\uff0c\u6210\u529f\u8bb0\u5f55\uff1a{}\uff0c\u4e0d\u6210\u529f\u7684\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)operationResult.getSuccessPkIds(), (Object)TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)operationResult));
                        throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{errorMsg});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static boolean isSplitAndEleBill(DynamicObject tradeBill, DynamicObject draftBill) {
        DynamicObject draftType = tradeBill.getDynamicObject("drafttype");
        return draftBill.getBoolean("issplit") && EmptyUtil.isNoEmpty((DynamicObject)draftType) && StringUtils.equals((CharSequence)draftType.getString("billmedium"), (CharSequence)BillMediumEnum.ELECTRIC.getValue());
    }
}

