/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;

public class EleDraftBillUpdateService {
    private static final Log logger = LogFactory.getLog(EleDraftBillUpdateService.class);

    public String eleDraftBillRejectUpdate(DynamicObject[] claimCenterBills, String rejectOpinion) {
        RpcResult rpcResult = new RpcResult();
        try (TXHandle h = TX.requiresNew((String)"EleDraftBillUpdateService.eleDraftBillRejectUpdate.save");){
            try {
                Object[] ids = Arrays.stream(claimCenterBills).map(o -> o.get("sourceid")).toArray();
                Map signToClaimMap = Stream.of(claimCenterBills).collect(Collectors.toMap(o -> o.get("sourceid"), Function.identity(), (k1, k2) -> k1));
                MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
                DynamicObject[] elcDraftBills = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)dynamicObjectType);
                Arrays.stream(elcDraftBills).forEach(o -> {
                    o.set("signopinion", (Object)"reject");
                    o.set("remark", (Object)rejectOpinion);
                    o.set("username", (Object)RequestContext.get().getUserName());
                });
                try (TXHandle txHandle = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])elcDraftBills);
                }
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                boolean autoClaimNoticeSign = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)elcDraftBills[0].getDynamicObject("company").getLong("id"), (String)"autoclaimnoticesign");
                if (autoClaimNoticeSign) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", "true");
                    operateOption.setVariableValue("opType", "notesigninreject");
                    OperationResult executeOperate = TmcOperateServiceHelper.execOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (DynamicObject[])elcDraftBills, (OperateOption)operateOption);
                    rpcResult.setStatusCode(executeOperate.isSuccess() ? RpcResultStatusCode.SUCCESS : RpcResultStatusCode.ERROR);
                    rpcResult.setMessage(executeOperate.getAllErrorInfo().toString());
                } else {
                    rpcResult.setStatusCode(RpcResultStatusCode.SUCCESS);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                rpcResult.setStatusCode(RpcResultStatusCode.ERROR);
                rpcResult.setMessage(e.getMessage());
                h.markRollback();
                String string = JSON.toJSONString((Object)rpcResult);
                if (h != null) {
                    if (var6_5 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return string;
            }
        }
        return JSON.toJSONString((Object)rpcResult);
    }

    public String eleDraftBillSignUpdate(DynamicObject[] claimCenterBills) {
        RpcResult rpcResult = new RpcResult();
        try {
            Object[] ids = Arrays.stream(claimCenterBills).map(o -> o.get("sourceid")).toArray();
            Map signToClaimMap = Stream.of(claimCenterBills).collect(Collectors.toMap(o -> o.get("sourceid"), Function.identity(), (k1, k2) -> k1));
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
            DynamicObject[] elcDraftBills = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)dynamicObjectType);
            Arrays.stream(elcDraftBills).forEach(o -> {
                o.set("signopinion", (Object)"sign");
                o.set("remark", (Object)o.getString("description"));
                o.set("username", (Object)RequestContext.get().getUserName());
            });
            try (TXHandle txHandle = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])elcDraftBills);
            }
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean autoClaimNoticeSign = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)elcDraftBills[0].getDynamicObject("company").getLong("id"), (String)"autoclaimnoticesign");
            if (autoClaimNoticeSign) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", "true");
                operateOption.setVariableValue("opType", "notesignin");
                OperationResult executeOperate = TmcOperateServiceHelper.execOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (DynamicObject[])elcDraftBills, (OperateOption)operateOption);
                rpcResult.setStatusCode(executeOperate.isSuccess() ? RpcResultStatusCode.SUCCESS : RpcResultStatusCode.ERROR);
                rpcResult.setMessage(executeOperate.getAllErrorInfo().toString());
            } else {
                rpcResult.setStatusCode(RpcResultStatusCode.SUCCESS);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            rpcResult.setStatusCode(RpcResultStatusCode.ERROR);
            rpcResult.setMessage(e.getMessage());
            return JSON.toJSONString((Object)rpcResult);
        }
        return JSON.toJSONString((Object)rpcResult);
    }
}

