/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class PayableBillUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(PayableBillUpgradeService.class);

    public String upgrade() {
        DynamicObject[] payableBills;
        RpcResult result = new RpcResult();
        try {
            DynamicObject[] openBanks;
            QFilter billTypeFilter = new QFilter("billtype", "=", (Object)CdmBizConstant.PAYABLEBILL_BANK);
            QFilter accepterNameFilter = new QFilter("acceptername", "!=", (Object)"").and(new QFilter("acceptername", "is not null", null));
            payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)String.join((CharSequence)",", "id", "accepterfinorg", "acceptername"), (QFilter[])billTypeFilter.and(accepterNameFilter).toArray());
            if (payableBills == null || payableBills.length == 0) {
                return JSON.toJSONString((Object)result);
            }
            List accepterNames = Arrays.stream(payableBills).map(pb -> pb.get("acceptername")).collect(Collectors.toList());
            for (DynamicObject openBank : openBanks = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter("name", "in", accepterNames).toArray())) {
                for (DynamicObject payableBill : payableBills) {
                    if (!Objects.equals(payableBill.get("acceptername"), openBank.getLocaleString("name").getLocaleValue())) continue;
                    payableBill.set("accepterfinorg", (Object)openBank);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(e.getMessage());
            return JSON.toJSONString((Object)result);
        }
        try (TXHandle h = TX.requiresNew((String)"PayableBillUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.save((DynamicObject[])payableBills);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

