/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAutoCollectTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DraftAutoCollectTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        logger.info("\u81ea\u52a8\u7968\u636e\u6258\u6536\u626b\u63cf\u5f00\u59cb...");
        ArrayList<QFilter> tQFilterList = new ArrayList<QFilter>(0);
        tQFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        tQFilterList.add(new QFilter("draftbillstatus", "in", Arrays.asList("registered", "pledged")));
        tQFilterList.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        tQFilterList.add(new QFilter("rptype", "=", (Object)"receivebill"));
        Date today = new Date();
        tQFilterList.add(new QFilter("draftbillexpiredate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        tQFilterList.add(new QFilter("draftbillexpiredate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        DynamicObject[] receivablebill = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billpool,poollockstatus,poollockorg,company", (QFilter[])tQFilterList.toArray(new QFilter[0]));
        HashSet<Long> acollectbillIDs = new HashSet<Long>();
        HashSet<Long> billId = new HashSet<Long>();
        if (receivablebill != null && receivablebill.length > 0) {
            for (DynamicObject recbill : receivablebill) {
                DynamicObject billpool = recbill.getDynamicObject("billpool");
                if (EmptyUtil.isNoEmpty((DynamicObject)billpool)) {
                    if (recbill.getBoolean("poollockstatus")) {
                        String companyId;
                        String poollockorgId = recbill.getDynamicObject("poollockorg").getPkValue().toString();
                        if (!poollockorgId.equals(companyId = recbill.getDynamicObject("company").getPkValue().toString())) continue;
                        billId.add(recbill.getLong("id"));
                        continue;
                    }
                    billId.add(recbill.getLong("id"));
                    continue;
                }
                acollectbillIDs.add(recbill.getLong("id"));
            }
            if (billId.size() > 0) {
                for (Long bId : billId) {
                    OperateOption operateOption;
                    QFilter qFilter;
                    HashSet<Long> bIllIdSet = new HashSet<Long>();
                    bIllIdSet.add(bId);
                    OperateOption opt = OperateOption.create();
                    OperationResult opResult = OperationServiceHelper.executeOperate((String)"pushout", (String)"cdm_receivablebill", (Object[])bIllIdSet.toArray(), (OperateOption)opt);
                    DynamicObject[] outbills = null;
                    if (!opResult.isSuccess() || (outbills = BusinessDataServiceHelper.load((String)"cdm_billpoolbiz", (String)"id", (QFilter[])(qFilter = new QFilter("sourcebillid", "in", bIllIdSet)).toArray())) == null) continue;
                    OperationResult result = null;
                    Object[] outBillIds = Arrays.stream(outbills).map(DataEntityBase::getPkValue).toArray();
                    result = OperateServiceHelper.execOperate((String)"submit", (String)"cdm_billpoolbiz", (Object[])outBillIds, (OperateOption)(operateOption = OperateOption.create()));
                    if (!result.isSuccess() || !(result = OperateServiceHelper.execOperate((String)"audit", (String)"cdm_billpoolbiz", (Object[])outBillIds, (OperateOption)operateOption)).isSuccess()) continue;
                    acollectbillIDs.add(bId);
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", DraftTradeTypeEnum.COLLECT.getValue());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"autocollect", (String)"cdm_receivablebill", (Object[])acollectbillIDs.toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                logger.info("autocollect error:" + operationResult.getMessage());
            }
        }
        logger.info("\u81ea\u52a8\u7968\u636e\u6258\u6536\u5904\u7406\u7ed3\u675f...");
    }
}

